/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityProvider;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.content.item.weapon.crossbow.BaseCrossbow;

public final class ModelProperties {
    public static void init() {
        ModelProperties.registerBows((BaseBow)((Object)AoAWeapons.ALACRITY_BOW.get()), (BaseBow)((Object)AoAWeapons.ANCIENT_BOW.get()), (BaseBow)((Object)AoAWeapons.ATLANTIC_BOW.get()), (BaseBow)((Object)AoAWeapons.BARON_BOW.get()), (BaseBow)((Object)AoAWeapons.BOREIC_BOW.get()), (BaseBow)((Object)AoAWeapons.DAYBREAKER_BOW.get()), (BaseBow)((Object)AoAWeapons.DEEP_BOW.get()), (BaseBow)((Object)AoAWeapons.EXPLOSIVE_BOW.get()), (BaseBow)((Object)AoAWeapons.HAUNTED_BOW.get()), (BaseBow)((Object)AoAWeapons.ICE_BOW.get()), (BaseBow)((Object)AoAWeapons.INFERNAL_BOW.get()), (BaseBow)((Object)AoAWeapons.JUSTICE_BOW.get()), (BaseBow)((Object)AoAWeapons.LUNAR_BOW.get()), (BaseBow)((Object)AoAWeapons.MECHA_BOW.get()), (BaseBow)((Object)AoAWeapons.NIGHTMARE_BOW.get()), (BaseBow)((Object)AoAWeapons.POISON_BOW.get()), (BaseBow)((Object)AoAWeapons.PREDATIOUS_BOW.get()), (BaseBow)((Object)AoAWeapons.PRIMORDIAL_BOW.get()), (BaseBow)((Object)AoAWeapons.ROSIDIAN_BOW.get()), (BaseBow)((Object)AoAWeapons.RUNIC_BOW.get()), (BaseBow)((Object)AoAWeapons.SCREAMER_BOW.get()), (BaseBow)((Object)AoAWeapons.SHYREGEM_BOW.get()), (BaseBow)((Object)AoAWeapons.SKELETAL_BOW.get()), (BaseBow)((Object)AoAWeapons.SKYDRIVER_BOW.get()), (BaseBow)((Object)AoAWeapons.SLINGSHOT.get()), (BaseBow)((Object)AoAWeapons.SOULFIRE_BOW.get()), (BaseBow)((Object)AoAWeapons.SPECTRAL_BOW.get()), (BaseBow)((Object)AoAWeapons.SPEED_BOW.get()), (BaseBow)((Object)AoAWeapons.SUNSHINE_BOW.get()), (BaseBow)((Object)AoAWeapons.TOXIN_BOW.get()), (BaseBow)((Object)AoAWeapons.VOID_BOW.get()), (BaseBow)((Object)AoAWeapons.WEAKEN_BOW.get()), (BaseBow)((Object)AoAWeapons.WITHER_BOW.get()));
        ModelProperties.registerCrossbows((BaseCrossbow)((Object)AoAWeapons.CORAL_CROSSBOW.get()), (BaseCrossbow)((Object)AoAWeapons.LUNAR_CROSSBOW.get()), (BaseCrossbow)((Object)AoAWeapons.MECHA_CROSSBOW.get()), (BaseCrossbow)((Object)AoAWeapons.PYRO_CROSSBOW.get()), (BaseCrossbow)((Object)AoAWeapons.ROSIDIAN_CROSSBOW.get()), (BaseCrossbow)((Object)AoAWeapons.SKELETAL_CROSSBOW.get()), (BaseCrossbow)((Object)AoAWeapons.SPECTRAL_CROSSBOW.get()), (BaseCrossbow)((Object)AoAWeapons.TROLLS_CROSSBOW.get()), (BaseCrossbow)((Object)AoAWeapons.VIRAL_CROSSBOW.get()));
        ModelProperties.registerExpFlask();
        ModelProperties.registerParalyzer();
        ModelProperties.registerKnightsGuard();
        ModelProperties.registerGuardiansSword();
        ModelProperties.registerRods();
    }

    private static void registerBows(BaseBow ... bows) {
        for (BaseBow bow : bows) {
            ModelProperties.registerItemProperty((Item)bow, "pull", (stack, world, entity, seed) -> {
                if (entity == null || entity.m_21211_() != stack) {
                    return 0.0f;
                }
                return ((BaseBow)stack.m_41720_()).getDrawSpeedMultiplier() * (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f;
            });
            ModelProperties.registerItemProperty((Item)bow, "pulling", (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        }
    }

    private static void registerCrossbows(BaseCrossbow ... crossbows) {
        for (BaseCrossbow crossbow : crossbows) {
            ModelProperties.registerItemProperty((Item)crossbow, "pull", (stack, world, entity, seed) -> {
                if (entity == null || CrossbowItem.m_40932_((ItemStack)stack)) {
                    return 0.0f;
                }
                return (float)(stack.m_41779_() - entity.m_21212_()) / (float)CrossbowItem.m_40939_((ItemStack)stack);
            });
            ModelProperties.registerItemProperty((Item)crossbow, "pulling", (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
            ModelProperties.registerItemProperty((Item)crossbow, "charged", (stack, world, entity, seed) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
            ModelProperties.registerItemProperty((Item)crossbow, "firework", (stack, world, entity, seed) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
        }
    }

    private static void registerItemProperty(Item item, String propertyName, ItemPropertyFunction propertyProvider) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyName), (ItemPropertyFunction)propertyProvider);
    }

    private static void registerExpFlask() {
        ModelProperties.registerItemProperty((Item)AoATools.EXP_FLASK.get(), "filled", (stack, world, entity, seed) -> {
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            return cap.getValue() <= 0.0f ? 0.0f : 1.0f;
        });
    }

    private static void registerParalyzer() {
        ModelProperties.registerItemProperty((Item)AoAWeapons.PARALYZER.get(), "firing", (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ModelProperties.registerItemProperty((Item)AoAWeapons.PARALYZER.get(), "firing_tick_modulo", (stack, world, entity, seed) -> {
            if (entity == null || stack != entity.m_21211_()) {
                return 0.0f;
            }
            return entity.m_21212_() % 3;
        });
    }

    private static void registerKnightsGuard() {
        ModelProperties.registerItemProperty((Item)AoAWeapons.KNIGHTS_GUARD.get(), "blocking", (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    private static void registerGuardiansSword() {
        ModelProperties.registerItemProperty((Item)AoAWeapons.GUARDIANS_SWORD.get(), "charged", (stack, world, entity, seed) -> {
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            return cap.getValue() <= 0.0f ? 0.0f : 1.0f;
        });
    }

    private static void registerRods() {
        ItemPropertyFunction predicateHandler = (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return (entity.m_21205_() == stack || entity.m_21206_() == stack && !(entity.m_21205_().m_41720_() instanceof FishingRodItem)) && entity instanceof Player && ((Player)entity).f_36083_ != null ? 1.0f : 0.0f;
        };
        ModelProperties.registerItemProperty((Item)AoATools.HAULING_ROD.get(), "cast", predicateHandler);
        ModelProperties.registerItemProperty((Item)AoATools.GOLDEN_ROD.get(), "cast", predicateHandler);
        ModelProperties.registerItemProperty((Item)AoATools.LIGHT_ROD.get(), "cast", predicateHandler);
        ModelProperties.registerItemProperty((Item)AoATools.THERMALLY_INSULATED_ROD.get(), "cast", predicateHandler);
    }
}

