/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud.toasts;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.aoa3.util.RenderUtil;

public class ResourceRequirementToast
implements Toast {
    private final AoAResource resource;
    private final float resourceAmount;
    private final String title;
    private final String subtitle;

    public ResourceRequirementToast(AoAResource relevantResource, float resourceRequirement) {
        this.resource = relevantResource;
        this.resourceAmount = resourceRequirement;
        this.title = LocaleUtil.getLocaleString("gui.aoatoast.resourceReq.title", ChatFormatting.DARK_RED, new String[0]);
        this.subtitle = LocaleUtil.getLocaleString("gui.aoatoast.resourceReq.subtitle", relevantResource.getName().getString(), NumberUtil.roundToNthDecimalPlace(resourceRequirement, 2));
    }

    public AoAResource getResource() {
        return this.resource;
    }

    public float getAmountRequired() {
        return this.resourceAmount;
    }

    public Toast.Visibility m_7172_(PoseStack matrix, ToastComponent toastGui, long delta) {
        if (RegistryUtil.getId(this.resource) == null) {
            return Toast.Visibility.HIDE;
        }
        Minecraft mc = toastGui.m_94929_();
        RenderUtil.prepRenderTexture(f_94893_);
        RenderUtil.resetShaderColour();
        toastGui.m_93228_(matrix, 0, 0, 0, 0, 160, 32);
        matrix.m_85836_();
        matrix.m_85841_(0.9f, 0.9f, 1.0f);
        matrix.m_85837_(5.5, 5.0, 0.0);
        AoAGuiElementRenderers.getResourceRenderer(this.resource).renderInHud(matrix, ClientPlayerDataManager.get().getResource(this.resource), mc.m_91297_(), "-1");
        matrix.m_85849_();
        mc.f_91062_.m_92883_(matrix, this.title, 30.0f, 7.0f, -11534256);
        int subtitleWidth = mc.f_91062_.m_92895_(this.subtitle);
        if ((float)subtitleWidth <= 125.0f) {
            mc.f_91062_.m_92883_(matrix, this.subtitle, 30.0f, 18.0f, ColourUtil.WHITE);
        } else {
            matrix.m_85836_();
            float scale = 125.0f / (float)subtitleWidth;
            matrix.m_85841_(scale, scale, 1.0f);
            mc.f_91062_.m_92883_(matrix, this.subtitle, 30.0f / scale, 18.0f / scale, ColourUtil.WHITE);
            matrix.m_85849_();
        }
        return delta >= 3000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

