/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.entities.villager.SkiesVillagerTrades;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.util.GelCollectors;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegisterEvent;

public class SkiesVillagers {
    public static final Lazy<VillagerProfession> STARGAZER = SkiesVillagers.createProfession("stargazer", SkiesPoiTypes.STAR_EMITTER, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), () -> SkiesSounds.ENTITY_VILLAGER_WORK_STARGAZER);
    public static final Lazy<VillagerProfession> WRANGLER = SkiesVillagers.createProfession("wrangler", SkiesPoiTypes.TROUGH, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), () -> SkiesSounds.ENTITY_VILLAGER_WORK_WRANGLER);
    public static final Lazy<VillagerProfession> SHOVELER = SkiesVillagers.createProfession("shoveler", SkiesPoiTypes.TOOL_BOX, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of((Object)SkiesBlocks.coarse_turquoise_dirt, (Object)Blocks.f_50125_), () -> SkiesSounds.ENTITY_VILLAGER_WORK_SHOVELER);
    public static final Lazy<VillagerProfession> NIGHTWATCHER = SkiesVillagers.createProfession("nightwatcher", SkiesPoiTypes.BAG_OF_SPOILS, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), () -> SkiesSounds.ENTITY_VILLAGER_WORK_NIGHTWATCHER);
    public static final Lazy<VillagerProfession> SUMMONER = SkiesVillagers.createProfession("summoner", SkiesPoiTypes.SUMMONING_TABLE, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), () -> SkiesSounds.ENTITY_VILLAGER_WORK_SUMMONER);
    public static final Lazy<VillagerProfession> ALCHEMIST = SkiesVillagers.createProfession("alchemist", SkiesPoiTypes.ALCHEMY_TABLE, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), () -> SkiesSounds.ENTITY_VILLAGER_WORK_ALCHEMIST);
    public static final Set<VillagerType> SKIES_TYPES = Sets.newHashSet();
    public static VillagerType CALMING_SKIES;
    public static VillagerType BRIGHTLANDS;
    public static VillagerType SLUSHLANDS;
    public static VillagerType UNORTHODOX_VALLEY;
    public static VillagerType SHADED_WOODLANDS;
    public static VillagerType CRYSTAL_DUNES;
    public static VillagerType SUNSET_MAPLE_FOREST;

    public static void init(RegisterEvent event) {
        SkiesVillagers.registerProf(event, "stargazer", STARGAZER);
        SkiesVillagers.registerProf(event, "wrangler", WRANGLER);
        SkiesVillagers.registerProf(event, "shoveler", SHOVELER);
        SkiesVillagers.registerProf(event, "nightwatcher", NIGHTWATCHER);
        SkiesVillagers.registerProf(event, "summoner", SUMMONER);
        SkiesVillagers.registerProf(event, "alchemist", ALCHEMIST);
        SkiesVillagers.registerTrades(STARGAZER, SkiesVillagerTrades.STARGAZER_OFFERS);
        SkiesVillagers.registerTrades(WRANGLER, SkiesVillagerTrades.WRANGLER_OFFERS);
        SkiesVillagers.registerTrades(SHOVELER, SkiesVillagerTrades.SHOVELER_OFFERS);
        SkiesVillagers.registerTrades(NIGHTWATCHER, SkiesVillagerTrades.NIGHTWATCHER_OFFERS);
        SkiesVillagers.registerTrades(SUMMONER, SkiesVillagerTrades.SUMMONER_OFFERS);
        SkiesVillagers.registerTrades(ALCHEMIST, SkiesVillagerTrades.ALCHEMIST_OFFERS);
        SkiesVillagers.registerGifts(STARGAZER, SkiesLootProv.STARGAZER_GIFTS);
        SkiesVillagers.registerGifts(WRANGLER, SkiesLootProv.WRANGLER_GIFTS);
        SkiesVillagers.registerGifts(SHOVELER, SkiesLootProv.SHOVELER_GIFTS);
        SkiesVillagers.registerGifts(SUMMONER, SkiesLootProv.SUMMONER_GIFTS);
        SkiesVillagers.registerGifts(ALCHEMIST, SkiesLootProv.ALCHEMIST_GIFTS);
        SkiesVillagers.initFoodItem(SkiesItems.solnut, 1);
        SkiesVillagers.initFoodItem(SkiesItems.cryo_root, 1);
        SkiesVillagers.initItemPickup(SkiesItems.winter_leaf_seeds);
        SkiesVillagers.initFoodItem(SkiesItems.winter_leaves, 2);
        SkiesVillagers.initItemPickup(SkiesItems.pine_fruit_seeds);
        SkiesVillagers.initFoodItem(SkiesItems.pine_fruit, 2);
        SkiesVillagers.initItemPickup(SkiesItems.fiery_bean_seeds);
        SkiesVillagers.initFoodItem(SkiesItems.fiery_beans, 1);
        SkiesVillagers.initItemPickup(SkiesItems.scalefruit_seeds);
        SkiesVillagers.initFoodItem(SkiesItems.scalefruit, 2);
    }

    private static void registerProf(RegisterEvent event, String name, Lazy<VillagerProfession> prof) {
        event.register(Registry.f_122809_, BlueSkies.locate(name), prof);
    }

    public static void initVillagerTypes() {
        BlueSkies.LOGGER.debug("Registering villager types: " + VillagerTrades.f_35627_.size());
        CALMING_SKIES = SkiesVillagers.registerType("calming_skies");
        BRIGHTLANDS = SkiesVillagers.registerType("brightlands");
        SLUSHLANDS = SkiesVillagers.registerType("slushlands");
        UNORTHODOX_VALLEY = SkiesVillagers.registerType("unorthodox_valley");
        SHADED_WOODLANDS = SkiesVillagers.registerType("shaded_woodlands");
        CRYSTAL_DUNES = SkiesVillagers.registerType("crystal_dunes");
        SUNSET_MAPLE_FOREST = SkiesVillagers.registerType("sunset_maple_forest");
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.CALMING_SKIES.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.BRIGHTLANDS.getKey(), BRIGHTLANDS);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.SNOW_COVERED_PINES.getKey(), BRIGHTLANDS);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.FROSTBITTEN_FOREST.getKey(), BRIGHTLANDS);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.MIDDAY_SHORE.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.PEEKING_OCEAN.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.SLUSHLANDS.getKey(), SLUSHLANDS);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.POLAR_HIGHLAND.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.BRISK_MEADOW.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.DEEP_PEEKING_OCEAN.getKey(), CALMING_SKIES);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.UNORTHODOX_VALLEY.getKey(), UNORTHODOX_VALLEY);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.SHADED_WOODLANDS.getKey(), SHADED_WOODLANDS);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.CRYSTAL_DUNES.getKey(), CRYSTAL_DUNES);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.SUNSET_MAPLE_FOREST.getKey(), SUNSET_MAPLE_FOREST);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.MOONLIT_RESERVOIR.getKey(), SHADED_WOODLANDS);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.RISING_CREEK.getKey(), UNORTHODOX_VALLEY);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.CRYSTAL_ROUGHS.getKey(), CRYSTAL_DUNES);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.SEARING_GRASSLAND.getKey(), SUNSET_MAPLE_FOREST);
        SkiesVillagers.putTypeToBiome((ResourceKey<Biome>)SkiesBiomes.CRESCENT_ORCHARD.getKey(), UNORTHODOX_VALLEY);
    }

    public static void putTypeToBiome(ResourceKey<Biome> biomeIn, VillagerType type) {
        VillagerType.f_35827_.put(biomeIn, type);
    }

    public static void registerTrades(Lazy<VillagerProfession> prof, Int2ObjectMap<VillagerTrades.ItemListing[]> tradeMap) {
        VillagerTrades.f_35627_.put((VillagerProfession)prof.get(), tradeMap);
    }

    public static void registerGifts(Lazy<VillagerProfession> prof, ResourceLocation giftTable) {
        GiveGiftToHero.f_147550_.put((VillagerProfession)prof.get(), giftTable);
    }

    public static VillagerType registerType(String key) {
        VillagerType type = (VillagerType)Registry.m_122965_((Registry)Registry.f_122868_, (ResourceLocation)BlueSkies.locate(key), (Object)new VillagerType(key));
        SKIES_TYPES.add(type);
        return type;
    }

    public static Lazy<VillagerProfession> createProfession(String name, Registrar.Static<PoiType> pointOfInterest, ImmutableSet<Item> specificItems, ImmutableSet<Block> relatedWorldBlocks, Supplier<SoundEvent> sound) {
        return Lazy.of(() -> new VillagerProfession(name, p -> p.m_203565_(pointOfInterest.getKey()), p -> p.m_203565_(pointOfInterest.getKey()), specificItems, relatedWorldBlocks, (SoundEvent)sound.get()));
    }

    static void initItemPickup(Item item) {
        Villager.f_35372_ = GelCollectors.merge((Set)Villager.f_35372_, (Object)item);
    }

    static void initFoodItem(Item item, int efficiency) {
        Villager.f_35369_ = GelCollectors.merge((Map)Villager.f_35369_, (Object)item, (Object)efficiency);
        SkiesVillagers.initItemPickup(item);
    }
}

