/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.SkiesChunkGenerator;
import com.legacy.blue_skies.world.SkiesSurfaceRuleData;
import com.legacy.blue_skies.world.everbright.biome.provider.EverbrightBiomeSource;
import com.legacy.blue_skies.world.everdawn.biome.provider.EverdawnBiomeSource;
import com.legacy.structure_gel.api.dimension.DimensionAccessHelper;
import com.legacy.structure_gel.api.dimension.DimensionTypeBuilder;
import com.legacy.structure_gel.api.registry.registrar.DimensionRegistrar;
import java.util.OptionalLong;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SkiesDimensions {
    public static final ResourceLocation EVERBRIGHT_ID = BlueSkies.locate("everbright");
    public static final ResourceLocation EVERDAWN_ID = BlueSkies.locate("everdawn");
    private static final DimensionRegistrar EVERBRIGHT = SkiesDimensions.createEverbright();
    private static final DimensionRegistrar EVERDAWN = SkiesDimensions.createEverdawn();

    public static void init() {
    }

    private static DimensionRegistrar createEverbright() {
        Supplier<DimensionType> dimType = () -> DimensionTypeBuilder.of().fixedTime(OptionalLong.of(6000L)).minY(0).effects(EVERBRIGHT_ID).build();
        Supplier<NoiseGeneratorSettings> noiseSettings = () -> DimensionAccessHelper.newDimensionSettings((NoiseSettings)SkiesDimensions.dummyNoise(), (BlockState)SkiesBlocks.turquoise_stone.m_49966_(), (BlockState)Blocks.f_49990_.m_49966_(), (NoiseRouter)DimensionAccessHelper.noneNoiseRouter(), (SurfaceRules.RuleSource)SkiesSurfaceRuleData.everbright(false, false, true), (int)63, (boolean)false);
        BiFunction<RegistryAccess, WorldGenSettings, ChunkGenerator> chunkGen = (access, genSettings) -> {
            Registry structureSets = access.m_175515_(Registry.f_211073_);
            Registry noises = access.m_175515_(Registry.f_194568_);
            Registry noiseGenSettings = access.m_175515_(Registry.f_122878_);
            Registry biomes = access.m_175515_(Registry.f_122885_);
            NoiseSettings dimNoiseSettings = ((NoiseGeneratorSettings)EVERBRIGHT.getNoiseSettings().get(noiseGenSettings)).f_64439_();
            long seed = genSettings.m_64619_() + 80085L;
            return new SkiesChunkGenerator((Registry<StructureSet>)structureSets, (Registry<NormalNoise.NoiseParameters>)noises, new EverbrightBiomeSource((Registry<Biome>)biomes, seed, dimNoiseSettings.f_158688_(), dimNoiseSettings.f_64508_()), seed, (Holder<NoiseGeneratorSettings>)noiseGenSettings.m_206081_(EVERBRIGHT.getNoiseSettings().getKey()));
        };
        return new DimensionRegistrar(EVERBRIGHT_ID, dimType, noiseSettings, chunkGen);
    }

    private static DimensionRegistrar createEverdawn() {
        Supplier<DimensionType> dimType = () -> DimensionTypeBuilder.of().fixedTime(OptionalLong.of(23200L)).minY(0).effects(EVERDAWN_ID).build();
        Supplier<NoiseGeneratorSettings> noiseSettings = () -> DimensionAccessHelper.newDimensionSettings((NoiseSettings)SkiesDimensions.dummyNoise(), (BlockState)SkiesBlocks.lunar_stone.m_49966_(), (BlockState)Blocks.f_49990_.m_49966_(), (NoiseRouter)DimensionAccessHelper.noneNoiseRouter(), (SurfaceRules.RuleSource)SkiesSurfaceRuleData.everdawn(false, false, true), (int)63, (boolean)false);
        BiFunction<RegistryAccess, WorldGenSettings, ChunkGenerator> chunkGen = (access, genSettings) -> {
            Registry structureSets = access.m_175515_(Registry.f_211073_);
            Registry noises = access.m_175515_(Registry.f_194568_);
            Registry noiseGenSettings = access.m_175515_(Registry.f_122878_);
            Registry biomes = access.m_175515_(Registry.f_122885_);
            NoiseSettings dimNoiseSettings = ((NoiseGeneratorSettings)EVERDAWN.getNoiseSettings().get(noiseGenSettings)).f_64439_();
            long seed = genSettings.m_64619_() + 1337L;
            return new SkiesChunkGenerator((Registry<StructureSet>)structureSets, (Registry<NormalNoise.NoiseParameters>)noises, new EverdawnBiomeSource((Registry<Biome>)biomes, seed, dimNoiseSettings.f_158688_(), dimNoiseSettings.f_64508_()), seed, (Holder<NoiseGeneratorSettings>)noiseGenSettings.m_206081_(EVERDAWN.getNoiseSettings().getKey()));
        };
        return new DimensionRegistrar(EVERDAWN_ID, dimType, noiseSettings, chunkGen);
    }

    private static NoiseSettings dummyNoise() {
        return NoiseSettings.m_224525_((int)0, (int)384, (int)1, (int)2);
    }

    public static ResourceKey<Level> everbrightKey() {
        return EVERBRIGHT.getLevelKey();
    }

    public static ResourceKey<Level> everdawnKey() {
        return EVERDAWN.getLevelKey();
    }

    public static boolean inSkyDimension(@Nullable Entity entity) {
        return entity != null && SkiesDimensions.inSkyDimension((ResourceKey<Level>)entity.f_19853_.m_46472_());
    }

    public static boolean inSkyDimension(ResourceKey<Level> levelKey) {
        return levelKey.equals(SkiesDimensions.everbrightKey()) || levelKey.equals(SkiesDimensions.everdawnKey());
    }
}

