/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mod_compat.jei.category;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.FreezingRecipe;
import com.legacy.blue_skies.mod_compat.jei.category.SkiesCategory;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class SnowcapOvenFreezingCategory
extends SkiesCategory<FreezingRecipe> {
    public static final RecipeType<FreezingRecipe> TYPE = RecipeType.create((String)"blue_skies", (String)"snowcap_oven_freezing", FreezingRecipe.class);
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/gui/jei/snowcap_oven_freezing.png");
    private final IDrawableBuilder flameBuilder;
    private final Map<Item, IDrawableAnimated> flames;

    public SnowcapOvenFreezingCategory(IGuiHelper guiHelper) {
        super(guiHelper, (ItemLike)SkiesBlocks.snowcap_oven, TEXTURE, 92, 50);
        this.flameBuilder = guiHelper.drawableBuilder(TEXTURE, 92, 0, 14, 14);
        this.flames = new HashMap<Item, IDrawableAnimated>();
    }

    public RecipeType<FreezingRecipe> getRecipeType() {
        return TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder layout, FreezingRecipe recipe, IFocusGroup focusGroup) {
        this.input(layout, 6, 28, recipe.inputItem);
        if (!recipe.getOutput().m_41619_()) {
            this.output(layout, 66, 24, recipe.getOutput());
        }
    }

    public void draw(FreezingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        IDrawableAnimated flame = this.flames.computeIfAbsent(recipe.inputItem, i -> this.flameBuilder.buildAnimated(recipe.fuelAmount, IDrawableAnimated.StartDirection.TOP, true));
        flame.draw(poseStack, 7, 11);
        Minecraft mc = Minecraft.m_91087_();
        Component smeltCountText = SnowcapOvenFreezingCategory.createSmeltCountText(recipe.fuelAmount);
        mc.f_91062_.m_92889_(poseStack, smeltCountText, 2.0f, 1.0f, -8355712);
    }

    public static Component createSmeltCountText(int burnTime) {
        if (burnTime == 200) {
            return Component.m_237115_((String)"gui.jei.category.fuel.smeltCount.single");
        }
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String smeltCount = numberInstance.format((float)burnTime / 200.0f);
        return Component.m_237110_((String)"gui.jei.category.fuel.smeltCount", (Object[])new Object[]{smeltCount});
    }
}

