/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import com.legacy.blue_skies.util.ListSet;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class CatylistRecipe
extends AlchemyRecipe {
    private static final Codec<CatylistRecipe> CODEC = RecordCodecBuilder.create(instance -> {
        Products.P2 parent = CatylistRecipe.parentCodec(instance);
        return instance.group(parent.t1(), parent.t2(), (App)Registry.f_122827_.m_194605_().optionalFieldOf("input").forGetter(r -> r.input), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("inputs", List.of()).forGetter(r -> r.inputs), (App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).listOf().optionalFieldOf("input_tags", List.of()).forGetter(r -> r.inputTags), (App)Registry.f_122827_.m_194605_().optionalFieldOf("catylist").forGetter(r -> r.catylist), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("catylists", List.of()).forGetter(r -> r.catylists), (App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).listOf().optionalFieldOf("catylist_tags", List.of()).forGetter(r -> r.catylistTags), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("results", List.of()).forGetter(r -> r.results), (App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).listOf().optionalFieldOf("results_tags", List.of()).forGetter(r -> r.resultsTags)).apply((Applicative)instance, CatylistRecipe::new);
    });
    @Deprecated
    private final Optional<Item> input;
    private final List<ResourceLocation> inputs;
    private final List<TagKey<Item>> inputTags;
    @Deprecated
    private final Optional<Item> catylist;
    private final List<ResourceLocation> catylists;
    private final List<TagKey<Item>> catylistTags;
    private final List<ResourceLocation> results;
    private final List<TagKey<Item>> resultsTags;
    @Nullable
    private ListSet<Item> cachedInput = null;
    @Nullable
    private ListSet<Item> cachedCatylist = null;
    @Nullable
    private ListSet<Item> cachedResults = null;

    private CatylistRecipe(boolean shouldOverride, ResourceLocation type, Optional<Item> input, List<ResourceLocation> inputs, List<TagKey<Item>> inputTags, Optional<Item> catylist, List<ResourceLocation> catylists, List<TagKey<Item>> catylistTags, List<ResourceLocation> results, List<TagKey<Item>> resultsTags) {
        super(shouldOverride, type);
        this.input = input;
        this.inputs = new ArrayList<ResourceLocation>(inputs);
        this.inputTags = new ArrayList<TagKey<Item>>(inputTags);
        this.catylist = catylist;
        this.catylists = new ArrayList<ResourceLocation>(catylists);
        this.catylistTags = new ArrayList<TagKey<Item>>(catylistTags);
        this.results = new ArrayList<ResourceLocation>(results);
        this.resultsTags = new ArrayList<TagKey<Item>>(resultsTags);
    }

    private CatylistRecipe(Builder builder) {
        this(builder.shouldOverride, BlueSkies.locate("catylist"), Optional.empty(), builder.inputs, builder.inputTags, Optional.empty(), builder.catylists, builder.catylistTags, builder.results, builder.resultsTags);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public List<Item> getInput() {
        if (this.cachedInput == null) {
            this.cachedInput = CatylistRecipe.computeValues(this.inputs, this.inputTags, this.input);
        }
        return this.cachedInput;
    }

    public List<Item> getCatylist() {
        if (this.cachedCatylist == null) {
            this.cachedCatylist = CatylistRecipe.computeValues(this.catylists, this.catylistTags, this.catylist);
        }
        return this.cachedCatylist;
    }

    @Override
    public List<Item> getResults(Item inputA, Item inputB) {
        return this.getResults();
    }

    @Override
    public List<Item> getResults() {
        if (this.cachedResults == null) {
            this.cachedResults = CatylistRecipe.computeValues(this.results, this.resultsTags);
        }
        return this.cachedResults.clone();
    }

    @Override
    public void mergeRecipe(AlchemyRecipe recipe) {
        if (recipe instanceof CatylistRecipe) {
            CatylistRecipe other = (CatylistRecipe)recipe;
            this.inputs.addAll(other.inputs);
            this.inputTags.addAll(other.inputTags);
            this.catylists.addAll(other.catylists);
            this.catylistTags.addAll(other.catylistTags);
            this.results.addAll(other.results);
            this.resultsTags.addAll(other.resultsTags);
        }
    }

    @Override
    public boolean matches(Item itemA, Item itemB) {
        return this.getInput().contains(itemA) && this.getCatylist().contains(itemB);
    }

    @Override
    public CatylistRecipe fromJson(JsonObject json) throws SkiesDataManager.RegistryObjectNotFoundException {
        return (CatylistRecipe)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, JsonParseException::new)).getFirst();
    }

    @Override
    public JsonObject toJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(false, IllegalStateException::new)).getAsJsonObject();
    }

    public static final class Builder {
        private final String name;
        private boolean shouldOverride = false;
        private final List<ResourceLocation> inputs = new ArrayList<ResourceLocation>();
        private final List<TagKey<Item>> inputTags = new ArrayList<TagKey<Item>>();
        private final List<ResourceLocation> catylists = new ArrayList<ResourceLocation>();
        private final List<TagKey<Item>> catylistTags = new ArrayList<TagKey<Item>>();
        private final List<ResourceLocation> results = new ArrayList<ResourceLocation>();
        private final List<TagKey<Item>> resultsTags = new ArrayList<TagKey<Item>>();

        private Builder(String name) {
            this.name = name;
        }

        public Builder shouldOverride() {
            this.shouldOverride = true;
            return this;
        }

        public Builder input(ItemLike ... items) {
            for (ItemLike item : items) {
                this.inputs.add(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
            }
            return this;
        }

        public Builder input(List<ItemLike> items) {
            return this.input((ItemLike[])items.toArray(ItemLike[]::new));
        }

        public Builder input(TagKey<Item> itemTag) {
            this.inputTags.add(itemTag);
            return this;
        }

        public Builder catylist(ItemLike ... items) {
            for (ItemLike item : items) {
                this.catylists.add(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
            }
            return this;
        }

        public Builder catylist(List<ItemLike> items) {
            return this.catylist((ItemLike[])items.toArray(ItemLike[]::new));
        }

        public Builder catylist(TagKey<Item> itemTag) {
            this.catylistTags.add(itemTag);
            return this;
        }

        public Builder results(ItemLike ... items) {
            for (ItemLike item : items) {
                this.results.add(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
            }
            return this;
        }

        public Builder results(List<ItemLike> items) {
            return this.results((ItemLike[])items.toArray(ItemLike[]::new));
        }

        public Builder results(TagKey<Item> itemTag) {
            this.resultsTags.add(itemTag);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public CatylistRecipe build() {
            if (this.inputs.isEmpty() && this.inputTags.isEmpty()) {
                throw new IllegalStateException("Catylist recipe with name " + this.name + " had no inputs");
            }
            if (this.catylists.isEmpty() && this.catylistTags.isEmpty()) {
                throw new IllegalStateException("Catylist recipe with name " + this.name + " had no catylists");
            }
            if (this.results.isEmpty() && this.resultsTags.isEmpty()) {
                throw new IllegalStateException("Catylist recipe with name " + this.name + " had no results");
            }
            return new CatylistRecipe(this);
        }
    }
}

