/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.init;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.blocks.natural.GlimmerReedBlock;
import com.legacy.blue_skies.blocks.natural.SkyLeavesBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.event.ModelEvent;

public class SkiesBlockModels {
    private static final ModelResourceLocation HALLOWEEN_GLIMMER_REED = new ModelResourceLocation(BlueSkies.locate("glimmer_reed_halloween"), "");
    private static final ModelResourceLocation XMAS_STARLIT_LEAVES = new ModelResourceLocation(BlueSkies.locate("starlit_leaves_xmas"), "");
    private static final ModelResourceLocation XMAS_STARLIT_LEAVES_SNOWY = new ModelResourceLocation(BlueSkies.locate("starlit_leaves_snowy_xmas"), "");

    public static void modelRegistry(ModelEvent.RegisterAdditional event) {
        for (ModelResourceLocation location : new ModelResourceLocation[]{HALLOWEEN_GLIMMER_REED, XMAS_STARLIT_LEAVES, XMAS_STARLIT_LEAVES_SNOWY}) {
            event.register((ResourceLocation)location);
        }
    }

    public static void onModelBake(ModelEvent.BakingCompleted event) {
        if (BlueSkiesConfig.COMMON.isHalloween()) {
            for (BlockState state : SkiesBlocks.glimmer_reed.m_49965_().m_61056_()) {
                if (!((Boolean)state.m_61143_((Property)GlimmerReedBlock.TOP)).booleanValue()) continue;
                SkiesBlockModels.swapModel(event, state, HALLOWEEN_GLIMMER_REED);
            }
        }
        if (BlueSkiesConfig.COMMON.isChristmas()) {
            for (BlockState state : SkiesBlocks.starlit_leaves.m_49965_().m_61056_()) {
                if (((Boolean)state.m_61143_((Property)SkyLeavesBlock.SNOWY)).booleanValue()) {
                    SkiesBlockModels.swapModel(event, state, XMAS_STARLIT_LEAVES_SNOWY);
                    continue;
                }
                SkiesBlockModels.swapModel(event, state, XMAS_STARLIT_LEAVES);
            }
        }
    }

    private static void swapModel(ModelEvent.BakingCompleted event, BlockState state, ModelResourceLocation model) {
        event.getModels().put(BlockModelShaper.m_110895_((BlockState)state), event.getModelManager().m_119422_(model));
    }
}

