/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.menu;

import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesTriggers;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class AlchemyTableMenu
extends AbstractContainerMenu {
    private List<Item> outputs = new ArrayList<Item>();
    private final DataSlot selectedItem = DataSlot.m_39401_();
    private final Container inputInventory = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            AlchemyTableMenu.this.m_6199_((Container)this);
            AlchemyTableMenu.this.inventoryUpdateListener.run();
        }
    };
    private final Container outputInventory = new SimpleContainer(1);
    private final ContainerLevelAccess worldPosCallable;
    private final Slot inputSlotA;
    private final Slot inputSlotB;
    private final Slot outputSlot;
    private ItemStack inputSlotAItem = ItemStack.f_41583_;
    private ItemStack inputSlotBItem = ItemStack.f_41583_;
    private Runnable inventoryUpdateListener = () -> {};
    private long lastOnTake;

    public AlchemyTableMenu(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.f_39287_);
    }

    public AlchemyTableMenu(int id, Inventory playerInv, final ContainerLevelAccess worldPos) {
        super(SkiesContainers.ALCHEMY_TABLE, id);
        this.worldPosCallable = worldPos;
        this.inputSlotA = this.m_38897_(new Slot(this.inputInventory, 0, 20, 23));
        this.inputSlotB = this.m_38897_(new Slot(this.inputInventory, 1, 20, 42));
        this.outputSlot = this.m_38897_(new Slot(this.outputInventory, 0, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                AlchemyTableMenu.this.triggerAdvancement(player, stack);
                stack.m_41678_(player.f_19853_, player, stack.m_41613_());
                ItemStack inputA = this.reduceStack(AlchemyTableMenu.this.inputSlotA);
                ItemStack inputB = this.reduceStack(AlchemyTableMenu.this.inputSlotB);
                if (!inputA.m_41619_() || !inputB.m_41619_()) {
                    AlchemyTableMenu.this.updateOutputSlot();
                }
                worldPos.m_39292_((world, pos) -> {
                    long time = world.m_46467_();
                    if (AlchemyTableMenu.this.lastOnTake != time) {
                        world.m_5594_((Player)null, pos, SkiesSounds.BLOCK_ALCHEMY_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        AlchemyTableMenu.this.lastOnTake = time;
                    }
                });
                this.m_6654_();
            }

            private ItemStack reduceStack(Slot slot) {
                if (slot.m_6657_()) {
                    ItemStack stack = slot.m_7993_();
                    if (stack.hasCraftingRemainingItem() && stack.m_41613_() == 1) {
                        return stack.getCraftingRemainingItem();
                    }
                    return slot.m_6201_(1);
                }
                return ItemStack.f_41583_;
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInv, i, 8 + i * 18, 142));
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.worldPosCallable.m_39292_((world, pos) -> this.m_150411_(player, this.inputInventory));
    }

    public boolean m_6875_(Player player) {
        return AlchemyTableMenu.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)player, (Block)SkiesBlocks.alchemy_table);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack slotStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            Item itemInSlot = stackInSlot.m_41720_();
            slotStack = stackInSlot.m_41777_();
            if (index == 2) {
                itemInSlot.m_7836_(stackInSlot, player.f_19853_, player);
                this.triggerAdvancement(player, stackInSlot);
                if (!this.m_38903_(stackInSlot, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stackInSlot, slotStack);
            } else if (index == 0 || index == 1) {
                if (!this.m_38903_(stackInSlot, 3, 39, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.m_38903_(stackInSlot, 0, 2, false)) {
                    return ItemStack.f_41583_;
                }
                if (index >= 3 && index < 30 ? !this.m_38903_(stackInSlot, 30, 39, false) : index >= 30 && index < 39 && !this.m_38903_(stackInSlot, 3, 30, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (stackInSlot.m_41613_() == slotStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
            this.m_38946_();
        }
        return slotStack;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn != this.outputSlot && super.m_5882_(stack, slotIn);
    }

    public void m_6199_(Container inventory) {
        ItemStack inputA = this.inputSlotA.m_7993_();
        ItemStack inputB = this.inputSlotB.m_7993_();
        if (inputA.m_41720_() != this.inputSlotAItem.m_41720_() || inputB.m_41720_() != this.inputSlotBItem.m_41720_()) {
            this.inputSlotAItem = inputA.m_41777_();
            this.inputSlotBItem = inputB.m_41777_();
            this.updateRecipes(inventory, inputA, inputB);
        }
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (id >= 0 && id < this.outputs.size()) {
            this.selectedItem.m_6422_(id);
            this.updateOutputSlot();
        }
        return true;
    }

    private void updateRecipes(Container inventory, ItemStack inputA, ItemStack inputB) {
        this.outputs.clear();
        this.selectedItem.m_6422_(-1);
        this.outputSlot.m_5852_(ItemStack.f_41583_);
        if (!inputA.m_41619_() || !inputB.m_41619_()) {
            Item itemA = inventory.m_8020_(0).m_41720_();
            Item itemB = inventory.m_8020_(1).m_41720_();
            List recipeOutputLists = BlueSkiesData.ALCHEMY_RECIPES.getMatching(itemA, itemB).stream().map(recipe -> recipe.getResults(itemA, itemB)).collect(Collectors.toList());
            List<Item> allOutputs = new ArrayList();
            if (recipeOutputLists.size() == 1) {
                allOutputs = (List)recipeOutputLists.get(0);
            } else {
                for (List list : new ArrayList(recipeOutputLists)) {
                    for (Item item : new ArrayList(list)) {
                        if (allOutputs.contains(item)) continue;
                        allOutputs.add(item);
                    }
                }
            }
            allOutputs.sort((a, b) -> ForgeRegistries.ITEMS.getKey(a).compareTo(ForgeRegistries.ITEMS.getKey(b)));
            this.outputs = allOutputs;
        }
    }

    private void updateOutputSlot() {
        if (!this.outputs.isEmpty() && this.selectedItem.m_6501_() >= 0 && this.selectedItem.m_6501_() < this.outputs.size()) {
            this.outputSlot.m_5852_(new ItemStack((ItemLike)this.outputs.get(this.selectedItem.m_6501_())));
        } else {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    private void triggerAdvancement(Player player, ItemStack stack) {
        if (player instanceof ServerPlayer && !stack.m_41619_()) {
            SkiesTriggers.USED_ALCHEMY_TABLE.trigger((ServerPlayer)player, stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listener) {
        this.inventoryUpdateListener = listener;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedItem() {
        return this.selectedItem.m_6501_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Item> getOutputItems() {
        return this.outputs;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getOutputCount() {
        return this.outputs.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsinInputSlot() {
        return (this.inputSlotA.m_6657_() || this.inputSlotB.m_6657_()) && !this.outputs.isEmpty();
    }
}

