/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyCropBlock
extends CropBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private final Supplier<? extends Item> seed;
    private final VoxelShape[] shapeByAge;

    public SkyCropBlock(Supplier<? extends Item> seed, double height) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56758_));
        this.seed = seed;
        this.shapeByAge = this.generateShapes(height);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape[] generateShapes(double height) {
        int ages = this.m_7959_().m_6908_().size();
        VoxelShape[] shapes = new VoxelShape[ages];
        for (int i = 0; i < ages; ++i) {
            shapes[i] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)((double)(i + 1) / (double)ages * height), (double)16.0);
        }
        return shapes;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapeByAge[(Integer)state.m_61143_((Property)this.m_7959_())];
    }

    public IntegerProperty m_7959_() {
        return AGE;
    }

    public boolean m_6724_(BlockState state) {
        return !this.m_52307_(state);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (random.m_188503_(3) != 0) {
            super.m_213898_(state, worldIn, pos, random);
        }
    }

    public int m_7419_() {
        return this.m_7959_().m_6908_().size() - 1;
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60734_() instanceof FarmBlock;
    }

    protected ItemLike m_6404_() {
        return (ItemLike)this.seed.get();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack(this.m_6404_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

