/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.block_entity;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.block_entity.IRecipeUnlocker;
import com.legacy.blue_skies.client.gui.menu.HorizoniteForgeMenu;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.HorizoniteForgeFuel;
import com.legacy.blue_skies.registries.SkiesBlockEntityTypes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class HorizoniteForgeBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible,
IRecipeUnlocker {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private int energy;
    private int cookTime;
    private int maxCookTime;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    protected final RecipeType<SmeltingRecipe> recipeType = RecipeType.f_44108_;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private final ContainerData data = new ContainerData(){

        public int m_6499_() {
            return 4;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    HorizoniteForgeBlockEntity.this.energy = value;
                    break;
                }
                case 1: {
                    BlueSkies.LOGGER.warn("Cannot set this value");
                    break;
                }
                case 2: {
                    HorizoniteForgeBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    HorizoniteForgeBlockEntity.this.maxCookTime = value;
                }
            }
        }

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return HorizoniteForgeBlockEntity.this.energy;
                }
                case 1: {
                    return HorizoniteForgeBlockEntity.this.getMaxEnergy();
                }
                case 2: {
                    return HorizoniteForgeBlockEntity.this.cookTime;
                }
                case 3: {
                    return HorizoniteForgeBlockEntity.this.maxCookTime;
                }
            }
            IllegalArgumentException ex = new IllegalArgumentException("Value out of range");
            BlueSkies.LOGGER.fatal((Object)ex);
            throw ex;
        }
    };

    public HorizoniteForgeBlockEntity(BlockPos pos, BlockState state) {
        super(SkiesBlockEntityTypes.HORIZONITE_FORGE, pos, state);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)SkiesBlocks.horizonite_forge.m_7705_());
    }

    protected HorizoniteForgeMenu createMenu(int id, Inventory playerInv) {
        return new HorizoniteForgeMenu(id, playerInv, (Container)this, this.data);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.energy = nbt.m_128451_("Energy");
        this.cookTime = nbt.m_128451_("CookTime");
        this.maxCookTime = nbt.m_128451_("MaxCookTime");
        CompoundTag recipesUsedNbt = nbt.m_128469_("RecipesUsed");
        for (String s : recipesUsedNbt.m_128431_()) {
            this.recipes.put((Object)new ResourceLocation(s), recipesUsedNbt.m_128451_(s));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Energy", this.energy);
        nbt.m_128405_("CookTime", this.cookTime);
        nbt.m_128405_("MaxCookTime", this.maxCookTime);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        CompoundTag recipesUsedNbt = new CompoundTag();
        this.recipes.forEach((recipeId, craftedAmount) -> recipesUsedNbt.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        nbt.m_128365_("RecipesUsed", (Tag)recipesUsedNbt);
    }

    public static void forgeServerTick(Level level, BlockPos pos, BlockState state, HorizoniteForgeBlockEntity forge) {
        boolean shouldBeLit;
        boolean isCooking = forge.isCooking();
        boolean shouldUpdate = false;
        if (isCooking) {
            if (forge.energy > 0) {
                --forge.energy;
            }
        } else if (forge.getRawStack().m_41619_() && forge.energy < forge.getMaxEnergy()) {
            forge.energy += 2;
        }
        if (forge.energy > forge.getMaxEnergy()) {
            forge.energy = forge.getMaxEnergy();
        }
        ItemStack fuelStack = forge.getFuelStack();
        if (forge.energy <= 0 && !forge.getFuelStack().m_41619_()) {
            forge.energy += forge.getEnergyFrom(fuelStack);
            fuelStack.m_41774_(1);
        }
        SmeltingRecipe recipe = level.m_7465_().m_44015_(forge.recipeType, (Container)forge, level).orElse(null);
        int maxStackSize = forge.m_6893_();
        if (isCooking) {
            shouldUpdate = true;
            forge.maxCookTime = forge.getRecipeCookTime();
            if (forge.canBurn((Recipe<?>)recipe, forge.items, maxStackSize)) {
                ++forge.cookTime;
                if (forge.cookTime >= forge.maxCookTime) {
                    forge.smelt((Recipe<?>)recipe);
                    forge.cookTime = 0;
                }
            } else if (forge.cookTime > 0) {
                forge.cookTime = 0;
            }
        } else if (forge.canBurn((Recipe<?>)recipe, forge.items, maxStackSize)) {
            shouldUpdate = true;
            ++forge.cookTime;
        }
        boolean bl = shouldBeLit = forge.isCooking() || forge.canBurn((Recipe<?>)recipe, forge.items, maxStackSize);
        if (isCooking != shouldBeLit) {
            shouldUpdate = true;
            level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(shouldBeLit)), 3);
        }
        if (shouldUpdate) {
            forge.m_6596_();
        }
    }

    public boolean isCooking() {
        return this.cookTime > 0;
    }

    public ItemStack getRawStack() {
        return (ItemStack)this.items.get(0);
    }

    public ItemStack getFuelStack() {
        return (ItemStack)this.items.get(1);
    }

    public ItemStack getOutputStack() {
        return (ItemStack)this.items.get(2);
    }

    public void setRawStack(ItemStack stack) {
        this.items.set(0, (Object)stack);
    }

    public void setFuelStack(ItemStack stack) {
        this.items.set(1, (Object)stack);
    }

    public void setOutputStack(ItemStack stack) {
        this.items.set(2, (Object)stack);
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getMaxEnergy() {
        return 4800;
    }

    public int getEnergyFrom(ItemStack stack) {
        if (HorizoniteForgeBlockEntity.isFuel(stack)) {
            return (int)((float)this.getMaxEnergy() * ((HorizoniteForgeFuel)BlueSkiesData.HORIZONITE_FORGE_FUEL.getValue(stack.m_41720_())).fuelAmount);
        }
        return 0;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    private boolean canBurn(@Nullable Recipe<?> recipe, NonNullList<ItemStack> items, int maxStackSize) {
        if (!this.getRawStack().m_41619_() && recipe != null && this.energy > 0) {
            ItemStack recipeOutput = recipe.m_5874_((Container)this);
            if (recipeOutput.m_41619_()) {
                return false;
            }
            ItemStack outputSlotStack = (ItemStack)items.get(2);
            if (outputSlotStack.m_41619_()) {
                return true;
            }
            if (!outputSlotStack.m_41656_(recipeOutput)) {
                return false;
            }
            if (outputSlotStack.m_41613_() + recipeOutput.m_41613_() <= maxStackSize && outputSlotStack.m_41613_() + recipeOutput.m_41613_() <= outputSlotStack.m_41741_()) {
                return true;
            }
            return outputSlotStack.m_41613_() + recipeOutput.m_41613_() <= recipeOutput.m_41741_();
        }
        return false;
    }

    private void smelt(@Nullable Recipe<?> recipe) {
        if (recipe != null && this.canBurn(recipe, this.items, this.m_6893_())) {
            ItemStack rawStack = this.getRawStack();
            ItemStack recipeOutput = recipe.m_8043_();
            ItemStack outputStack = this.getOutputStack();
            if (outputStack.m_41619_()) {
                this.setOutputStack(recipeOutput.m_41777_());
            } else if (outputStack.m_41720_() == recipeOutput.m_41720_()) {
                outputStack.m_41769_(recipeOutput.m_41613_());
            }
            if (!this.f_58857_.f_46443_) {
                this.m_6029_(recipe);
            }
            rawStack.m_41774_(1);
        }
    }

    public int getRecipeCookTime() {
        return (int)((double)this.f_58857_.m_7465_().m_44015_(this.recipeType, (Container)this, this.f_58857_).map(AbstractCookingRecipe::m_43753_).orElse(200).intValue() * 1.5);
    }

    public static boolean isFuel(ItemStack stack) {
        return BlueSkiesData.HORIZONITE_FORGE_FUEL.getData().containsKey(stack.m_41720_());
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1 || !HorizoniteForgeBlockEntity.isFuel(stack);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return true;
            }
            case 1: {
                return HorizoniteForgeBlockEntity.isFuel(stack);
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeId = recipe.m_6423_();
            this.recipes.addTo((Object)recipeId, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(Player player) {
    }

    @Override
    public void unlockRecipes(Player player) {
        List<Recipe<?>> list = this.grantStoredRecipeExperience(player.f_19853_, player.m_20182_());
        player.m_7281_(list);
        this.recipes.clear();
    }

    public List<Recipe<?>> grantStoredRecipeExperience(Level world, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            world.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                HorizoniteForgeBlockEntity.splitAndSpawnExperience(world, pos, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(Level world, Vec3 pos, int craftedAmount, float experience) {
        int i = Mth.m_14143_((float)((float)craftedAmount * experience));
        float f = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.m_20782_((int)i);
            i -= j;
            world.m_7967_((Entity)new ExperienceOrb(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, j));
        }
    }

    public void m_5809_(StackedContents helper) {
        for (ItemStack stack : this.items) {
            helper.m_36491_(stack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

