/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.structure;

import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.biome_dictionary.IBiomeFilter;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.common.world.StructureSettingsBuilder;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ConfigStructureModifier
implements StructureModifier {
    private static final Map<ResourceLocation, StructureConfig.SettingsConfig> CONFIGS = new HashMap<ResourceLocation, StructureConfig.SettingsConfig>();
    public static final Codec<ConfigStructureModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("structure").forGetter(modifier -> modifier.structureName)).apply((Applicative)instance, ConfigStructureModifier::new));
    private final ResourceLocation structureName;
    private final StructureConfig.SettingsConfig config;

    private ConfigStructureModifier(ResourceLocation structureName) {
        this.structureName = structureName;
        this.config = CONFIGS.get(structureName);
        if (this.config == null) {
            throw new NullPointerException("[Structure Gel] Couldn't find a config for the structure passed. This structure modifier is not intended to be used by datapack creators and primarily exists as an internal tool.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigStructureModifier(ResourceLocation structureName, StructureConfig.SettingsConfig config) throws IllegalArgumentException {
        this.structureName = structureName;
        this.config = config;
        Map<ResourceLocation, StructureConfig.SettingsConfig> map = CONFIGS;
        synchronized (map) {
            if (CONFIGS.putIfAbsent(structureName, config) != null) {
                throw new IllegalArgumentException("[Structure Gel] A structure config already has been bound to " + structureName);
            }
        }
    }

    public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
        if (phase == StructureModifier.Phase.MODIFY) {
            StructureSettingsBuilder settings = builder.getStructureSettings();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
            HolderSet holderSet = settings.getBiomes();
            if (holderSet instanceof BiomeType) {
                BiomeType biomeType = (BiomeType)holderSet;
                biomeType.bind(biomeRegistry);
            }
            if (structure.m_203373_(this.structureName)) {
                Set<ResourceKey<Level>> dimensions;
                Map<MobCategory, StructureSpawnOverride> newSpawns;
                ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)this.structureName);
                HolderSet biomes = this.config.getBiomes();
                if (biomes != null) {
                    if (biomes instanceof IBiomeFilter.HolderSetBiomeFilter) {
                        IBiomeFilter.HolderSetBiomeFilter biomeFilter = (IBiomeFilter.HolderSetBiomeFilter)biomes;
                        biomes = (HolderSet)biomeFilter.bind((Registry<Biome>)biomeRegistry);
                    } else {
                        biomes = IBiomeFilter.rebuildFromRegistry(biomes, (Registry<Biome>)biomeRegistry);
                    }
                    settings.setBiomes(biomes);
                }
                if ((newSpawns = this.config.getSpawns()) != null) {
                    for (Map.Entry<MobCategory, StructureSpawnOverride> entry : newSpawns.entrySet()) {
                        MobCategory cat = entry.getKey();
                        settings.removeSpawnOverrides(cat);
                        StructureSettingsBuilder.StructureSpawnOverrideBuilder spawnBuilder = settings.getOrAddSpawnOverrides(cat);
                        for (MobSpawnSettings.SpawnerData spawnerData : entry.getValue().f_210044_().m_146338_()) {
                            spawnBuilder.addSpawn(spawnerData);
                        }
                    }
                }
                if ((dimensions = this.config.getDimensions()) != null) {
                    StructureAccessHelper.setDimensionFilter((ResourceKey<? extends Structure>)structureKey, dimensions);
                }
            }
        }
    }

    public Codec<? extends StructureModifier> codec() {
        return CODEC;
    }
}

