/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class RegistryHelper {
    public static <T> boolean isInTag(Registry<T> registry, TagKey<T> tagKey, T object) {
        Optional holder;
        Optional key = registry.m_7854_(object);
        if (key.isPresent() && (holder = registry.m_203636_((ResourceKey)key.get())).isPresent()) {
            return registry.m_203561_(tagKey).m_203333_((Holder)holder.get());
        }
        return false;
    }

    public static Holder<StructureProcessorList> registerProcessor(ResourceLocation key, StructureProcessor processor) {
        return RegistryHelper.registerProcessor(key, (List<StructureProcessor>)ImmutableList.of((Object)processor));
    }

    public static Holder<StructureProcessorList> registerProcessor(ResourceLocation key, List<StructureProcessor> processors) {
        return RegistryHelper.registerProcessor(key, new StructureProcessorList(processors));
    }

    public static Holder<StructureProcessorList> registerProcessor(ResourceLocation key, StructureProcessorList processorList) {
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123863_, (ResourceLocation)key, (Object)processorList);
    }

    @SafeVarargs
    public static StructureProcessorList combineProcessors(Holder<StructureProcessorList> ... structureProcessors) {
        ArrayList processors = new ArrayList();
        for (Holder<StructureProcessorList> spl : structureProcessors) {
            processors.addAll(((StructureProcessorList)spl.m_203334_()).m_74425_());
        }
        return new StructureProcessorList(processors);
    }

    public static StructureProcessorList combineProcessors(Holder<StructureProcessorList> structureProcessorList, StructureProcessor ... structureProcessors) {
        ArrayList<StructureProcessor> processors = new ArrayList<StructureProcessor>(((StructureProcessorList)structureProcessorList.m_203334_()).m_74425_());
        processors.addAll(Arrays.asList(structureProcessors));
        return new StructureProcessorList(processors);
    }
}

