/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.biome_dictionary;

import com.legacy.structure_gel.api.biome_dictionary.IBiomeFilter;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;

public final class BiomeType
implements IBiomeFilter.HolderSetBiomeFilter<Holder<Biome>, BiomeType> {
    public static final Codec<BiomeType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IBiomeFilter.BiomeFilter.CODEC.fieldOf("biomes").forGetter(type -> type.biomeFilter != null ? type.biomeFilter : IBiomeFilter.BiomeFilter.EMPTY), (App)IBiomeFilter.BiomeTagFilter.CODEC.fieldOf("tags").forGetter(type -> type.tagFilter != null ? type.tagFilter : IBiomeFilter.BiomeTagFilter.EMPTY)).apply((Applicative)instance, BiomeType::new));
    @Nullable
    private IBiomeFilter.BiomeFilter biomeFilter = null;
    @Nullable
    private IBiomeFilter.BiomeTagFilter tagFilter = null;
    private final List<IBiomeFilter<?, ?>> filters = new ArrayList();

    private BiomeType(Builder builder) {
        List<TagKey<Biome>> tags;
        List<ResourceKey<Biome>> biomes = List.copyOf(builder.biomes);
        if (!biomes.isEmpty()) {
            this.biomeFilter = new IBiomeFilter.BiomeFilter(biomes);
            this.filters.add(this.biomeFilter);
        }
        if (!(tags = List.copyOf(builder.tagKeys)).isEmpty()) {
            this.tagFilter = new IBiomeFilter.BiomeTagFilter(tags);
            this.filters.add(this.tagFilter);
        }
    }

    private BiomeType(IBiomeFilter.BiomeFilter biomeFilter, IBiomeFilter.BiomeTagFilter tagFilter) {
        this.biomeFilter = biomeFilter;
        this.filters.add(this.biomeFilter);
        this.tagFilter = tagFilter;
        this.filters.add(this.tagFilter);
    }

    @Override
    public BiomeType bind(Registry<Biome> registry) {
        if (this.biomeFilter != null) {
            this.biomeFilter.bind((Registry)registry);
        }
        if (this.tagFilter != null) {
            this.tagFilter.bind((Registry)registry);
        }
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean m_203333_(Holder<Biome> biome) {
        return this.filters.stream().anyMatch(filter -> filter.passesFilter(biome));
    }

    @Override
    public List<Holder<Biome>> getAllValues() {
        return this.filters.stream().flatMap(filter -> filter.getAllValues().stream()).collect(Collectors.toList());
    }

    @Override
    public List<Holder<Biome>> getData() {
        return this.getAllValues();
    }

    @Override
    public Codec<BiomeType> codec() {
        return CODEC;
    }

    public String toString() {
        return String.format("BiomeType[biomes = %s]", this.valuesToStrings());
    }

    public List<String> toFilterStrings(boolean isIncluded) throws IllegalStateException {
        List values = this.valuesToStrings();
        return isIncluded ? values : (List)values.stream().map(s -> "!" + s).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<String> valuesToStrings() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.biomeFilter != null) {
            this.biomeFilter.m_203614_().map(h -> ((ResourceKey)h.m_203543_().orElseThrow(() -> new IllegalStateException("The biome holder " + h + " does not have a ResourceKey bound. Cannot create config filter strings."))).m_135782_().toString()).forEach(values::add);
        }
        if (this.tagFilter != null) {
            this.tagFilter.getData().forEach(t -> values.add("#" + t.f_203868_().toString()));
        }
        return values;
    }

    public static final class Builder {
        private final LinkedHashSet<ResourceKey<Biome>> biomes = new LinkedHashSet();
        private final LinkedHashSet<TagKey<Biome>> tagKeys = new LinkedHashSet();

        private Builder() {
        }

        public final Builder biomes(Collection<ResourceKey<Biome>> biomeNames) {
            this.biomes.addAll(biomeNames);
            return this;
        }

        @SafeVarargs
        public final Builder biomes(ResourceKey<Biome> ... biomeKeys) {
            return this.biomes(List.of(biomeKeys));
        }

        public final Builder biomes(ResourceLocation ... biomeNames) {
            return this.biomes(Arrays.asList(biomeNames).stream().map(n -> ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)n)).toList());
        }

        public final Builder biomes(String modID, String ... biomeNames) {
            return this.biomes((ResourceLocation[])Arrays.stream(biomeNames).map(b -> new ResourceLocation(modID, b)).toArray(ResourceLocation[]::new));
        }

        @SafeVarargs
        public final Builder biomes(Registrar<Biome> ... biomes) {
            return this.biomes(Arrays.stream(biomes).map(Registrar::getKey).toList());
        }

        public final Builder biomes(BiomeSource ... biomeSources) {
            return this.biomes(Arrays.stream(biomeSources).map(BiomeSource::m_207840_).flatMap(Collection::stream).map(Holder::m_203543_).filter(Optional::isPresent).map(Optional::get).toList());
        }

        public final Builder tags(Collection<TagKey<Biome>> tags) {
            this.tagKeys.addAll(tags);
            return this;
        }

        @SafeVarargs
        public final Builder tags(TagKey<Biome> ... tags) {
            return this.tags(List.of(tags));
        }

        public BiomeType build() throws IllegalStateException {
            return new BiomeType(this);
        }
    }
}

