/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntry;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryError;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistStart;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.u_team_core.gui.elements.ImageToggleButton;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public abstract class GuiMusicPlaylistListEntryPlayable
extends GuiMusicPlaylistListEntry {
    private final ITrackManager manager;
    private final IAudioTrack track;
    private final LoadedTracks loadedTrack;
    protected final ImageToggleButton playTrackButton;

    GuiMusicPlaylistListEntryPlayable(Playlists playlists, Playlist playlist, LoadedTracks loadedTrack, IAudioTrack track) {
        this.track = track;
        this.loadedTrack = loadedTrack;
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        this.playTrackButton = (ImageToggleButton)this.addChildren((class_364)new ImageToggleButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_PAUSE, false));
        if (loadedTrack.hasError() || track == null) {
            this.playTrackButton.field_22764 = false;
        } else {
            this.playTrackButton.setToggled(track == this.getCurrentlyPlaying());
            this.playTrackButton.setPressable(() -> {
                boolean play = this.playTrackButton.isToggled();
                if (play) {
                    if (this.manager.isPaused() && this.getCurrentlyPlaying() == track) {
                        this.manager.setPaused(false);
                    } else {
                        playlists.setPlaying(playlist);
                        playlist.setPlayable(loadedTrack, track);
                        this.manager.setTrackQueue(playlist);
                        this.manager.start();
                    }
                } else {
                    this.manager.setPaused(true);
                }
            });
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 2) {
            String uri;
            String string = uri = this instanceof GuiMusicPlaylistListEntryPlaylistStart || this instanceof GuiMusicPlaylistListEntryError ? this.loadedTrack.getUri().get() : this.track.getInfo().getURI();
            if (GuiTrackUtils.openURI(uri)) {
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25343(class_4587 matrixStack, int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        this.playTrackButton.field_22760 = entryWidth - 65;
        this.playTrackButton.field_22761 = entryY + 8;
        this.playTrackButton.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void tick() {
        if (this.isPlaying()) {
            this.playTrackButton.setToggled(!this.manager.isPaused());
        } else {
            this.playTrackButton.setToggled(false);
        }
    }

    protected IAudioTrack getCurrentlyPlaying() {
        return this.manager.getCurrentTrack() == null ? null : this.manager.getCurrentTrack().getOriginalTrack();
    }

    protected boolean isPlaying() {
        return this.getCurrentlyPlaying() == this.track;
    }

    public IAudioTrack getTrack() {
        return this.track;
    }

    public ImageToggleButton getPlayTrackButton() {
        return this.playTrackButton;
    }
}

