/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.shade.net.harawata.appdirs;

import info.u_team.music_player.shade.net.harawata.appdirs.AppDirs;
import info.u_team.music_player.shade.net.harawata.appdirs.impl.MacOSXAppDirs;
import info.u_team.music_player.shade.net.harawata.appdirs.impl.ShellFolderResolver;
import info.u_team.music_player.shade.net.harawata.appdirs.impl.UnixAppDirs;
import info.u_team.music_player.shade.net.harawata.appdirs.impl.WindowsAppDirs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDirsFactory {
    private static final Logger logger = LoggerFactory.getLogger(AppDirsFactory.class);

    private AppDirsFactory() {
    }

    public static AppDirs getInstance() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac os x")) {
            logger.debug("os.name {} is resolved to Mac OS X", (Object)os);
            return new MacOSXAppDirs();
        }
        if (os.startsWith("windows")) {
            logger.debug("os.name {} is resolved to Windows", (Object)os);
            ShellFolderResolver folderResolver = new ShellFolderResolver();
            return new WindowsAppDirs(folderResolver);
        }
        logger.debug("os.name {} is resolved to *nix", (Object)os);
        return new UnixAppDirs();
    }
}

