/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.render;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.lavaplayer.api.audio.IPlayingTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.u_team_core.gui.elements.ScalableText;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;

public class RenderOverlayMusicDisplay
implements Widget {
    private final ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
    private final int width;
    private final int height;
    private final ScrollingText title;
    private final ScrollingText author;
    private final ScalableText position;
    private final ScalableText duration;

    public RenderOverlayMusicDisplay() {
        this.height = 35;
        this.width = 120;
        Font fontRender = Minecraft.m_91087_().f_91062_;
        this.title = new ScrollingText(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()), 3.0f, 2.0f);
        this.title.setStepSize(0.5f);
        this.title.setColor(MusicPlayerColors.YELLOW);
        this.title.setWidth(114);
        this.title.setSpeedTime(35);
        this.author = new ScrollingText(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()), 3.0f, 12.0f);
        this.author.setStepSize(0.5f);
        this.author.setColor(MusicPlayerColors.YELLOW);
        this.author.setScale(0.75f);
        this.author.setWidth(114);
        this.author.setSpeedTime(35);
        this.position = new ScalableText(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedPosition), 6.0f, 28.0f);
        this.position.setColor(MusicPlayerColors.YELLOW);
        this.position.setScale(0.5f);
        this.duration = new ScalableText(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedDuration), (float)(this.width - 6), 28.0f);
        this.duration.setTextChanged(renderer -> this.duration.setX((float)(this.width - 6) - renderer.getTextWidth()));
        this.duration.setColor(MusicPlayerColors.YELLOW);
        this.duration.setScale(0.5f);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        IPlayingTrack track = this.manager.getCurrentTrack();
        if (track == null) {
            return;
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)this.width, (int)this.height, (int)-14606047);
        double progress = track.getInfo().isStream() ? 0.5 : (double)track.getPosition() / (double)track.getDuration();
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)6, (int)23, (int)(this.width - 6), (int)26, (int)-11184811);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)6, (int)23, (int)(6 + (int)((double)(this.width - 12) * progress)), (int)26, (int)-12676864);
        this.title.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.author.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.position.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.duration.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

