/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.u_team.music_player.dependency.DependencyManager;
import info.u_team.music_player.lavaplayer.api.IMusicPlayer;
import info.u_team.music_player.musicplayer.MusicPlayerFiles;
import info.u_team.music_player.musicplayer.PlaylistManager;
import info.u_team.music_player.musicplayer.SettingsManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MusicPlayerManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static IMusicPlayer player;
    private static final Gson gson;
    private static final MusicPlayerFiles files;
    private static final PlaylistManager playListManager;
    private static final SettingsManager settingsManager;

    private static void setup(FMLClientSetupEvent event) {
        MusicPlayerManager.generatePlayer();
        player.startAudioOutput();
        files.load();
        playListManager.setBasePath(files.getDirectory());
        settingsManager.setBasePath(files.getDirectory());
        playListManager.loadFromFile();
        settingsManager.loadFromFile();
        player.setVolume(settingsManager.getSettings().getVolume());
    }

    private static void generatePlayer() {
        try {
            Class<?> clazz = Class.forName("info.u_team.music_player.lavaplayer.MusicPlayer", true, DependencyManager.MUSICPLAYER_CLASSLOADER);
            if (!IMusicPlayer.class.isAssignableFrom(clazz)) {
                throw new IllegalAccessError("The class " + clazz + " does not implement IMusicPlayer! This should not happen?!");
            }
            player = (IMusicPlayer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.info("Successfully created music player instance");
        }
        catch (Exception ex) {
            LOGGER.fatal("Cannot create music player instance. This is a serious bug and the mod will not work. Report to the mod authors", (Throwable)ex);
            System.exit(-1);
        }
    }

    public static IMusicPlayer getPlayer() {
        return player;
    }

    public static MusicPlayerFiles getFiles() {
        return files;
    }

    public static PlaylistManager getPlaylistManager() {
        return playListManager;
    }

    public static SettingsManager getSettingsManager() {
        return settingsManager;
    }

    public static void registerMod(IEventBus bus) {
        bus.addListener(MusicPlayerManager::setup);
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
        files = new MusicPlayerFiles();
        playListManager = new PlaylistManager(gson);
        settingsManager = new SettingsManager(gson);
    }
}

