/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchList;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryMusicTrack;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryPlaylist;
import info.u_team.music_player.gui.playlist.search.SearchProvider;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.UButton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class GuiMusicSearch
extends BetterScreen {
    private final Playlist playlist;
    private EditBox urlField;
    private EditBox searchField;
    private final GuiMusicSearchList searchList;
    private SearchProvider searchProvider;
    private String information;
    private int informationTicks;
    private int maxTicksInformation;

    public GuiMusicSearch(Playlist playlist) {
        super((Component)Component.m_237113_((String)"musicsearch"));
        this.playlist = playlist;
        this.searchList = new GuiMusicSearchList();
        this.searchProvider = SearchProvider.YOUTUBE;
    }

    protected void m_7856_() {
        ImageButton backButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
        backButton.setPressable(() -> this.f_96541_.m_91152_((Screen)new GuiMusicPlaylist(this.playlist)));
        this.urlField = new EditBox(this.f_96547_, 10, 35, this.f_96543_ / 2 - 10, 20, Component.m_130674_((String)"")){

            public boolean m_7933_(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, this.m_94155_(), key);
                return super.m_7933_(key, p_keyPressed_2_, p_keyPressed_3_);
            }
        };
        this.urlField.m_94199_(10000);
        this.m_7787_((GuiEventListener)this.urlField);
        UButton openFileButton = (UButton)this.m_142416_((GuiEventListener)new UButton(this.f_96543_ / 2 + 10, 34, this.f_96543_ / 4 - 15, 22, Component.m_130674_((String)MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0]))));
        openFileButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0]), null, null, (CharSequence)MusicPlayerLocalization.getTranslation("gui.search.music_files", new Object[0]), (boolean)false);
            if (response != null) {
                this.searchList.clear();
                this.addTrack(response);
            }
        });
        UButton openFolderButton = (UButton)this.m_142416_((GuiEventListener)new UButton((int)((double)this.f_96543_ * 0.75) + 5, 34, this.f_96543_ / 4 - 15, 22, Component.m_130674_((String)MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0]))));
        openFolderButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0]), (CharSequence)System.getProperty("user.home"));
            if (response != null) {
                this.searchList.clear();
                try (Stream<Path> stream = Files.list(Paths.get(response, new String[0]));){
                    stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> this.addTrack(path.toString()));
                }
                catch (IOException ex) {
                    this.setInformation(ChatFormatting.RED + ex.getMessage(), 150);
                }
            }
        });
        ImageButton searchButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(10, 76, 24, 24, this.searchProvider.getLogo()));
        searchButton.setPressable(() -> {
            this.searchProvider = SearchProvider.toggle(this.searchProvider);
            searchButton.setImage(this.searchProvider.getLogo());
        });
        this.searchField = new EditBox(this.f_96547_, 40, 78, this.f_96543_ - 51, 20, Component.m_130674_((String)"")){

            public boolean m_7933_(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, GuiMusicSearch.this.searchProvider.getPrefix() + this.m_94155_(), key);
                return super.m_7933_(key, p_keyPressed_2_, p_keyPressed_3_);
            }

            public boolean m_5755_(boolean p_changeFocus_1_) {
                System.out.println("CHANGEED FOR Search FIELD to " + p_changeFocus_1_);
                return super.m_5755_(p_changeFocus_1_);
            }
        };
        this.searchField.m_94199_(1000);
        this.searchField.m_94178_(true);
        this.m_7522_((GuiEventListener)this.searchField);
        this.m_7787_((GuiEventListener)this.searchField);
        UButton addAllButton = (UButton)this.m_142416_((GuiEventListener)new UButton(this.f_96543_ - 110, 105, 100, 20, Component.m_130674_((String)MusicPlayerLocalization.getTranslation("gui.search.add_all", new Object[0]))));
        addAllButton.setPressable(() -> {
            List<GuiMusicSearchListEntryPlaylist> list = this.searchList.m_6702_().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryPlaylist).map(entry -> (GuiMusicSearchListEntryPlaylist)((Object)((Object)entry))).collect(Collectors.toList());
            if (list.size() > 0) {
                list.forEach(entry -> this.playlist.add(entry.getTrackList()));
            } else {
                this.searchList.m_6702_().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryMusicTrack).map(entry -> (GuiMusicSearchListEntryMusicTrack)((Object)((Object)entry))).filter(entry -> !entry.isPlaylistEntry()).forEach(entry -> this.playlist.add(entry.getTrack()));
            }
            this.setInformation(ChatFormatting.GREEN + MusicPlayerLocalization.getTranslation("gui.search.added_all", new Object[0]), 150);
        });
        this.searchList.updateSettings(this.f_96543_ - 24, this.f_96544_, 130, this.f_96544_ - 10, 12, this.f_96543_ - 12);
        this.m_7787_((GuiEventListener)this.searchList);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String urlFieldText = this.urlField.m_94155_();
        boolean urlFieldFocus = this.urlField.m_93696_() && this.m_7222_() == this.urlField;
        String searchFieldText = this.searchField.m_94155_();
        boolean searchFieldFocus = this.searchField.m_93696_() && this.m_7222_() == this.searchField;
        this.m_6575_(minecraft, width, height);
        this.urlField.m_94144_(urlFieldText);
        this.urlField.m_94178_(urlFieldFocus);
        if (urlFieldFocus) {
            this.m_7522_((GuiEventListener)this.urlField);
        }
        this.searchField.m_94144_(searchFieldText);
        this.searchField.m_94178_(searchFieldFocus);
        if (searchFieldFocus) {
            this.m_7522_((GuiEventListener)this.searchField);
        }
    }

    public void m_86600_() {
        this.urlField.m_94120_();
        this.searchField.m_94120_();
        ++this.informationTicks;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        this.searchList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        GuiMusicSearch.m_93208_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)MusicPlayerLocalization.getTranslation("gui.search.header", new Object[0]), (int)(this.f_96543_ / 2), (int)5, (int)0xFFFFFF);
        GuiMusicSearch.m_93236_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)MusicPlayerLocalization.getTranslation("gui.search.search.uri", new Object[0]), (int)10, (int)20, (int)0xFFFFFF);
        GuiMusicSearch.m_93236_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)MusicPlayerLocalization.getTranslation("gui.search.search.file", new Object[0]), (int)(10 + this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        GuiMusicSearch.m_93236_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)MusicPlayerLocalization.getTranslation("gui.search.search.search", new Object[0]), (int)10, (int)63, (int)0xFFFFFF);
        if (this.information != null && this.informationTicks <= this.maxTicksInformation) {
            GuiMusicSearch.m_93236_((PoseStack)matrixStack, (Font)this.f_96541_.f_91062_, (String)this.information, (int)15, (int)110, (int)0xFFFFFF);
        }
        this.urlField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.urlField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.urlField);
            this.urlField.m_94178_(true);
            this.searchField.m_94178_(false);
            return true;
        }
        if (this.searchField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.searchField);
            this.searchField.m_94178_(true);
            this.urlField.m_94178_(false);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void setInformation(String information, int maxTicksInformation) {
        this.information = information;
        this.maxTicksInformation = maxTicksInformation;
        this.informationTicks = 0;
    }

    private void keyFromTextField(EditBox field, String text, int key) {
        if (field.m_94213_() && field.m_93696_() && (key == 257 || key == 335)) {
            this.searchList.clear();
            this.addTrack(text);
            field.m_94144_("");
        }
    }

    private void addTrack(String uri) {
        MusicPlayerManager.getPlayer().getTrackSearch().getTracks(uri, result -> this.f_96541_.execute(() -> {
            if (result.hasError()) {
                this.setInformation(ChatFormatting.RED + result.getErrorMessage(), 150);
            } else if (result.isList()) {
                IAudioTrackList list = result.getTrackList();
                if (!list.isSearch()) {
                    this.searchList.add(new GuiMusicSearchListEntryPlaylist(this, this.playlist, list));
                }
                list.getTracks().forEach(track -> this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, (IAudioTrack)track, !list.isSearch())));
            } else {
                IAudioTrack track2 = result.getTrack();
                this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, track2, false));
            }
        }));
    }
}

