/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.entities;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.ParticleHelper;
import jp.nechiru.advancedelectrictools.Util.PlayerEvent;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityTechArrow
extends EntitySpectralArrow {
    protected EntityPlayer shooter;
    private boolean explosive = false;
    private float explosionPower = 3.0f;
    private boolean Thunder = false;
    private int ThunderNum = 3;
    private boolean Seeker = false;
    private float SeekerSpeed = 1.0f;
    private boolean Teleport = false;
    private boolean Extinguishing = false;
    private int ExtinguishingRange = 5;
    private static final DataParameter<Integer> DW_TARGET_ID = EntityDataManager.func_187226_a(EntityTechArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int NO_TARGET = -1;
    private int newTargetCooldown = 0;
    private boolean AntiWater = false;
    private boolean Penetration = false;
    private float PenetrationDamage = 5.0f;
    private boolean InvExplosion = false;
    private boolean ProximityFuze = false;
    private boolean Flame = false;
    private int FlameTicks = 5;

    public EntityTechArrow(World world) {
        super(world);
    }

    public EntityTechArrow(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityTechArrow(World world, EntityPlayer shooter) {
        super(world, (EntityLivingBase)shooter);
        this.func_70239_b(10.0);
        this.shooter = shooter;
        this.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
    }

    public void setFlame(boolean b) {
        this.Flame = b;
    }

    public void setFlameTicks(int n) {
        this.FlameTicks = n;
    }

    public void setExplosive(boolean b) {
        this.explosive = b;
    }

    public void setExplosionPower(float value) {
        this.explosionPower = value;
    }

    public void setProximityFuze(boolean b) {
        this.ProximityFuze = b;
    }

    public void setInvExplosive(boolean b) {
        this.InvExplosion = b;
    }

    public void setThunder(boolean b) {
        this.Thunder = b;
    }

    public void setThunderNum(int n) {
        this.ThunderNum = n;
    }

    public void setSeeker(boolean b) {
        this.Seeker = b;
    }

    public void setSeekerSpeed(float n) {
        this.SeekerSpeed = n;
    }

    public void setTeleport(boolean b) {
        this.Teleport = b;
    }

    public void setExtinguishing(boolean b) {
        this.Extinguishing = b;
    }

    public void setExtinguishingRange(int n) {
        this.ExtinguishingRange = n;
    }

    public void setAntiWater(boolean b) {
        this.AntiWater = b;
    }

    public void setPenetration(boolean b) {
        this.Penetration = b;
    }

    public void setPenetrationDamage(float n) {
        this.PenetrationDamage = n;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TARGET_ID, (Object)-1);
    }

    protected void func_184548_a(@Nonnull EntityLivingBase living) {
        living.field_70172_ad = 0;
        living.field_70737_aN = 0;
        living.field_70738_aO = 0;
        super.func_184548_a(living);
        if (this.Flame) {
            living.func_70015_d(this.FlameTicks);
        }
        if (living instanceof EntityPlayer) {
            PlayerEvent.DisabledShield((EntityPlayer)living);
        }
        if (living != this.shooter) {
            if (this.Penetration) {
                if (living instanceof EntityEnderman) {
                    if (living.func_110139_bj() > 0.0f) {
                        living.func_110149_m(living.func_110139_bj() - this.PenetrationDamage);
                    } else {
                        living.func_70606_j(living.func_110143_aJ() - this.PenetrationDamage);
                    }
                } else {
                    living.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.shooter), this.PenetrationDamage);
                }
            }
            PotionEffect potioneffect = new PotionEffect(MobEffects.field_76421_d, 200, 10, false, false);
            living.func_70690_d(potioneffect);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.explosive && this.ProximityFuze) {
            float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            if (!this.field_70170_p.field_72995_K && (float)this.field_70173_aa > this.explosionPower / velocity + 2.0f) {
                if (this.hasTarget() && (!this.getTarget().func_70089_S() || this.field_70254_i)) {
                    this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)-1);
                }
                if (!this.hasTarget() && !this.field_70254_i && this.newTargetCooldown <= 0) {
                    double range = Math.min((double)this.explosionPower, 7.0);
                    this.findNewTarget(range, 2);
                } else {
                    --this.newTargetCooldown;
                }
            }
            if ((float)this.field_70173_aa > this.explosionPower / velocity + 2.0f && this.hasTarget() && !this.field_70254_i) {
                this.field_70170_p.func_72885_a((Entity)(this.InvExplosion ? this.shooter : null), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionPower, false, false);
                this.func_70106_y();
            }
        }
        if (this.Seeker) {
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 4) {
                if (this.hasTarget() && (!this.getTarget().func_70089_S() || this.field_70254_i)) {
                    this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)-1);
                }
                if (!this.hasTarget() && !this.field_70254_i && this.newTargetCooldown <= 0) {
                    this.findNewTarget(8.0, 3);
                } else {
                    --this.newTargetCooldown;
                }
            }
            if (this.hasTarget() && !this.field_70254_i) {
                EntityLiving entityLiving = this.getTarget();
                Vector3d arrowLoc = new Vector3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Vector3d targetLoc = new Vector3d(entityLiving.field_70165_t, entityLiving.field_70163_u + (double)(entityLiving.field_70131_O / 2.0f), entityLiving.field_70161_v);
                Vector3d lookVec = new Vector3d(targetLoc);
                lookVec.sub((Tuple3d)arrowLoc);
                Vector3d arrowMotion = new Vector3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                double theta = this.wrap180Radian(arrowMotion.angle(lookVec));
                theta = this.clampAbs(theta, 1.5707963267948966);
                Vector3d crossProduct = new Vector3d();
                crossProduct.cross(arrowMotion, lookVec);
                crossProduct.normalize();
                Matrix4d transform = new Matrix4d();
                transform.set(new AxisAngle4d(crossProduct, theta));
                Vector3d adjustedLookVec = new Vector3d(arrowMotion);
                transform.transform(arrowMotion, adjustedLookVec);
                this.func_70186_c(adjustedLookVec.x, adjustedLookVec.y, adjustedLookVec.z, this.SeekerSpeed, 0.0f);
            }
        }
        if (this.AntiWater && this.func_70090_H() && !this.field_70254_i) {
            this.field_70159_w += this.field_70159_w / 0.6;
            this.field_70181_x += this.field_70181_x / 0.6;
            this.field_70179_y += this.field_70179_y / 0.6;
        }
    }

    protected void func_145775_I() {
        super.func_145775_I();
        if (this.field_70128_L || this.field_70249_b > 0) {
            if (this.explosive) {
                this.field_70170_p.func_72885_a((Entity)(this.InvExplosion ? this.shooter : null), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionPower, false, false);
                this.func_70106_y();
            }
            if (this.Thunder) {
                int rain = this.field_70170_p.func_72896_J() ? 5 : 0;
                for (int i = 0; i < this.ThunderNum + rain; ++i) {
                    EntityLightningBolt entityLightningBolt = new EntityLightningBolt(this.field_70170_p, this.field_70165_t + this.field_70170_p.field_73012_v.nextGaussian(), this.field_70163_u + this.field_70170_p.field_73012_v.nextGaussian(), this.field_70161_v + this.field_70170_p.field_73012_v.nextGaussian(), false);
                    this.field_70170_p.func_72942_c((Entity)entityLightningBolt);
                    this.func_70077_a(entityLightningBolt);
                }
                SoundEvent channering = (double)this.field_70146_Z.nextFloat() > 0.5 ? Sounds.Channeling1 : Sounds.Channeling0;
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.shooter.field_70165_t, this.shooter.field_70163_u, this.shooter.field_70161_v, channering, SoundCategory.NEUTRAL, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.8f));
                this.func_70106_y();
            }
            if (this.Teleport) {
                this.playTeleport();
            }
        }
    }

    public void playTeleport() {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
    }

    protected void func_184549_a(RayTraceResult rayTrace) {
        BlockPos blockpos;
        super.func_184549_a(rayTrace);
        Entity entity = rayTrace.field_72308_g;
        if (this.Teleport) {
            TileEntity tileentity;
            if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && (tileentity = this.field_70170_p.func_175625_s(blockpos = rayTrace.func_178782_a())) instanceof TileEntityEndGateway) {
                TileEntityEndGateway tileentityendgateway = (TileEntityEndGateway)tileentity;
                if (this.field_70250_c != null) {
                    if (this.field_70250_c instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_192124_d.func_192193_a((EntityPlayerMP)this.field_70250_c, this.field_70170_p.func_180495_p(blockpos));
                    }
                    tileentityendgateway.func_184306_a(this.field_70250_c);
                    this.func_70106_y();
                    return;
                }
                tileentityendgateway.func_184306_a((Entity)this);
                return;
            }
            if (this.field_70250_c != null) {
                if (this.field_70250_c instanceof EntityPlayerMP) {
                    EntityPlayerMP entityplayermp = (EntityPlayerMP)this.field_70250_c;
                    if (entityplayermp.field_71135_a.func_147362_b().func_150724_d() && entityplayermp.func_130014_f_() == this.func_130014_f_() && !entityplayermp.func_70608_bn()) {
                        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)entityplayermp, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f);
                        if (!MinecraftForge.EVENT_BUS.post((Event)event) && this.field_70146_Z.nextFloat() < 0.025f && this.func_130014_f_().func_82736_K().func_82766_b("doMobSpawning")) {
                            EntityEndermite entityendermite = new EntityEndermite(this.func_130014_f_());
                            entityendermite.func_175496_a(true);
                            entityendermite.func_70012_b(this.field_70250_c.field_70165_t, this.field_70250_c.field_70163_u, this.field_70250_c.field_70161_v, this.field_70250_c.field_70177_z, this.field_70250_c.field_70125_A);
                            this.func_130014_f_().func_72838_d((Entity)entityendermite);
                        }
                        if (this.field_70250_c.func_184218_aH()) {
                            this.field_70250_c.func_184210_p();
                        }
                        this.field_70250_c.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                        ParticleHelper.spawnParticles((Entity)this.shooter, EnumParticleTypes.PORTAL, 0.5, 100, 0.02, new int[0]);
                        this.field_70250_c.field_70143_R = 0.0f;
                    }
                } else {
                    this.field_70250_c.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70250_c.field_70143_R = 0.0f;
                }
                this.func_70106_y();
            }
        }
        if (this.Extinguishing) {
            if (entity == null) {
                blockpos = rayTrace.func_178782_a();
                if (!this.field_70170_p.field_72995_K) {
                    for (int xx = -this.ExtinguishingRange; xx <= this.ExtinguishingRange; ++xx) {
                        for (int yy = -this.ExtinguishingRange; yy <= this.ExtinguishingRange; ++yy) {
                            for (int zz = -this.ExtinguishingRange; zz <= this.ExtinguishingRange; ++zz) {
                                BlockPos pos = blockpos.func_177982_a(xx, yy - 1, zz);
                                if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150480_ab) continue;
                                this.field_70170_p.func_175698_g(pos);
                            }
                        }
                    }
                }
                this.field_70170_p.func_184133_a((EntityPlayer)null, blockpos, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
                ParticleHelper.spawnParticles((Entity)this, EnumParticleTypes.WATER_SPLASH, 4.0, 200, 0.02, new int[0]);
                this.func_70106_y();
            } else if (entity.func_70027_ad()) {
                entity.func_70066_B();
                this.func_70106_y();
            }
        }
    }

    private void findNewTarget(double range, int cooldown) {
        List candidates = this.field_70170_p.func_72872_a(EntityLiving.class, this.func_174813_aQ().func_72314_b(range, range, range));
        if (!candidates.isEmpty()) {
            candidates.sort(Comparator.comparing(arg_0 -> ((EntityTechArrow)this).func_70068_e(arg_0), Double::compare));
            this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)((EntityLiving)candidates.get(0)).func_145782_y());
        }
        this.newTargetCooldown = cooldown;
    }

    private EntityLiving getTarget() {
        return (EntityLiving)this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(DW_TARGET_ID)).intValue());
    }

    private boolean hasTarget() {
        return this.getTarget() != null;
    }

    private double wrap180Radian(double radian) {
        radian %= Math.PI * 2;
        while (radian >= Math.PI) {
            radian -= Math.PI * 2;
        }
        while (radian < -Math.PI) {
            radian += Math.PI * 2;
        }
        return radian;
    }

    private double clampAbs(double param, double maxMagnitude) {
        if (Math.abs(param) > maxMagnitude) {
            param = param < 0.0 ? -Math.abs(maxMagnitude) : Math.abs(maxMagnitude);
        }
        return param;
    }
}

