/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.Util.ParticleHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EntityRocket
extends Entity {
    private static final Predicate<Entity> ROCKET_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.func_70067_L();
        }
    }});
    protected EntityPlayer shooter;
    private int ticksInAir = 0;
    private float power;
    private float velocity;
    protected int canAttackTimes;

    public EntityRocket(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.4f);
        this.power = 5.0f;
        this.canAttackTimes = 0;
    }

    public EntityRocket(World world, EntityPlayer owner, float power, int penetration) {
        super(world);
        this.func_70105_a(0.4f, 0.4f);
        this.power = power;
        this.canAttackTimes = penetration;
        this.shooter = owner;
    }

    public void func_70071_h_() {
        Entity target;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > 400 || this.field_70163_u > (double)this.field_70170_p.func_72800_K() || this.field_70163_u <= 1.0)) {
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if (raytraceresult != null && !this.field_70128_L && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.rangeAttack((Entity)this.shooter);
            if (this.shooter != null) {
                this.field_70170_p.func_72885_a((Entity)this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.power, false, false);
            }
            this.func_70106_y();
            return;
        }
        Entity entity = this.findEntityOnPath(vec3d1, vec3d);
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (this.canAttackTimes > 0) {
            if (raytraceresult != null && !this.field_70128_L && this.canAttackTimes - 1 >= 0 && (target = raytraceresult.field_72308_g) != null && this.shooter != target) {
                target.field_70172_ad = 0;
                if (this.shooter != null && this.shooter != target) {
                    float normalDamage = 40.0f * this.power;
                    float directDamage = 10.0f * this.power;
                    target.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)this.shooter), normalDamage);
                    if (target instanceof EntityLivingBase) {
                        EntityLivingBase enemyTarget = (EntityLivingBase)target;
                        enemyTarget.func_70606_j(enemyTarget.func_110143_aJ() - directDamage);
                    }
                    ParticleHelper.spawnParticles2(target, EnumParticleTypes.EXPLOSION_LARGE, 1.2f, 10 + (int)(Math.max(this.power, 0.0f) / 3.0f) * 5, 0.25, new int[0]);
                    this.func_184185_a(SoundEvents.field_187539_bB, 1.2f, 0.7f);
                }
                --this.canAttackTimes;
            }
            if (this.canAttackTimes <= 0) {
                if (this.shooter != null) {
                    this.field_70170_p.func_72885_a((Entity)this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.power, false, false);
                }
                this.func_70106_y();
                return;
            }
        } else if (raytraceresult != null && !this.field_70128_L && (target = raytraceresult.field_72308_g) != null) {
            this.rangeAttack((Entity)this.shooter);
            if (this.shooter != null) {
                this.field_70170_p.func_72885_a((Entity)this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.power, false, false);
            }
            this.func_70106_y();
            return;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.field_70159_w * (double)this.velocity, -this.field_70181_x * (double)this.velocity, -this.field_70179_y * (double)this.velocity, new int[]{0});
        float f1 = 0.99f;
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.001;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ROCKET_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (this.ticksInAir < 3 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    protected void func_145775_I() {
        super.func_145775_I();
    }

    public void shoot(EntityPlayer shooter, float yaw, float pitch, float velocity) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.shoot(f, (double)f1, (double)f2, velocity);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70181_x += shooter.field_70181_x;
        this.field_70179_y += shooter.field_70179_y;
        this.velocity = velocity;
    }

    private void shoot(double x, double y, double z, float velocity) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * 0.007;
        y += this.field_70146_Z.nextGaussian() * 0.007;
        z += this.field_70146_Z.nextGaussian() * 0.007;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    private void rangeAttack(Entity player) {
        Vec3i offset = new Vec3i((double)this.power, (double)this.power, (double)this.power);
        BlockPos currentPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        BlockPos minPos = currentPos.func_177973_b(offset);
        BlockPos maxPos = currentPos.func_177971_a(offset);
        AxisAlignedBB bb = new AxisAlignedBB(minPos, maxPos);
        List list = this.field_70170_p.func_175674_a((Entity)this, bb, ROCKET_TARGETS);
        for (Entity curEntity : list) {
            EntityLivingBase livingBase;
            if (!(curEntity instanceof EntityLivingBase) || (livingBase = (EntityLivingBase)curEntity) == player) continue;
            livingBase.func_70097_a(DamageSource.field_76377_j, this.power * 2.0f);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.ticksInAir = compound.func_74762_e("ticksInAir");
        this.power = compound.func_74760_g("power");
        this.velocity = compound.func_74760_g("velocity");
        this.canAttackTimes = compound.func_74762_e("canAttackTimes");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("ticksInAir", this.ticksInAir);
        compound.func_74776_a("power", this.power);
        compound.func_74776_a("velocity", this.velocity);
        compound.func_74768_a("canAttackTimes", this.canAttackTimes);
    }
}

