/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.api.MathUtil;
import jp.nechiru.advancedelectrictools.particle.EntityParticleSpray;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityGunBullet
extends Entity
implements IProjectile {
    public static final Predicate<Entity> GUN_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.func_70067_L();
        }
    }});
    protected EntityPlayer shooter;
    protected int ticksInAir;
    protected int maxExistTicks;
    protected float power;
    protected float velocity;
    protected int field_190534_ay;

    public EntityGunBullet(World world, EntityPlayer owner, float power, int maxTick) {
        super(world);
        this.ticksInAir = 0;
        this.shooter = owner;
        this.func_70105_a(0.39f, 0.39f);
        float f = -MathHelper.func_76126_a((float)(owner.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(owner.field_70125_A * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(owner.field_70125_A * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(owner.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(owner.field_70125_A * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76134_b((float)(owner.field_70177_z * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(owner.field_70177_z * ((float)Math.PI / 180)));
        this.func_70107_b(owner.field_70165_t + (double)f * 1.5 - (double)f3 * 0.35, owner.field_70163_u + (double)f1 * 1.5 + (double)this.shooter.func_70047_e() - 0.1, owner.field_70161_v + (double)f2 * 1.5 - (double)f4 * 0.35);
        this.power = power;
        this.maxExistTicks = maxTick;
    }

    public EntityGunBullet(World world) {
        super(world);
        this.func_70105_a(0.39f, 0.39f);
        this.power = 5.0f;
        this.maxExistTicks = 300;
        this.ticksInAir = 0;
    }

    public void func_70071_h_() {
        Entity target;
        Entity entity;
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.sprayEffect();
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && !this.field_70128_L && (target = raytraceresult.field_72308_g) != null) {
            if (this.shooter != null && target != this.shooter) {
                target.field_70172_ad = 0;
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.shooter), this.power);
                this.sprayEffect();
                if (this.field_190534_ay > 0) {
                    target.func_70015_d(this.field_190534_ay * 10);
                }
            }
            this.func_70106_y();
            return;
        }
        if (this.ticksInAir > this.maxExistTicks) {
            this.func_70106_y();
            return;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), GUN_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (this.shooter != null && this.shooter == entity1 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    protected void sprayEffect() {
        float initYaw = this.field_70177_z;
        float initPitch = this.field_70125_A;
        for (int i = 0; i < 2; ++i) {
            EntityParticleSpray particleSpray = new EntityParticleSpray(this.field_70170_p, this, new Vec3d((double)0.8f, 1.0, 1.0), 800, 6, true);
            particleSpray.shoot(initYaw += (float)MathUtil.getRandomFromRange(360, 0), initPitch += (float)MathUtil.getRandomFromRange(360, 0), 0.8f);
            particleSpray.setScaleSize(new Vec3d(0.08, 0.08, 0.08));
            this.field_70170_p.func_72838_d((Entity)particleSpray);
        }
    }

    public void shoot(EntityPlayer shooter, float yaw, float pitch, float velocity) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180)));
        this.func_70107_b(shooter.field_70165_t + (double)f * 1.5 - (double)f3 * 0.35, shooter.field_70163_u + (double)this.shooter.func_70047_e() + (double)f1 * 1.5 - 0.1, shooter.field_70161_v + (double)f2 * 1.5 - (double)f4 * 0.35);
        this.shoot(f, (double)f1, (double)f2, velocity);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70181_x += shooter.field_70181_x;
        this.field_70179_y += shooter.field_70179_y;
        this.velocity = velocity;
    }

    private void shoot(double x, double y, double z, float velocity) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * 0.007;
        y += this.field_70146_Z.nextGaussian() * 0.007;
        z += this.field_70146_Z.nextGaussian() * 0.007;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.ticksInAir = compound.func_74762_e("ticksInAir");
        this.power = compound.func_74760_g("power");
        this.velocity = compound.func_74760_g("velocity");
        this.maxExistTicks = compound.func_74762_e("maxExistTicks");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("ticksInAir", this.ticksInAir);
        compound.func_74776_a("power", this.power);
        compound.func_74776_a("velocity", this.velocity);
        compound.func_74768_a("maxExistTicks", this.maxExistTicks);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        this.shoot(x, y, z, velocity);
    }

    public void setDamage(double n) {
        this.power = (float)n;
    }

    public double getDamage() {
        return this.power;
    }

    public void setFire_Projectile(int b) {
        this.field_190534_ay = b;
    }
}

