/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.api;

import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class ItemStackHelper {
    public static NBTTagCompound getOrCreateCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static void setCoordinates(ItemStack stack, BlockPos pos) {
        NBTTagCompound nbtTagCompound = ItemStackHelper.getOrCreateCompound(stack);
        nbtTagCompound.func_74768_a("x", pos.func_177958_n());
        nbtTagCompound.func_74768_a("y", pos.func_177956_o());
        nbtTagCompound.func_74768_a("z", pos.func_177952_p());
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public static NBTTagCompound getNbtData(ItemStack item) {
        if (!item.func_77942_o()) {
            return new NBTTagCompound();
        }
        return item.func_77978_p();
    }

    public static ItemStack getStackWithEnergy(Item item, String name, double energy) {
        ItemStack stack = new ItemStack(item);
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77982_d(tag);
        tag.func_74780_a(name, energy);
        return stack;
    }

    public static ItemStack getNormalizedStack(ItemStack stack) {
        ItemStack result = stack.func_77946_l();
        result.func_190920_e(1);
        return result;
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_77989_b((ItemStack)ItemStackHelper.getNormalizedStack(stack1), (ItemStack)ItemStackHelper.getNormalizedStack(stack2));
    }

    public static boolean areItemStacksEqualIgnoreNBT(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
            return true;
        }
        return stack1.func_77952_i() == stack2.func_77952_i();
    }

    public static boolean hasSpace(NonNullList<ItemStack> inv, ItemStack stack) {
        for (ItemStack invStack : inv) {
            if (invStack.func_190926_b()) {
                return true;
            }
            if (!ItemStackHelper.areItemStacksEqual(stack, invStack) || invStack.func_190916_E() >= invStack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public static void gravitateEntityTowards(Entity ent, double x, double y, double z) {
        double dX = x - ent.field_70165_t;
        double dY = y - ent.field_70163_u;
        double dZ = z - ent.field_70161_v;
        double dist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double vel = 1.0 - dist / 15.0;
        if (vel > 0.0) {
            vel *= vel;
            ent.field_70159_w += dX / dist * vel * 0.1;
            ent.field_70181_x += dY / dist * vel * 0.2;
            ent.field_70179_y += dZ / dist * vel * 0.1;
        }
    }
}

