/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Util.Access;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import ic2.api.item.ElectricItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;

public class IC2Access {
    public static final IC2Access instance = new IC2Access();
    public static final String IC2_CLASSNAME = "ic2.core.IC2";
    public static final String IC2_KEYBOARD_CLASS = "ic2.core.platform.player.Keyboard";
    public static final String IC2_KEYBOARD_FIELDNAME = "keyboard";
    private Class ic2_class;
    private Class ic2_keyboard;
    private Object ic2_keyboard_instance;
    static Map<String, TextureAtlasSprite[]> textures = new HashMap<String, TextureAtlasSprite[]>();

    private IC2Access() {
        try {
            this.ic2_class = Class.forName(IC2_CLASSNAME);
            this.ic2_keyboard = Class.forName(IC2_KEYBOARD_CLASS);
            this.ic2_keyboard_instance = this.getKeyboard();
        }
        catch (ClassNotFoundException e) {
            FMLLog.severe((String)"AdvancedElectricTools Mod: failed to access IC2 classes", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public Object getKeyboard() {
        try {
            Field f = this.ic2_class.getDeclaredField(IC2_KEYBOARD_FIELDNAME);
            return f.get(null);
        }
        catch (Exception e) {
            FMLLog.severe((String)"AdvancedElectricTools Mod: failed to access IC2 keyboard", (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    public boolean isKeyDown(String keyName, EntityPlayer ep) {
        if (this.ic2_keyboard != null && this.ic2_keyboard_instance != null) {
            String methodName = "is" + keyName + "KeyDown";
            try {
                Method m = this.ic2_keyboard.getMethod(methodName, EntityPlayer.class);
                return (Boolean)m.invoke(this.ic2_keyboard_instance, ep);
            }
            catch (Exception e) {
                FMLLog.severe((String)"AdvancedElectricTools Mod: failed to access IC2 keyboard", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
        return false;
    }

    public String getKeyName(int keyName) {
        if (this.ic2_keyboard != null && this.ic2_keyboard_instance != null) {
            try {
                Method m = this.ic2_keyboard.getMethod("getKeyName", Integer.TYPE);
                return ((String)m.invoke(this.ic2_keyboard_instance, keyName)).toString();
            }
            catch (Exception e) {
                FMLLog.severe((String)"AdvancedElectricTools Mod: failed to access IC2 keyboard", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
        return "Unknown Key";
    }

    public static TextureAtlasSprite[] getTextures(String par1) {
        return textures.get(par1);
    }

    public static void messagePlayer(EntityPlayer player, TextFormatting color, String message) {
        TextComponentString text = new TextComponentString(message);
        text.func_150256_b().func_150238_a(color);
        player.func_145747_a((ITextComponent)text);
    }

    public static boolean isSimulating() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static ItemStack getChargedStack(ItemStack stack) {
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        return stack;
    }

    public static boolean isToolEffective(IBlockState state, ItemStack stack) {
        String tool = state.func_177230_c().getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return false;
        }
        return stack.func_77973_b().getHarvestLevel(stack, tool, null, state) >= state.func_177230_c().getHarvestLevel(state);
    }

    public static RayTraceResult rayTrace(World worldIn, EntityLivingBase playerIn, boolean useLiquids, double maxDistance) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * maxDistance, (double)f5 * maxDistance, (double)f7 * maxDistance);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public static RayTraceResult rayTraceEntities(World worldIn, EntityLivingBase playerIn, boolean useLiquids, double maxDistane) {
        return IC2Access.rayTraceEntities(worldIn, playerIn, maxDistane);
    }

    public static RayTraceResult rayTraceEntities(World worldIn, EntityLivingBase playerIn, double maxDistance) {
        double d1;
        Vec3d vec3d = new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v);
        Vec3d vec3d1 = playerIn.func_70040_Z();
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * maxDistance, vec3d1.field_72448_b * maxDistance, vec3d1.field_72449_c * maxDistance);
        Entity pointedEntity = null;
        Vec3d vec3d3 = null;
        float f = 1.0f;
        List list = worldIn.func_175674_a((Entity)playerIn, playerIn.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * maxDistance, vec3d1.field_72448_b * maxDistance, vec3d1.field_72449_c * maxDistance).func_186662_g(1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity != null && entity.func_70067_L() && (entity instanceof EntityLivingBase || entity instanceof MultiPartEntityPart || entity instanceof EntityEnderCrystal);
            }
        }));
        double d2 = d1 = maxDistance;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == playerIn.func_184208_bv() && !playerIn.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = raytraceresult.field_72307_f;
            d2 = d3;
        }
        if (pointedEntity != null) {
            return new RayTraceResult(pointedEntity, vec3d3);
        }
        return null;
    }

    public static class SpriteReloadEvent
    extends Event {
    }
}

