/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVajra
extends ItemTool
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemVajra";
    public static final String NAME = "Vajra";
    public static final int TIER = 3;
    public static final float DAMAGE = 39.0f;
    public static final int STORAGE = 3000000;
    public static final int ENERGY_USE = 1000;
    public static final int ENERGY_TRFR_Lim = 512;

    public ItemVajra() {
        super(0.0f, 1.0f, Item.ToolMaterial.DIAMOND, new HashSet());
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        boolean silktouch = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("SilkTouch");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Toggle the SilkTouch");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Selected Mode");
            tooltip.add("");
            tooltip.add("Item Click on Block Actions");
            tooltip.add("Collect blocks");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("SilkTouch : " + (silktouch ? "Enabled" : "Disabled"));
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        tooltip.add("");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        boolean silktouch = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("SilkTouch");
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("ModeSwitch", player)) {
            if (silktouch) {
                enchantments.remove(Enchantments.field_185306_r, 1);
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                stack.func_77978_p().func_74757_a("SilkTouch", false);
                IC2Access.messagePlayer(player, TextFormatting.AQUA, "Vajra : SilkTouch Disabled");
            } else {
                enchantments.put(Enchantments.field_185306_r, 1);
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                stack.func_77978_p().func_74757_a("SilkTouch", true);
                IC2Access.messagePlayer(player, TextFormatting.AQUA, "Vajra : SilkTouch Enabled");
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", player)) {
            IC2Access.messagePlayer(player, TextFormatting.GOLD, "SilkTouch: " + (silktouch ? "Enabled" : "Disabled"));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    private boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        float blockHardness = blockState.func_185887_b(worldIn, pos);
        if (blockHardness < 0.0f) {
            return false;
        }
        return blockState.func_177230_c().canHarvestBlock((IBlockAccess)worldIn, pos, playerIn);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        SoundType soundType = block.getSoundType(blockState, world, pos, (Entity)player);
        if (ElectricItem.manager.getCharge(stack) >= 1000.0 && this.shouldBreak(player, world, pos)) {
            ElectricItem.manager.use(stack, 1000.0, (EntityLivingBase)player);
            blockState.func_177230_c().func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), stack);
            world.func_184133_a(null, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            world.func_175698_g(pos);
            world.func_175713_t(pos);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            if (ElectricItem.manager.getCharge(stack) >= 2000.0) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Vajra Powered Damage", 39.0, 0));
            } else {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Vajra Unpowered Damage", 3.0, 0));
            }
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        ElectricItem.manager.use(stack, 2000.0, attacker);
        return true;
    }

    public float getMiningSpeed(ItemStack stack) {
        return 16384.0f;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            ElectricItem.manager.use(stack, 1000.0, entityLiving);
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!ElectricItem.manager.canUse(stack, 1000.0)) {
            return 1.0f;
        }
        if (IC2Access.isToolEffective(state, stack)) {
            return this.getMiningSpeed(stack);
        }
        if (this.canHarvestBlock(state, stack)) {
            return this.getMiningSpeed(stack);
        }
        Material material = state.func_185904_a();
        return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l ? super.func_150893_a(stack, state) : this.getMiningSpeed(stack);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Items.field_151046_w.func_150897_b(state) || Items.field_151047_v.func_150897_b(state) || Items.field_151056_x.func_150897_b(state) || Items.field_151048_u.func_150897_b(state);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        return 3;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe", (Object)"sword");
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.DIGGER;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 3000000.0;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 512.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

