/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTeslaStaff
extends ItemTool
implements IElectricItem {
    public static final int STORAGE = 10000000;
    public static final float ENERGY_USE = 100000.0f;
    public static final int ENERGY_TRFR_Lim = 2048;
    public static final int TIER = 3;
    public static final float[] DAMAGE = new float[]{499.0f, 799.0f};
    private static boolean TARGET_IGNORE_WALLS = true;
    public static final int RANGE = 1000;

    public ItemTeslaStaff() {
        super(0.0f, 1.0f, Item.ToolMaterial.DIAMOND, new HashSet());
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "storage_energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ElectricItem.manager.canUse(stack, 100000.0) ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!(attacker instanceof EntityPlayer)) {
            return true;
        }
        if (ElectricItem.manager.canUse(stack, 100000.0)) {
            target.field_70172_ad = 0;
            target.func_70097_a(DamageSource.field_76376_m, DAMAGE[0] * 0.1f);
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), DAMAGE[0]);
            attacker.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(attacker.field_70170_p, target.field_70142_S, target.field_70137_T, target.field_70136_U, false));
            ElectricItem.manager.use(stack, 100000.0, attacker);
            PotionEffect potioneffect = new PotionEffect(MobEffects.field_76421_d, 400, 10, false, false);
            target.func_70690_d(potioneffect);
            SoundEvent channering = (double)field_77697_d.nextFloat() > 0.4 ? Sounds.Channeling1 : Sounds.Channeling0;
            attacker.field_70170_p.func_184148_a((EntityPlayer)null, target.field_70165_t, target.field_70163_u, target.field_70161_v, channering, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.2f + 0.8f));
        } else {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 1.0f);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        EntityPlayer entityLiving = playerIn;
        if (!worldIn.field_72995_K && IC2Access.isSimulating() && ElectricItem.manager.use(stack, 200000.0, (EntityLivingBase)playerIn)) {
            Entity currTarget = this.getValidTarget(worldIn, (EntityLivingBase)entityLiving);
            if (currTarget != null) {
                this.LightningBolt(worldIn, playerIn, currTarget, (EntityLivingBase)entityLiving, stack);
            } else {
                RayTraceResult resultBlock = IC2Access.rayTrace(worldIn, (EntityLivingBase)playerIn, false, 1000.0);
                BlockPos pos = resultBlock.func_178782_a();
                int random = (int)Math.max(worldIn.field_73012_v.nextGaussian() * 3.0, 0.0);
                float exp_pow = worldIn.func_72896_J() ? (float)random : 0.0f;
                this.Lightning(worldIn, (Entity)playerIn, 3, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                worldIn.func_72885_a((Entity)playerIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 7.0f + exp_pow, false, false);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    private void LightningBolt(World world, EntityPlayer playerIn, Entity target, EntityLivingBase shooter, ItemStack stack) {
        if (IC2Access.isSimulating()) {
            int random = (int)Math.max(world.field_73012_v.nextGaussian() * 3.0, 0.0);
            target.func_70015_d(200);
            EntityLivingBase targetLiving = (EntityLivingBase)target;
            targetLiving.field_70172_ad = 0;
            targetLiving.field_70737_aN = 0;
            targetLiving.field_70738_aO = 0;
            target.func_70097_a(DamageSource.field_180137_b, DAMAGE[1]);
            PotionEffect potioneffect = new PotionEffect(MobEffects.field_76421_d, 200, 3, false, false);
            ((EntityLivingBase)target).func_70690_d(potioneffect);
            potioneffect = new PotionEffect(MobEffects.field_76440_q, 200, 3, false, false);
            ((EntityLivingBase)target).func_70690_d(potioneffect);
            this.Lightning(playerIn.field_70170_p, (Entity)playerIn, 3, target.field_70165_t, target.field_70163_u, target.field_70161_v);
        }
    }

    private void Lightning(World world, Entity entityIn, int ThunderNum, double posX, double posY, double posZ) {
        int rain = world.func_72896_J() ? 4 : 0;
        int random = (int)Math.max(world.field_73012_v.nextGaussian() * 3.0, 0.0);
        for (int i = 0; i < ThunderNum + rain + random; ++i) {
            EntityLightningBolt entityLightningBolt = new EntityLightningBolt(world, posX + world.field_73012_v.nextGaussian(), posY + world.field_73012_v.nextGaussian(), posZ + world.field_73012_v.nextGaussian(), false);
            world.func_72942_c((Entity)entityLightningBolt);
        }
        SoundEvent channering = (double)field_77697_d.nextFloat() > 0.5 ? Sounds.Channeling1 : Sounds.Channeling0;
        world.func_184148_a((EntityPlayer)null, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, channering, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.2f + 0.8f));
    }

    private Entity getValidTarget(World world, EntityLivingBase source) {
        RayTraceResult result;
        if (IC2Access.isSimulating() && (result = IC2Access.rayTraceEntities(world, source, 1000.0)) != null && result.field_72313_a == RayTraceResult.Type.ENTITY && (result.field_72308_g instanceof EntityLivingBase || result.field_72308_g instanceof MultiPartEntityPart || result.field_72308_g instanceof EntityEnderCrystal)) {
            RayTraceResult resultBlock;
            if (!TARGET_IGNORE_WALLS && (resultBlock = IC2Access.rayTrace(world, source, false, result.field_72308_g.func_70032_d((Entity)source))) != null && resultBlock.field_72313_a == RayTraceResult.Type.BLOCK) {
                return null;
            }
            return result.field_72308_g;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1.0E7;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 2048.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A || ench == Enchantments.field_185307_s;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

