/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import jp.nechiru.advancedelectrictools.entities.EntityHyperGunBullet;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTacticalLaserSubmachineGun
extends ItemSword
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemTacticalLaserSubmachineGun";
    public static final String NAME = "Tactical Laser Submachine Gun";
    public static final int TIER = 3;
    public static final float[] DAMAGE = new float[]{16.0f, 24.0f};
    public static final int STORAGE = 1000000;
    public static final int ENERGY_Mode1_USE = 100;
    public static final int ENERGY_Mode2_USE = 50;
    public static final int ENERGY_TRFR_Lim = 512;

    public ItemTacticalLaserSubmachineGun() {
        super(Item.ToolMaterial.DIAMOND);
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "tl_electric_sub_machinegun_active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ElectricItem.manager.canUse(stack, 50.0) ? 1.0f : 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        long lastRightClick = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("LastRightClick");
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastRightClick > 40L && ElectricItem.manager.use(stack, 100.0, (EntityLivingBase)playerIn)) {
            int k;
            EntityHyperGunBullet entity = new EntityHyperGunBullet(worldIn, playerIn, DAMAGE[0], 360);
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
            if (j > 0) {
                entity.setDamage(entity.getDamage() + entity.getDamage() * 0.25 * (double)(j + 1));
            }
            if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack)) > 0) {
                entity.setFire_Projectile(k * 5);
            }
            entity.shoot(playerIn, playerIn.field_70177_z, playerIn.field_70125_A, 5.0f);
            worldIn.func_72838_d((Entity)entity);
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.laserbulletShoot, playerIn.func_184176_by(), 0.4f, 1.0f);
            stack.func_77978_p().func_74772_a("LastRightClick", lastRightClick);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase mob, EntityLivingBase player) {
        if (ElectricItem.manager.canUse(stack, 50.0)) {
            ElectricItem.manager.use(stack, 50.0, player);
        }
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap hashMultimap = HashMultimap.create();
        boolean canUse = ElectricItem.manager.canUse(stack, 100.0);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            hashMultimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 1.2, 0));
            hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", canUse ? (double)DAMAGE[1] : 4.0, 0));
        }
        return hashMultimap;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.WEAPON;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1000000.0;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 512.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

