/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.ImmutableSet;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import java.util.Set;
import jp.nechiru.advancedelectrictools.Item.tool.electric.AdvancedMiningDrill;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRockCutter
extends AdvancedMiningDrill
implements IElectricItem,
IElectricTool {
    public static final String UNLOCALIZED_NAME = "itemRockCutter";
    public static final String NAME = "RockCutter";
    public static final int TIER = 2;
    public static final float DAMAGE = 7.0f;
    public static final int STORAGE = 40000;
    public static final int ENERGY_TRFR_Lim = 128;
    static final int CHARGE = 200;

    public ItemRockCutter() {
        this.field_77865_bY = 7.0f;
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("Reinforcement SilkTouch");
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World worldIn = player.field_70170_p;
        this.breakBlock(pos, worldIn, player, stack);
        return false;
    }

    public void breakBlock(BlockPos pos, World world, EntityPlayer player, ItemStack stack) {
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack)) && !this.shouldBreak(player, world, pos, pos)) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        SoundType soundType = block.getSoundType(blockState, world, pos, (Entity)player);
        ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), (EntityLivingBase)player);
        this.AdvancedharvestBlock(world, player, pos, blockState, world.func_175625_s(pos), stack);
        world.func_175713_t(pos);
        world.func_175698_g(pos);
        world.func_184133_a(null, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Items.field_151046_w.func_150897_b(state) || Items.field_151047_v.func_150897_b(state) || Items.field_151056_x.func_150897_b(state);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        return 3;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe", (Object)"sword", (Object)"shears");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.SUCCESS;
    }

    public int getEnergyCost(ItemStack stack) {
        return 200;
    }

    public float getMiningSpeed(ItemStack stack) {
        return 128.0f;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), entityLiving);
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            return 1.0f;
        }
        if (IC2Access.isToolEffective(state, stack)) {
            return this.getMiningSpeed(stack);
        }
        if (this.canHarvestBlock(state, stack)) {
            return this.getMiningSpeed(stack);
        }
        return super.func_150893_a(stack, state);
    }

    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185306_r || ench == Enchantments.field_185305_q;
    }

    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return false;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 40000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 128.0;
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

