/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.Util.ParticleHelper;
import jp.nechiru.advancedelectrictools.Util.PlayerEvent;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemQuantumSaber
extends ItemSword
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemQuantumSaber";
    public static final String NAME = "Quantum Saber";
    public static final int TIER = 3;
    public static final float DAMAGE = 59.0f;
    public static final int STORAGE = 1000000;
    public static final int ENERGY_Mode1_USE = 500;
    public static final int ENERGY_Mode2_USE = 2000;
    public static final int ENERGY_TRFR_Lim = 512;

    public ItemQuantumSaber() {
        super(Item.ToolMaterial.DIAMOND);
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "quantumsaber_active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ElectricItem.manager.canUse(stack, 500.0) && entity != null && entity.func_184614_ca() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Toggle the Smash Mode");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Mode");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add(mode > 0 ? "SmashMode : Enabled" : "SmashMode : Disabled");
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        tooltip.add("");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("ModeSwitch", playerIn)) {
            if (mode == 1) {
                stack.func_77978_p().func_74768_a("Mode", 0);
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "QuantumSaber SmashMode : Disabled");
            } else if (mode == 0) {
                if (ElectricItem.manager.canUse(stack, 2000.0)) {
                    stack.func_77978_p().func_74768_a("Mode", 1);
                    IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "QuantumSaber SmashMode : Enabled");
                } else {
                    IC2Access.messagePlayer(playerIn, TextFormatting.RED, "QuantumSaber : Low battery Please recharge the quantumsaber");
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", playerIn)) {
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, mode > 0 ? "QuantumSaber SmashMode : Enabled" : "QuantumSaber SmashMode : Disabled");
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase mob, EntityLivingBase player) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
        int l = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack);
        float damage = 60.0f + 0.5f * (float)j + 0.5f;
        float setdamage = damage + 1.0f + damage * (float)(l / (l + 1));
        if (mob instanceof EntityPlayer) {
            PlayerEvent.DisabledShield((EntityPlayer)mob);
        }
        if (mode == 1) {
            if (ElectricItem.manager.canUse(stack, 2000.0)) {
                ElectricItem.manager.use(stack, 2000.0, player);
                double vx = -Math.sin(player.field_70177_z * ((float)Math.PI / 180)) * (double)0.6f;
                double vz = Math.cos(player.field_70177_z * ((float)Math.PI / 180)) * (double)0.6f;
                mob.func_70024_g(vx * 100.0, 0.1, vz * 100.0);
                mob.field_70172_ad = 0;
                mob.field_70737_aN = 0;
                mob.field_70738_aO = 0;
                this.PenetrationDamage(mob, player, setdamage, 0.1f);
            }
            if (!mob.field_70170_p.field_72995_K && !mob.func_70045_F()) {
                ParticleHelper.spawnParticles((Entity)mob, EnumParticleTypes.FALLING_DUST, 2.0, 200, 0.02, new int[0]);
            }
            if (!ElectricItem.manager.canUse(stack, 2000.0)) {
                stack.func_77978_p().func_74768_a("Mode", 0);
                enchantments.remove(Enchantments.field_180313_o, 60);
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
            }
        } else if (ElectricItem.manager.canUse(stack, 500.0)) {
            ElectricItem.manager.use(stack, 500.0, player);
            mob.field_70172_ad = 0;
            mob.field_70737_aN = 0;
            mob.field_70738_aO = 0;
            this.PenetrationDamage(mob, player, setdamage, 0.1f);
        }
        return true;
    }

    private void PenetrationDamage(EntityLivingBase mob, EntityLivingBase player, float damage, float n) {
        if (field_77697_d.nextFloat() >= 1.0f - n) {
            mob.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), damage);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        boolean canUse = ElectricItem.manager.canUse(stack, 500.0);
        Block block = state.func_177230_c();
        if (!canUse) {
            return 1.0f;
        }
        Material material = state.func_185904_a();
        if (material == Material.field_151569_G || material == Material.field_151592_s || material != Material.field_151584_j) {
            return 16384.0f;
        }
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap hashMultimap = HashMultimap.create();
        boolean canUse = ElectricItem.manager.canUse(stack, 500.0);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            hashMultimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 5.0, 0));
            hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", canUse ? 59.0 : 4.0, 0));
        }
        return hashMultimap;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.WEAPON;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1000000.0;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 512.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

