/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Item.armor.ItemQuantumRing;
import jp.nechiru.advancedelectrictools.Item.armor.ItemReinforcedQuantumRing;
import jp.nechiru.advancedelectrictools.Item.armor.ItemReinforcedQuantumSuite;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.Util.ParticleHelper;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemQuantumFirstAidLifeSupport
extends ItemTool
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemElectricFirstAidLifeSupport";
    public static final String NAME = "Electric First Aid LifeSupport";
    public static final int TIER = 3;
    public static final int STORAGE = 1000000;
    public static final float[] ENERGY_USE = new float[]{100.0f, 150.0f, 50.0f};
    public static final int RESISTANCE_USE_TICK = 10;
    public static final int ENERGY_TRFR_Lim = 512;

    public ItemQuantumFirstAidLifeSupport() {
        super(0.0f, 1.0f, Item.ToolMaterial.DIAMOND, new HashSet());
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "storage_energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)(ElectricItem.manager.getCharge(stack) / 1000000.0);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        boolean autoSupplement = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("AutoSupplement");
        boolean hardening = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Hardening");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Toggle the Auto First Aid");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(1) + ") to: Toggle the Force Field");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Mode");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("Auto first aid : " + (autoSupplement ? "Enabled" : "Disable"));
        tooltip.add("Force field : " + (hardening ? "Enabled" : "Disable"));
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        tooltip.add("");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        boolean shouldWork = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("AutoSupplement");
        boolean hardening = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Hardening");
        boolean curePotion = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("curePotion");
        if (!worldIn.field_72995_K && curePotion) {
            this.curePotionEffect((EntityLivingBase)entityIn);
            if (!this.ActivePotion((EntityLivingBase)entityIn)) {
                stack.func_77978_p().func_74757_a("curePotion", false);
            }
        }
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            if (shouldWork) {
                float currentAbsAmount = player.func_110139_bj();
                float currentHealth = player.func_110143_aJ();
                if (currentAbsAmount < 60.0f && ElectricItem.manager.use(stack, (double)ENERGY_USE[1], (EntityLivingBase)player)) {
                    player.func_110149_m(Math.min(currentAbsAmount + 1.0f, 60.0f));
                }
                if (currentHealth < player.func_110138_aP()) {
                    if (ElectricItem.manager.use(stack, (double)ENERGY_USE[1], (EntityLivingBase)player)) {
                        player.func_70606_j(currentHealth + 2.0f);
                    }
                    player.field_71069_bz.func_75142_b();
                }
                if ((player.func_70027_ad() || player.func_180799_ab()) && ElectricItem.manager.canUse(stack, (double)ENERGY_USE[2])) {
                    if (ItemQuantumFirstAidLifeSupport.getRing(player) == null && !ItemReinforcedQuantumSuite.isFullRFQuantumSuit(player)) {
                        player.func_70066_B();
                        player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 250, 0, true, false));
                        if (worldIn.func_82737_E() % 10L == 0L) {
                            ElectricItem.manager.use(stack, (double)ENERGY_USE[2], (EntityLivingBase)entityIn);
                        }
                    }
                }
                if (!ElectricItem.manager.canUse(stack, (double)ENERGY_USE[0])) {
                    stack.func_77978_p().func_74757_a("AutoSupplement", false);
                    IC2Access.messagePlayer(player, TextFormatting.AQUA, "QuantumFirstAidLifeSupport : Auto first aid disable");
                }
            }
            if (hardening) {
                if (ElectricItem.manager.canUse(stack, (double)ENERGY_USE[2])) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 250, 3, true, false));
                    if ((double)(worldIn.func_72820_D() % 10L) == 0.0) {
                        ElectricItem.manager.use(stack, (double)ENERGY_USE[2], (EntityLivingBase)entityIn);
                    }
                } else {
                    stack.func_77978_p().func_74757_a("Hardening", false);
                    IC2Access.messagePlayer(player, TextFormatting.AQUA, "QuantumFirstAidLifeSupport : Force field disable");
                }
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        boolean autoSupplement = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("AutoSupplement");
        boolean hardening = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Hardening");
        if (IC2Access.isSimulating() && !IC2Access.instance.isKeyDown("Alt", playerIn)) {
            if (IC2Access.instance.isKeyDown("ModeSwitch", playerIn)) {
                autoSupplement = !autoSupplement;
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "QuantumFirstAidLifeSupport : Auto first aid " + (autoSupplement ? "enabled" : "disable"));
                stack.func_77978_p().func_74757_a("AutoSupplement", autoSupplement);
            } else if (IC2Access.instance.isKeyDown("Boost", playerIn)) {
                hardening = !hardening;
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "QuantumFirstAidLifeSupport : Force field " + (hardening ? "enabled" : "disable"));
                stack.func_77978_p().func_74757_a("Hardening", hardening);
            } else if (this.ActivePotion((EntityLivingBase)playerIn)) {
                if (ElectricItem.manager.canUse(stack, (double)ENERGY_USE[0])) {
                    playerIn.func_70066_B();
                    this.cureBadPotionEffect((EntityLivingBase)playerIn);
                    stack.func_77978_p().func_74757_a("curePotion", true);
                    ElectricItem.manager.use(stack, (double)ENERGY_USE[0], (EntityLivingBase)playerIn);
                    ParticleHelper.spawnParticles((Entity)playerIn, EnumParticleTypes.VILLAGER_HAPPY, 1.0, 60, 0.05, new int[0]);
                    IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "QuantumFirstAidLifeSupport : Remove effects");
                }
            } else {
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "QuantumFirstAidLifeSupport : No potion effects");
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", playerIn)) {
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "QuantumFirstAidLifeSupport Auto first aid : " + (autoSupplement ? "Enabled" : "Disable"));
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "                              Force field : " + (hardening ? "Enabled" : "Disable"));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public static ItemStack getRing(EntityPlayer ep) {
        InventoryPlayer inventory = ep.field_71071_by;
        int i = 0;
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack != null) {
                boolean q_ring = stack.func_77973_b() instanceof ItemQuantumRing;
                boolean rf_q_ring = stack.func_77973_b() instanceof ItemReinforcedQuantumRing;
                if ((q_ring || rf_q_ring) && inventory.func_184429_b(stack) <= 8) {
                    return stack;
                }
            }
            ++i;
        }
        return null;
    }

    public void removePotion(EntityLivingBase entity, Potion potion) {
        entity.func_184589_d(potion);
    }

    public void curePotionEffect(EntityLivingBase entity) {
        Iterator iterator = entity.func_70651_bq().iterator();
        if (iterator.hasNext()) {
            Potion potion = ((PotionEffect)iterator.next()).func_188419_a();
            this.removePotion(entity, potion);
        }
    }

    public void cureBadPotionEffect(EntityLivingBase entity) {
        if (entity.func_70660_b(MobEffects.field_76436_u) != null) {
            this.removePotion(entity, MobEffects.field_76436_u);
        }
        if (entity.func_70660_b(MobEffects.field_189112_A) != null) {
            this.removePotion(entity, MobEffects.field_189112_A);
        }
        if (entity.func_70660_b(MobEffects.field_82731_v) != null) {
            this.removePotion(entity, MobEffects.field_82731_v);
        }
        if (entity.func_70660_b(MobEffects.field_76421_d) != null) {
            this.removePotion(entity, MobEffects.field_76421_d);
        }
        if (entity.func_70660_b(MobEffects.field_76437_t) != null) {
            this.removePotion(entity, MobEffects.field_76437_t);
        }
        if (entity.func_70660_b(MobEffects.field_76419_f) != null) {
            this.removePotion(entity, MobEffects.field_76419_f);
        }
        if (entity.func_70660_b(MobEffects.field_76440_q) != null) {
            this.removePotion(entity, MobEffects.field_76440_q);
        }
        if (entity.func_70660_b(MobEffects.field_76431_k) != null) {
            this.removePotion(entity, MobEffects.field_76431_k);
        }
        if (entity.func_70660_b(MobEffects.field_188423_x) != null) {
            this.removePotion(entity, MobEffects.field_188423_x);
        }
        if (entity.func_70660_b(MobEffects.field_188424_y) != null) {
            this.removePotion(entity, MobEffects.field_188424_y);
        }
    }

    public boolean ActivePotion(EntityLivingBase entity) {
        Iterator iterator = entity.func_70651_bq().iterator();
        return iterator.hasNext();
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1000000.0;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 512.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

