/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import java.util.Set;
import jp.nechiru.advancedelectrictools.Item.tool.electric.AdvancedChainsaw;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemQuantumChainsaw
extends AdvancedChainsaw
implements IElectricItem {
    public static final ItemStack diamondAxe = new ItemStack(Items.field_151056_x);
    public static final String UNLOCALIZED_NAME = "itemQuantumChainsaw";
    public static final String NAME = "Quantum Chainsaw";
    public static final int TIER = 3;
    public static final float DAMAGE = 39.0f;
    public static final float EFFICIENCY = 512.0f;
    public static final int STORAGE = 1000000;
    public static final int ENERGY_TRFR_Lim = 512;
    public static final int ENERGY_USE = 200;

    public ItemQuantumChainsaw() {
        this.field_77864_a = 512.0f;
        this.field_185065_c = 1.0f;
        this.field_77865_bY = 5.0f;
        this.setHarvestLevel("axe", 3);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Toggle the Tree Cutting Mode");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Mode");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("TreeCuttingMode : " + (mode ? "Enabled" : "Disabled"));
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        tooltip.add("");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("ModeSwitch", player)) {
            mode = !mode;
            stack.func_77978_p().func_74757_a("Mode", mode);
            IC2Access.messagePlayer(player, TextFormatting.AQUA, "QuantumChainsaw : TreeCuttingMode " + (mode ? "Enabled" : "Disabled"));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", player)) {
            IC2Access.messagePlayer(player, TextFormatting.GOLD, "QuantumChainsaw : TreeCuttingMode " + (mode ? "Enabled" : "Disabled"));
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return diamondAxe.func_150998_b(state) || state.func_177230_c() == Blocks.field_150321_G;
    }

    public int getEnergyCost(ItemStack stack) {
        return 200;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            return 1.0f;
        }
        return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151584_j && material != Material.field_151570_A && material != Material.field_151572_C && material != Material.field_151580_n ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(stack, (IBlockAccess)entity.field_70170_p, pos) && ElectricItem.manager.canUse(stack, (double)(this.getEnergyCost(stack) * 2))) {
                List drops = target.onSheared(stack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                for (ItemStack item : drops) {
                    EntityItem ent = entity.func_70099_a(item, 1.0f);
                    ent.field_70181_x += (double)(entity.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
                }
                ElectricItem.manager.use(stack, (double)(this.getEnergyCost(stack) * 2), (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        Set<BlockPos> positions;
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        World worldIn = player.field_70170_p;
        if (!player.func_70093_af() && mode && !(positions = this.getTargetBlocks(worldIn, pos, player)).isEmpty()) {
            for (BlockPos pos2 : positions) {
                this.breakBlock(pos2, stack, worldIn, pos, player);
            }
        }
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(stack, (IBlockAccess)player.field_70170_p, pos) && ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            List drops = target.onSheared(stack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            for (ItemStack itemstack : drops) {
                float f = 0.7f;
                double d = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(player.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack);
                entityitem.func_174869_p();
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), (EntityLivingBase)player);
            player.func_71029_a(StatList.func_188055_a((Block)block));
            if (block == Blocks.field_150321_G) {
                player.field_70170_p.func_175698_g(pos);
                return true;
            }
        }
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), entity);
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entity);
    }

    public void breakBlock(BlockPos pos, ItemStack stack, World world, BlockPos oldPos, EntityPlayer player) {
        if (oldPos == pos) {
            return;
        }
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185887_b(world, pos) == -1.0f) {
            return;
        }
        ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), (EntityLivingBase)player);
        blockState.func_177230_c().func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), stack);
        world.func_175698_g(pos);
        world.func_175713_t(pos);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap hashMultimap = HashMultimap.create();
        boolean canUse = ElectricItem.manager.canUse(stack, 200.0);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", canUse ? 39.0 : 4.0, 0));
        }
        return hashMultimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!(attacker instanceof EntityPlayer)) {
            return true;
        }
        ElectricItem.manager.use(stack, 200.0, attacker);
        return true;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.DIGGER;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1000000.0;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 512.0;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

