/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashSet;
import java.util.List;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPocketRefrigerant
extends ItemTool
implements IElectricItem {
    public static final int TIER = 2;
    public static final int STORAGE = 40000;
    public static final float ENERGY_USE = 20.0f;
    public static final int ENERGY_TRFR_Lim = 128;

    public ItemPocketRefrigerant() {
        super(0.0f, 1.0f, Item.ToolMaterial.DIAMOND, new HashSet());
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        int mode = ItemStackHelper.getOrCreateNbtData(stack).func_74762_e("Mode");
        tooltip.add("Removes fire from you");
        tooltip.add("");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        EntityPlayerMP player = (EntityPlayerMP)entity;
        if ((player.func_180799_ab() || player.func_70027_ad()) && ElectricItem.manager.canUse(stack, 20.0) && (double)(world.func_72820_D() % 10L) == 0.0) {
            player.func_70066_B();
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 250, 0, true, false));
            ElectricItem.manager.use(stack, 20.0, (EntityLivingBase)entity);
        }
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 40000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 128.0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

