/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.MathUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPlasmaAirCannon
extends ItemTool
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemPlasmaAirCannon";
    public static final String NAME = "Plasma Air Cannon";
    public static final int DAMAGE = 18;
    public static final float EFFRANGE_CO = 1.5f;
    public static final int TIER = 2;
    public static final int STORAGE = 40000;
    public static final int ENERGY_USE = 200;
    public static final int ENERGY_TRFR_Lim = 128;
    private static final Predicate<Entity> ATTACK_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return input.func_70067_L();
        }
    }});

    public ItemPlasmaAirCannon() {
        super(0.0f, 1.0f, Item.ToolMaterial.DIAMOND, new HashSet());
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "plasma_charge_percent"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack) {
                    return (float)(stack.func_77988_m() - entity.func_184605_cv()) / 25.0f;
                }
                return 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)true);
        if (ret != null) {
            return ret;
        }
        worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.plasmaCharge, playerIn.func_184176_by(), 1.0f, 1.0f);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            int expandSize = Math.min(this.func_77626_a(stack) - timeLeft, 20) / 20 * 32;
            expandSize = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)expandSize, (boolean)true);
            if (ElectricItem.manager.use(stack, 200.0, (EntityLivingBase)entityplayer)) {
                float pitch = entityplayer.field_70125_A;
                float yaw = entityplayer.field_70177_z;
                Vec3d currentPostion = new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v);
                Vec3d lookPosition = new Vec3d((double)(-MathHelper.func_76126_a((float)(yaw * 0.0174f)) * MathHelper.func_76134_b((float)(pitch * 0.0174f))), (double)(-MathHelper.func_76126_a((float)(pitch * 0.0174f))), (double)(MathHelper.func_76134_b((float)(yaw * 0.0174f)) * MathHelper.func_76134_b((float)(pitch * 0.0174f))));
                Vec3d targetPostion = new Vec3d(entityplayer.field_70165_t + lookPosition.field_72450_a * (double)expandSize * 1.5, entityplayer.field_70163_u + lookPosition.field_72448_b * (double)expandSize * 1.5, entityplayer.field_70161_v + lookPosition.field_72449_c * (double)expandSize * 1.5);
                List list = worldIn.func_175674_a((Entity)entityplayer, new AxisAlignedBB(currentPostion.field_72450_a, currentPostion.field_72448_b, currentPostion.field_72449_c, targetPostion.field_72450_a, targetPostion.field_72448_b, targetPostion.field_72449_c).func_72321_a(1.0, 1.0, 1.0), ATTACK_TARGETS);
                int u = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
                double velocity = expandSize / 3;
                for (int index = 0; index < list.size(); ++index) {
                    Entity entity1 = (Entity)list.get(index);
                    double distance = currentPostion.func_72438_d(new Vec3d(entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v));
                    double damage = 18.0 + (double)expandSize / ((double)expandSize == 0.0 ? 1.0 : distance);
                    entity1.func_70024_g(lookPosition.field_72450_a * velocity, lookPosition.field_72448_b * velocity, lookPosition.field_72449_c * velocity);
                    entity1.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entityplayer), (float)damage);
                    entity1.field_70170_p.func_72885_a((Entity)(u > 0 ? entityplayer : null), entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, 5.0f, false, false);
                }
                worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187539_bB, entityplayer.func_184176_by(), 1.0f * (float)(expandSize / 15 + 1), 1.0f);
                for (int p = 0; p < 20; ++p) {
                    float newYaw = yaw + (float)MathUtil.getRandomFromRange(8, -8);
                    float newPitch = pitch + (float)MathUtil.getRandomFromRange(8, -8);
                    Vec3d shootPosition = new Vec3d((double)(-MathHelper.func_76126_a((float)(newYaw * 0.0174f)) * MathHelper.func_76134_b((float)(newPitch * 0.0174f))), (double)(-MathHelper.func_76126_a((float)(newPitch * 0.0174f))), (double)(MathHelper.func_76134_b((float)(newYaw * 0.0174f)) * MathHelper.func_76134_b((float)(newPitch * 0.0174f))));
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, entityplayer.field_70165_t, entityplayer.field_70163_u + 0.5, entityplayer.field_70161_v, shootPosition.field_72450_a * velocity, shootPosition.field_72448_b * velocity, shootPosition.field_72449_c * velocity, new int[]{1});
                }
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.COMMON;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 40000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 128.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

