/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.ImmutableSet;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import java.util.Set;
import jp.nechiru.advancedelectrictools.Item.tool.electric.AdvancedMiningDrill;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNanoDrill
extends AdvancedMiningDrill
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemNanoDrill";
    public static final String NAME = "Nano Drill";
    public static final int TIER = 2;
    public static final float DAMAGE = 4.0f;
    public static final int STORAGE = 40000;
    public static final int ENERGY_TRFR_Lim = 128;
    static final int[] CHARGE = new int[]{80, 100};
    static final String[] ModeName = new String[]{"Normal", "LowPower", "3x3Hole", "TunnelHole"};

    public ItemNanoDrill() {
        this.field_77865_bY = 4.0f;
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Switch Between Modes");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Selected Mode");
            tooltip.add("");
            tooltip.add("Item Click on Block Actions");
            tooltip.add("Make a Grass Path");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("Drill Mode : " + ModeName[mode]);
        tooltip.add("");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("ModeSwitch", player)) {
            ++mode;
            stack.func_77978_p().func_74768_a("Mode", mode %= 4);
            IC2Access.messagePlayer(player, TextFormatting.GREEN, "NanoDrill : " + ModeName[mode] + "Mode Enabled");
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", player)) {
            IC2Access.messagePlayer(player, TextFormatting.GOLD, "NanoDrill Mode: " + ModeName[mode]);
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        World worldIn = player.field_70170_p;
        if (!player.func_70093_af()) {
            if (mode == 2) {
                for (BlockPos additionalPos : this.get3X3TargetBlocks(worldIn, pos, player)) {
                    this.breakBlock(additionalPos, worldIn, player, stack);
                }
            } else if (mode == 3) {
                this.breakBlock(this.get1x2TargetBlock(worldIn, pos, player), worldIn, player, stack);
            }
        }
        return false;
    }

    public void breakBlock(BlockPos pos, World world, EntityPlayer player, ItemStack stack) {
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            return;
        }
        if (!world.field_72995_K) {
            IBlockState blockState = world.func_180495_p(pos);
            ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), (EntityLivingBase)player);
            blockState.func_177230_c().func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), stack);
            world.func_175698_g(pos);
            world.func_175713_t(pos);
        }
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Items.field_151046_w.func_150897_b(state) || Items.field_151047_v.func_150897_b(state);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        return 3;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack) || state.func_177230_c() != Blocks.field_150349_c || IC2Access.instance.isKeyDown("ModeSwitch", player)) {
            return EnumActionResult.FAIL;
        }
        if (state.func_177230_c() == Blocks.field_150349_c) {
            world.func_175656_a(pos, Blocks.field_185774_da.func_176223_P());
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (ElectricItem.manager.canUse(stack, (double)CHARGE[1])) {
                ElectricItem.manager.use(stack, (double)CHARGE[1], (EntityLivingBase)player);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public int getEnergyCost(ItemStack stack) {
        return CHARGE[0];
    }

    public float getMiningSpeed(ItemStack stack) {
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (!ItemStackHelper.getOrCreateCompound(stack).func_74764_b("Mode")) {
            return 40.0f;
        }
        if (mode == 0) {
            return 40.0f;
        }
        if (mode == 1) {
            return 12.0f;
        }
        return 24.0f;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), entityLiving);
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            return 1.0f;
        }
        if (IC2Access.isToolEffective(state, stack)) {
            return this.getMiningSpeed(stack);
        }
        if (this.canHarvestBlock(state, stack)) {
            return this.getMiningSpeed(stack);
        }
        return super.func_150893_a(stack, state);
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 40000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 128.0;
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.DIGGER;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

