/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.Util.ParticleHelper;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import jp.nechiru.advancedelectrictools.entities.EntityIYExtendedReach;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHeatLance
extends ItemSword
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemHeatLance";
    public static final String NAME = "Heat Lance";
    public static final int TIER = 2;
    public static final float[] DAMAGE = new float[]{12.0f, 36.0f};
    public static final int STORAGE = 40000;
    public static final float ENERGY_USE = 50.0f;
    public static final int ENERGY_TRFR_Lim = 128;

    public ItemHeatLance() {
        super(Item.ToolMaterial.DIAMOND);
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "heatlance_active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ItemHeatLance.ChangeModel(stack, entity);
            }
        });
    }

    public static int ChangeModel(ItemStack stack, @Nullable EntityLivingBase entity) {
        int texture = 0;
        texture = entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? (ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode") ? 3 : 2) : (ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode") ? 1 : 0);
        return texture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Toggle the Heating");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Heating Mode");
            tooltip.add("");
            tooltip.add("Item Click on Block Actions");
            tooltip.add("Melt the block when heated");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("Heating : " + (mode ? "Enabled" : "Disabled"));
        tooltip.add("");
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        double f3 = (double)DAMAGE[mode ? 1 : 0] * 1.5;
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack);
        if (j == 1) {
            f3 *= 1.5;
        } else if (j > 1) {
            f3 *= (double)j;
        }
        if (mode) {
            target.func_70015_d(600);
        }
        for (EntityLivingBase entitylivingbase : player.field_70170_p.func_72872_a(EntityLivingBase.class, target.func_174813_aQ().func_72321_a(1.0, 0.25, 1.0))) {
            if (entitylivingbase == player || entitylivingbase == target) continue;
            entitylivingbase.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
            entitylivingbase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), (float)f3);
        }
        this.spawnSweepParticles((Entity)player);
        if (mode && ElectricItem.manager.canUse(stack, 50.0)) {
            ElectricItem.manager.use(stack, 50.0, player);
        }
        return false;
    }

    public void spawnSweepParticles(Entity entity) {
        double d0 = -MathHelper.func_76126_a((float)(entity.field_70177_z * ((float)Math.PI / 180)));
        double d1 = MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180)));
        if (entity.field_70170_p instanceof WorldServer) {
            ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, entity.field_70165_t + d0, entity.field_70163_u + (double)entity.field_70131_O * 0.5, entity.field_70161_v + d1, 0, d0, 0.0, d1, 0.0, new int[0]);
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entityLiving;
        EntityIYExtendedReach entityextendedreach = new EntityIYExtendedReach(worldIn, entityLiving);
        entityextendedreach.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, 4.0f, 0.5f);
        int i = this.func_77626_a(stack) - timeLeft;
        i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (boolean)true);
        if (i < 0) {
            return;
        }
        float f = ItemHeatLance.getArrowVelocity(i);
        if ((double)f < 1.0) {
            return;
        }
        if (!worldIn.field_72995_K && (double)f >= 1.0) {
            int l;
            int k;
            if (f == 2.0f) {
                entityextendedreach.func_70239_b(entityextendedreach.func_70242_d() + 2.0);
            }
            if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack)) > 0) {
                entityextendedreach.func_70239_b(entityextendedreach.func_70242_d() + (double)k * 0.5 + 0.5);
            }
            if ((l = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack)) > 0) {
                entityextendedreach.func_70240_a(l);
            }
            if (mode) {
                entityextendedreach.func_70015_d(100);
            }
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, Sounds.extendReachSpear, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            worldIn.func_72838_d((Entity)entityextendedreach);
            if (mode && ElectricItem.manager.canUse(stack, 50.0)) {
                ElectricItem.manager.use(stack, 50.0, (EntityLivingBase)entityplayer);
            }
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.5f) {
            f = 1.5f;
        }
        return f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        boolean flag = true;
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("ModeSwitch", playerIn)) {
            if (mode) {
                stack.func_77978_p().func_74757_a("Mode", false);
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "HeatLance : Heating Disable");
            } else {
                stack.func_77978_p().func_74757_a("Mode", true);
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "HeatLance : Heating Enable");
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!IC2Access.instance.isKeyDown("ModeSwitch", playerIn) && !IC2Access.instance.isKeyDown("Alt", playerIn)) {
            ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)flag);
            playerIn.func_184598_c(handIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack);
        if (i > 0) {
            enchantments.remove(Enchantments.field_77334_n, i);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
        }
        if (!(entity instanceof EntityPlayer) || !mode) {
            return;
        }
        if (!ElectricItem.manager.canUse(stack, 50.0)) {
            stack.func_77978_p().func_74757_a("Mode", false);
        }
    }

    public boolean canFurnaceable(BlockPos pos, IBlockState state, World world) {
        ItemStack drop_b = state.func_177230_c().func_185473_a(world, pos, state);
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(drop_b);
        return !result.func_190926_b();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack) || !mode || IC2Access.instance.isKeyDown("ModeSwitch", player)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        if (ElectricItem.manager.canUse(stack, 50.0)) {
            if (material == Material.field_151588_w || material == Material.field_151598_x) {
                world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
                world.func_184133_a(player, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ElectricItem.manager.use(stack, 100.0, (EntityLivingBase)player);
            } else if (material == Material.field_151584_j) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.8f, 1.0f);
                ParticleHelper.spawnParticles(world, pos, EnumParticleTypes.SMOKE_LARGE, 10, 0.02, new int[0]);
                ElectricItem.manager.use(stack, 100.0, (EntityLivingBase)player);
            } else if (state.func_177230_c() == Blocks.field_150343_Z || state.func_177230_c() == Blocks.field_150389_bf || state.func_177230_c() == Blocks.field_150390_bg || state.func_177230_c() == Blocks.field_150446_ar || state.func_177230_c() == Blocks.field_150417_aV || state.func_177230_c() == Blocks.field_150348_b) {
                world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
                world.func_184133_a(player, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ElectricItem.manager.use(stack, 100.0, (EntityLivingBase)player);
            } else if (this.canFurnaceable(pos, state, world)) {
                ItemHeatLance.onDrops(pos, state, player.field_70170_p);
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    public static void onDrops(BlockPos pos, IBlockState state, World world) {
        ItemStack drop_b = state.func_177230_c().func_185473_a(world, pos, state);
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(drop_b);
        if (!result.func_190926_b()) {
            int combinedCount = drop_b.func_190916_E() * result.func_190916_E();
            ItemStack fur_drop = new ItemStack(result.func_77973_b(), combinedCount, result.func_77952_i());
            int i = combinedCount;
            float f = FurnaceRecipes.func_77602_a().func_151398_b(result);
            if (f == 0.0f) {
                i = 0;
            } else if (f < 1.0f) {
                int j = MathHelper.func_76141_d((float)((float)i * f));
                if (j < MathHelper.func_76123_f((float)((float)i * f)) && Math.random() < (double)((float)i * f - (float)j)) {
                    ++j;
                }
                i = j;
            }
            if (!world.field_72995_K) {
                for (int n = 0; n < i + 1; ++n) {
                    EntityItem entity = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), fur_drop.func_77946_l());
                    world.func_72838_d((Entity)entity);
                }
                while (i > 0) {
                    int k = EntityXPOrb.func_70527_a((int)i);
                    i -= k;
                    world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), k));
                }
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            ParticleHelper.spawnParticles(world, pos, EnumParticleTypes.FLAME, 5, 0.02, new int[0]);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 36000;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            multimap.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)DAMAGE[mode ? 1 : 0], 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.WEAPON;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 40000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 128.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

