/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.Util.ParticleHelper;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEntropyManipulator
extends Item
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemEntropyManipulator";
    public static final String NAME = "Entropy Manipulator";
    public static final int TIER = 3;
    public static final int STORAGE = 1000000;
    public static final int DAMAGE = 15;
    public static final float ENERGY_USE = 250.0f;
    public static final int ENERGY_TRFR_Lim = 2048;

    public ItemEntropyManipulator() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.setNoRepair();
        this.func_77656_e(1000);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "en_mode"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
                return mode ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Toggle the entropy operation mode");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the mode");
            tooltip.add("");
            tooltip.add("Item Click on Block Actions");
            tooltip.add("Manipulate block entropy");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("Mode : " + (mode ? "Cooling" : "Heating"));
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        tooltip.add("");
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (ElectricItem.manager.canUse(stack, 250.0)) {
            if (!mode) {
                target.func_70015_d(600);
            } else {
                PotionEffect potioneffect = new PotionEffect(MobEffects.field_76421_d, 200, 10, false, false);
                target.func_70690_d(potioneffect);
            }
            ElectricItem.manager.use(stack, 500.0, player);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        boolean mode = ItemStackHelper.getOrCreateCompound(itemstack).func_74767_n("Mode");
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        boolean alt = IC2Access.instance.isKeyDown("Alt", playerIn);
        boolean mode_sw = IC2Access.instance.isKeyDown("ModeSwitch", playerIn);
        if (IC2Access.isSimulating() && mode_sw) {
            mode = !mode;
            itemstack.func_77978_p().func_74757_a("Mode", mode);
            IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "EntropyManipulator : " + (mode ? "Cooling" : "Heating") + " Mode Enable");
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
        }
        if (IC2Access.isSimulating() && alt) {
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "EntropyManipulator : " + (mode ? "Cooling" : "Heating") + " Mode");
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
        }
        if (raytraceresult == null || mode_sw || alt) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        IBlockState state = worldIn.func_180495_p(blockpos);
        if (mode) {
            if (state.func_185904_a() == Material.field_151587_i && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                worldIn.func_180501_a(blockpos, Blocks.field_150343_Z.func_176223_P(), 11);
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                ParticleHelper.spawnParticles(worldIn, blockpos, EnumParticleTypes.SMOKE_LARGE, 10, 0.02, new int[0]);
                worldIn.func_184133_a(playerIn, blockpos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                worldIn.func_180501_a(blockpos, Blocks.field_150432_aD.func_176223_P(), 11);
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                worldIn.func_184133_a(playerIn, blockpos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            }
        } else if (state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 11);
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            ParticleHelper.spawnParticles(worldIn, blockpos, EnumParticleTypes.CLOUD, 10, 0.02, new int[0]);
            worldIn.func_184133_a(playerIn, blockpos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack) || this.findFluid(player, world) || IC2Access.instance.isKeyDown("ModeSwitch", player) || IC2Access.instance.isKeyDown("Alt", player)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        if (ElectricItem.manager.canUse(stack, 250.0)) {
            if (mode) {
                state = world.func_180495_p(pos = pos.func_177972_a(facing));
                if (state.func_185904_a() == Material.field_151581_o) {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                    ParticleHelper.spawnParticles(world, pos, EnumParticleTypes.SMOKE_LARGE, 10, 0.02, new int[0]);
                    world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else if (state.func_185904_a() == Material.field_151587_i && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                    world.func_180501_a(pos, Blocks.field_150347_e.func_176223_P(), 11);
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                    ParticleHelper.spawnParticles(world, pos, EnumParticleTypes.SMOKE_LARGE, 10, 0.02, new int[0]);
                    world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else if (this.canFurnaceable(pos, state, world)) {
                ItemEntropyManipulator.onDrops(pos, state, player.field_70170_p);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            } else if (material == Material.field_151588_w || material == Material.field_151598_x || material == Material.field_151596_z) {
                world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
                ParticleHelper.spawnParticles(world, pos, EnumParticleTypes.CLOUD, 10, 0.02, new int[0]);
                world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ElectricItem.manager.use(stack, 250.0, (EntityLivingBase)player);
            } else if (material == Material.field_151597_y) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                ParticleHelper.spawnParticles(world, pos, EnumParticleTypes.CLOUD, 10, 0.02, new int[0]);
                world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ElectricItem.manager.use(stack, 250.0, (EntityLivingBase)player);
            } else if (state.func_177230_c() == Blocks.field_150343_Z) {
                world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
                world.func_184133_a(player, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ElectricItem.manager.use(stack, 250.0, (EntityLivingBase)player);
            } else {
                pos = pos.func_177972_a(facing);
                state = world.func_180495_p(pos);
                if (world.func_175623_d(pos)) {
                    world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
                    ElectricItem.manager.use(stack, 250.0, (EntityLivingBase)player);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                    }
                } else if (state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                    ParticleHelper.spawnParticles(world, pos, EnumParticleTypes.CLOUD, 10, 0.02, new int[0]);
                    world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean findFluid(EntityPlayer player, World world) {
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        BlockPos blockpos = raytraceresult.func_178782_a();
        IBlockState state = world.func_180495_p(blockpos);
        Material material = state.func_185904_a();
        return material == Material.field_151587_i || material == Material.field_151586_h;
    }

    public boolean canFurnaceable(BlockPos pos, IBlockState state, World world) {
        ItemStack drop_b = state.func_177230_c().func_185473_a(world, pos, state);
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(drop_b);
        return !result.func_190926_b();
    }

    public static void onDrops(BlockPos pos, IBlockState state, World world) {
        ItemStack drop_b = state.func_177230_c().func_185473_a(world, pos, state);
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(drop_b);
        if (!result.func_190926_b()) {
            int combinedCount = drop_b.func_190916_E() * result.func_190916_E();
            ItemStack fur_drop = new ItemStack(result.func_77973_b(), 1, result.func_77952_i());
            int i = combinedCount;
            float f = FurnaceRecipes.func_77602_a().func_151398_b(result);
            if (f == 0.0f) {
                i = 0;
            } else if (f < 1.0f) {
                int j = MathHelper.func_76141_d((float)((float)i * f));
                if (j < MathHelper.func_76123_f((float)((float)i * f)) && Math.random() < (double)((float)i * f - (float)j)) {
                    ++j;
                }
                i = j;
            }
            if (!world.field_72995_K) {
                for (int n = 0; n < i + 1; ++n) {
                    EntityItem entity = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), fur_drop.func_77946_l());
                    world.func_72838_d((Entity)entity);
                }
                while (i > 0) {
                    int k = EntityXPOrb.func_70527_a((int)i);
                    i -= k;
                    world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), k));
                }
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            ParticleHelper.spawnParticles(world, pos, EnumParticleTypes.FLAME, 5, 0.02, new int[0]);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        boolean energy = ElectricItem.manager.canUse(stack, 500.0);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            multimap.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", energy ? 15.0 : 0.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1000000.0;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 2048.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

