/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import jp.nechiru.advancedelectrictools.entities.EntityRocket;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricRocketLauncher
extends Item
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemElectricRocketLauncher";
    public static final String NAME = "Electric Rocket Launcher";
    public static final int TIER = 2;
    public static final float[] POWER = new float[]{10.0f, 8.0f};
    public static final int STORAGE = 1000000;
    public static final float[] ENERGY_USE = new float[]{2500.0f, 5000.0f};
    public static final int ENERGY_TRFR_Lim = 512;
    static final String[] ModeName = new String[]{"Normal", "Penetration"};

    public ItemElectricRocketLauncher() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        int mode = ItemStackHelper.getOrCreateNbtData(stack).func_74762_e("Mode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Switch Between Modes");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Selected Mode");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("Mode : " + ModeName[mode]);
        tooltip.add("");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (!worldIn.field_72995_K && IC2Access.isSimulating() && IC2Access.instance.isKeyDown("ModeSwitch", playerIn)) {
            ++mode;
            stack.func_77978_p().func_74768_a("Mode", mode %= 2);
            IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "Electric Rocket Launcher : " + ModeName[mode] + "Mode Enabled");
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", playerIn)) {
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "Electric Rocket Launcher Mode : " + ModeName[mode]);
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        if (!IC2Access.instance.isKeyDown("Alt", playerIn) && !IC2Access.instance.isKeyDown("ModeSwitch", playerIn) && ElectricItem.manager.canUse(stack, (double)ENERGY_USE[mode])) {
            EntityRocket entity = new EntityRocket(worldIn, playerIn, POWER[mode], mode > 0 ? 10 : -1);
            entity.shoot(playerIn, playerIn.field_70177_z, playerIn.field_70125_A, 6.0f);
            worldIn.func_72838_d((Entity)entity);
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.rocketFire, playerIn.func_184176_by(), 0.8f, 1.0f);
            ElectricItem.manager.use(stack, (double)ENERGY_USE[mode], (EntityLivingBase)playerIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1000000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 512.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

