/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricMagnet
extends Item
implements IElectricItem {
    public static final int TIER = 1;
    public static final int STORAGE = 10000;
    public static final double ENERGY_USE = 5.0;
    public static final int ENERGY_TRFR_Lim = 100;
    public static final double RANGE = 32.0;

    public ItemElectricMagnet() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.setNoRepair();
        this.func_77656_e(100);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Toggle the Magnet");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add(mode ? "Magnet : Enabled" : "Magnet : Disabled");
        tooltip.add("");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos fluidPos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(fluidPos);
        if (state.func_177230_c() instanceof BlockFluidBase || state.func_177230_c() instanceof BlockLiquid) {
            if (IC2Access.isSimulating()) {
                world.func_175698_g(fluidPos);
                Fluid f = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
                if (f != null) {
                    world.func_184133_a(null, pos, f.getFillSound(world, fluidPos), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        if (!world.field_72995_K) {
            mode = !mode;
            stack.func_77978_p().func_74757_a("Mode", mode);
            IC2Access.messagePlayer(player, TextFormatting.WHITE, mode ? "ElectricMagnet : Enabled" : "ElectricMagnet : Disabled");
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof EntityPlayer) || !ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode")) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        AxisAlignedBB bBox = player.func_174813_aQ().func_186662_g(32.0);
        List itemList = world.func_72872_a(EntityItem.class, bBox);
        List xpList = world.func_72872_a(EntityXPOrb.class, bBox);
        if (ElectricItem.manager.canUse(stack, 5.0)) {
            for (EntityItem item : itemList) {
                if (!ItemStackHelper.hasSpace((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, item.func_92059_d())) continue;
                item.func_70100_b_(player);
                ElectricItem.manager.use(stack, 5.0, (EntityLivingBase)player);
            }
            for (EntityXPOrb xp : xpList) {
                xp.func_70100_b_(player);
                ElectricItem.manager.use(stack, 5.0, (EntityLivingBase)player);
            }
        }
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 10000.0;
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 100.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

