/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricForceFieldGenerator
extends Item
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemElectricForceFieldGenerator";
    public static final String NAME = "Electric Force Field Generator";
    public static final int TIER = 2;
    public static final int STORAGE = 40000;
    public static final int ENERGY_USE = 100;
    public static final int ENERGY_TRFR_Lim = 128;

    public ItemElectricForceFieldGenerator() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "storage_energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)(ElectricItem.manager.getCharge(stack) / 40000.0);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        boolean autoSupplement = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("AutoSupplement");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Toggle the Force Field");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Mode");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add(autoSupplement ? "Force Field : Enabled" : "Force Field : Disable");
        tooltip.add("");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityIn;
        boolean autoSupplement = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("AutoSupplement");
        float currentAbsAmount = player.func_110139_bj();
        if (!worldIn.field_72995_K && autoSupplement && currentAbsAmount < 10.0f && ElectricItem.manager.use(stack, 100.0, (EntityLivingBase)player)) {
            player.func_110149_m(currentAbsAmount + 0.5f);
        }
        if (!ElectricItem.manager.canUse(stack, 100.0)) {
            stack.func_77978_p().func_74757_a("AutoSupplement", false);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        boolean autoSupplement = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("AutoSupplement");
        if (IC2Access.isSimulating() && !IC2Access.instance.isKeyDown("Alt", playerIn) && ElectricItem.manager.canUse(stack, 100.0)) {
            autoSupplement = !autoSupplement;
            IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "Force Field : " + (autoSupplement ? "Enabled" : "Disabled"));
            stack.func_77978_p().func_74757_a("AutoSupplement", autoSupplement);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", playerIn)) {
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, autoSupplement ? "ElectricFirstAidLifeSupport : Enabled" : "ElectricFirstAidLifeSupport : Disable");
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 40000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 128.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

