/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricFishingRod
extends ItemFishingRod
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemElectricFishingRod";
    public static final String NAME = "Electric Fishing Rod";
    public static final int TIER = 1;
    public static final int STORAGE = 10000;
    public static final int ENERGY_USE = 50;
    public static final int ENERGY_TRFR_Lim = 100;

    public ItemElectricFishingRod() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("cast"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                boolean flag1;
                if (entityIn == null) {
                    return 0.0f;
                }
                boolean flag = entityIn.func_184614_ca() == stack;
                boolean bl = flag1 = entityIn.func_184592_cb() == stack;
                if (entityIn.func_184614_ca().func_77973_b() instanceof ItemFishingRod) {
                    flag1 = false;
                }
                return (flag || flag1) && entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).field_71104_cf != null ? 1.0f : 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!ElectricItem.manager.canUse(itemstack, 50.0)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (playerIn.field_71104_cf != null) {
            int i = playerIn.field_71104_cf.func_146034_e();
            ElectricItem.manager.use(itemstack, 50.0, (EntityLivingBase)playerIn);
            playerIn.func_184609_a(handIn);
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        } else {
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!worldIn.field_72995_K) {
                int k;
                EntityFishHook entityfishhook = new EntityFishHook(worldIn, playerIn);
                int j = EnchantmentHelper.func_191528_c((ItemStack)itemstack) + 2;
                if (j > 0) {
                    entityfishhook.func_191516_a(j);
                }
                if ((k = EnchantmentHelper.func_191529_b((ItemStack)itemstack) + 2) > 0) {
                    entityfishhook.func_191517_b(k);
                }
                worldIn.func_72838_d((Entity)entityfishhook);
            }
            playerIn.func_184609_a(handIn);
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.FISHING_ROD;
    }

    public int func_77619_b() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.COMMON;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 10000.0;
    }

    public int getTier(ItemStack stack) {
        return 1;
    }

    public double getTransferLimit(ItemStack stack) {
        return 100.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

