/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEchotron
extends Item
implements IElectricItem {
    public static final double RANGE = 100.0;
    public static final int STORAGE = 1000000;
    public static final float ENERGY_USE = 500.0f;
    public static final int ENERGY_TRFR_Lim = 512;
    public static final int TIER = 3;

    public ItemEchotron() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(1000);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "storage_energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)(ElectricItem.manager.getCharge(stack) / 1000000.0);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        boolean toggle = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Toggle");
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        int range = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Range");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Switch Scanning Targets");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(1) + ") to: Switch Scanning Range");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Selected Mode");
            tooltip.add("Toggle the Scanning");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add(toggle ? "Scanning : Enabled" : "Scanning : Disabled");
        tooltip.add(mode > 0 ? "Target : ElectricTool" : "Scanning : Mob");
        tooltip.add("ScanningRange : " + this.getRange(range + 1));
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        tooltip.add("");
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        boolean toggle = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Toggle");
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        int range = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Range");
        if (IC2Access.isSimulating() && !IC2Access.instance.isKeyDown("Alt", playerIn)) {
            if (IC2Access.instance.isKeyDown("ModeSwitch", playerIn)) {
                ++mode;
                stack.func_77978_p().func_74768_a("Mode", mode %= 2);
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, mode > 0 ? "Echotron ScanningTarget: ElectricTool" : "Echotron ScanningTarget: Mob");
            } else if (IC2Access.instance.isKeyDown("Boost", playerIn)) {
                ++range;
                stack.func_77978_p().func_74768_a("Range", range %= 3);
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "Echotron ScanningRange: " + this.getRange(range + 1));
            } else if (ElectricItem.manager.canUse(stack, 500.0)) {
                toggle = !toggle;
                stack.func_77978_p().func_74757_a("Toggle", toggle);
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, toggle ? "Echotron Scanning: Enabled" : "Echotron Scanning: Disabled");
                if (toggle) {
                    worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.Soner, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    if (mode > 0) {
                        this.searchTool(stack, (Entity)playerIn);
                    } else {
                        this.searchMob(stack, (Entity)playerIn, 100);
                    }
                }
            } else {
                IC2Access.messagePlayer(playerIn, TextFormatting.RED, "Echotron : Low Battery");
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", playerIn)) {
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, toggle ? "Echotron Scanning: Enabled" : "Echotron Scanning: Disabled");
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, mode > 0 ? "Echotron ScanningTarget: ElectricTool" : "Echotron ScanningTarget: Mob");
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "Echotron ScanningRange: " + this.getRange(range + 1));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean toggle = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Toggle");
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (!(entityIn instanceof EntityPlayer) || !toggle) {
            return;
        }
        if (worldIn.func_72820_D() % 200L == 0L && ElectricItem.manager.canUse(stack, 500.0)) {
            entityIn.func_184185_a(Sounds.Soner, 1.0f, 1.0f);
            if (mode > 0) {
                this.searchTool(stack, entityIn);
            } else {
                this.searchMob(stack, entityIn, 100);
            }
            ElectricItem.manager.use(stack, 500.0, (EntityLivingBase)entityIn);
            if (!ElectricItem.manager.canUse(stack, 500.0)) {
                stack.func_77978_p().func_74757_a("Toggle", false);
                IC2Access.messagePlayer((EntityPlayer)entityIn, TextFormatting.RED, "Echotron : Low Battery");
            }
        }
    }

    public void searchMob(ItemStack stack, Entity entityIn, int growing) {
        int range = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Range");
        AxisAlignedBB area = new AxisAlignedBB(entityIn.func_180425_c()).func_186662_g(this.getRange(range + 1));
        List list = entityIn.field_70170_p.func_175674_a(entityIn, area, null);
        if (!list.isEmpty()) {
            for (Entity thing : list) {
                if (thing instanceof EntityLiving) {
                    ((EntityLivingBase)thing).func_70690_d(new PotionEffect(MobEffects.field_188423_x, growing, 0, false, false));
                }
                if (!(thing instanceof EntityPlayer)) continue;
                ((EntityPlayer)thing).func_70690_d(new PotionEffect(MobEffects.field_188423_x, growing, 0, false, false));
            }
        }
    }

    public void searchTool(ItemStack stack, Entity entityIn) {
        int range = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Range");
        AxisAlignedBB area = new AxisAlignedBB(entityIn.func_180425_c()).func_186662_g(this.getRange(range + 1));
        List list = entityIn.field_70170_p.func_72872_a(EntityItem.class, area);
        if (!list.isEmpty()) {
            for (EntityItem item : list) {
                NBTTagCompound tag = item.func_92059_d().func_77978_p();
                if (tag == null || !tag.func_74764_b("charge")) continue;
                item.func_184195_f(true);
            }
        }
    }

    public double getRange(int num) {
        return 50 * num;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1000000.0;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 512.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

