/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.AETS_Config;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.Util.ParticleHelper;
import jp.nechiru.advancedelectrictools.Util.PlayerEvent;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import jp.nechiru.advancedelectrictools.api.mekanism.OreDictCache;
import jp.nechiru.advancedelectrictools.api.mekanism.util.Coord4D;
import jp.nechiru.advancedelectrictools.entities.EntityTechArrow;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemAgito_Mk2
extends ItemSword
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemAgitoMk2";
    public static final String NAME = "AgitoMk2";
    public static final int TIER = 3;
    public static final float[] DAMAGE = new float[]{69.0f, 800.0f, 39.0f};
    public static final int STORAGE = 5000000;
    public static final int[] ENERGY_USE = new int[]{250, 2000, 500};
    public static final int ENERGY_TRFR_Lim = 512;
    private static int RANGE = 10000;
    static final float PenetrationCo = 1.0f;
    public static float[] MINING_SPEED = new float[]{2.0f, 2.0f, 2.1474836E9f, 16384.0f};
    private static boolean TARGET_IGNORE_WALLS = true;
    static final String[] ModeName = new String[]{"Quantum Blade", "RailGun", "Atomic Disassembler"};

    public ItemAgito_Mk2() {
        super(Item.ToolMaterial.DIAMOND);
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "agito_mode"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                boolean hand = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("hand");
                if (entity != null && (entity.func_184614_ca() == stack || entity.func_184592_cb() == stack)) {
                    stack.func_77978_p().func_74757_a("hand", true);
                }
                if (hand) {
                    if (ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode") == 1) {
                        return 3.0f;
                    }
                    if (ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode") == 2) {
                        return 4.0f;
                    }
                    return ElectricItem.manager.canUse(stack, (double)ENERGY_USE[0]) && entity != null && entity.func_184614_ca() == stack ? 2.0f : 1.0f;
                }
                return 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        int mode = ItemStackHelper.getOrCreateNbtData(stack).func_74762_e("Mode");
        boolean silktouch = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("SilkTouch");
        boolean vein = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Vein");
        int l = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack);
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Switch Between Modes");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Selected Mode");
            if (mode == 1) {
                tooltip.add("Shoot a Railgun");
            } else if (mode == 2) {
                tooltip.add("Press (" + IC2Access.instance.getKeyName(1) + " & " + IC2Access.instance.getKeyName(0) + ") to: Switch Mining Mode");
                tooltip.add("Press (" + IC2Access.instance.getKeyName(1) + ") to: Toggle the SilkTouch");
                tooltip.add("");
                tooltip.add("Item Click on Block Actions");
                tooltip.add("Collect blocks");
            }
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("Mode : " + ModeName[mode]);
        if (mode == 2) {
            tooltip.add("MiningMode : " + (vein ? "Vein" : "Single"));
            tooltip.add("SilkTouch : " + (silktouch ? "Enabled" : "Disabled"));
            tooltip.add(TextFormatting.GOLD + "Armor penetration");
        }
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        if (mode == 1 && l >= 3) {
            tooltip.add(TextFormatting.GOLD + "Blast protection");
        }
        tooltip.add("");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean hand = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("hand");
        if (itemSlot >= 8 || isSelected || !(entityIn instanceof EntityPlayer)) {
            stack.func_77978_p().func_74757_a("hand", false);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        EntityPlayer entityLiving = playerIn;
        EntityPlayer playerentity = null;
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        boolean silktouch = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("SilkTouch");
        boolean vein = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Vein");
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        boolean keyMode = IC2Access.instance.isKeyDown("ModeSwitch", playerIn);
        boolean keyBoost = IC2Access.instance.isKeyDown("Boost", playerIn);
        boolean keyAlt = IC2Access.instance.isKeyDown("Alt", playerIn);
        if (IC2Access.isSimulating()) {
            if (keyMode) {
                ++mode;
                stack.func_77978_p().func_74768_a("Mode", mode %= 3);
                if (silktouch) {
                    if (mode == 2) {
                        enchantments.remove(Enchantments.field_185308_t, 10);
                        enchantments.put(Enchantments.field_185306_r, 1);
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                    } else {
                        enchantments.remove(Enchantments.field_185306_r, 1);
                        enchantments.remove(Enchantments.field_185308_t, 10);
                        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                    }
                } else if (mode == 2) {
                    enchantments.remove(Enchantments.field_185306_r, 1);
                    enchantments.put(Enchantments.field_185308_t, 10);
                    EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                } else {
                    enchantments.remove(Enchantments.field_185306_r, 1);
                    enchantments.remove(Enchantments.field_185308_t, 10);
                    EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                }
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "AGITO Mk.2 : " + ModeName[mode] + " Enabled");
                worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.agitoModeChange, SoundCategory.NEUTRAL, 0.5f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            if (mode == 2 && !keyAlt && keyBoost) {
                if (silktouch) {
                    enchantments.remove(Enchantments.field_185306_r, 1);
                    enchantments.put(Enchantments.field_185308_t, 5);
                    EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                    stack.func_77978_p().func_74757_a("SilkTouch", false);
                    IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "AGITO Mk.2 : SilkTouch Disabled");
                } else {
                    enchantments.remove(Enchantments.field_185308_t, 5);
                    enchantments.put(Enchantments.field_185306_r, 1);
                    EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                    stack.func_77978_p().func_74757_a("SilkTouch", true);
                    IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "AGITO Mk.2 : SilkTouch Enabled");
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            if (mode == 2 && keyAlt && keyBoost) {
                if (vein) {
                    stack.func_77978_p().func_74757_a("Vein", false);
                    IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "AGITO Mk.2 : Single Mining Mode Enabled");
                } else {
                    stack.func_77978_p().func_74757_a("Vein", true);
                    IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, "AGITO Mk.2 : Vein Mining Mode Enabled");
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        if (IC2Access.isSimulating() && !keyAlt && !keyMode) {
            if (mode == 1) {
                if (ElectricItem.manager.use(stack, (double)ENERGY_USE[1], (EntityLivingBase)playerIn)) {
                    worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.railgunFire, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                    worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.railgunReload, SoundCategory.NEUTRAL, 0.8f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                    Entity currTarget = this.getValidTarget(worldIn, (EntityLivingBase)entityLiving);
                    if (currTarget != null) {
                        this.shootEntity(worldIn, playerIn, currTarget, (EntityLivingBase)entityLiving, stack);
                    } else {
                        int l = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack);
                        RayTraceResult resultBlock = IC2Access.rayTrace(worldIn, (EntityLivingBase)playerIn, false, RANGE);
                        BlockPos pos = resultBlock.func_178782_a();
                        if (l >= 3) {
                            playerentity = playerIn;
                        }
                        worldIn.func_72885_a((Entity)playerentity, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 9.0f + (float)Math.max(l, 0), false, false);
                    }
                } else {
                    worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.agito_RailGun_Low, SoundCategory.NEUTRAL, 0.8f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2Access.isSimulating() && keyAlt) {
            if (mode == 2) {
                IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "AGITO Mk.2 Mode : " + ModeName[mode] + " Enabled");
                IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "  Mining Mode : " + (vein ? "Vein" : "Single"));
                IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "  SilkTouch : " + (silktouch ? "Enabled" : "Disabled"));
            } else {
                IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "AGITO Mk.2 Mode : " + ModeName[mode] + " Enabled");
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase mob, EntityLivingBase player) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
        int l = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack);
        float damage = DAMAGE[2] + 1.0f + 0.5f * (float)j + 0.5f;
        float setdamage = damage + 1.0f + damage * (float)(l / (l + 1));
        if (mode == 0 && ElectricItem.manager.canUse(stack, (double)ENERGY_USE[0])) {
            ElectricItem.manager.use(stack, (double)ENERGY_USE[0], player);
            if (mob instanceof EntityPlayer) {
                PlayerEvent.DisabledShield((EntityPlayer)mob);
            }
            mob.field_70172_ad = 0;
            mob.field_70737_aN = 0;
            mob.field_70738_aO = 0;
            this.PenetrationDamage(mob, player, setdamage, 0.15f);
        } else if (mode == 2) {
            ElectricItem.manager.use(stack, (double)(ENERGY_USE[2] * 2), player);
            mob.field_70172_ad = 0;
            mob.field_70737_aN = 0;
            mob.field_70738_aO = 0;
            if (mob instanceof EntityPlayer) {
                PlayerEvent.damageShield((EntityPlayer)mob);
            }
            this.PenetrationDamage(mob, player, setdamage, 1.0f);
        }
        return true;
    }

    private void PenetrationDamage(EntityLivingBase mob, EntityLivingBase player, float damage, float n) {
        if (field_77697_d.nextFloat() >= 1.0f - n) {
            mob.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), damage);
        }
    }

    private void shootEntity(World world, EntityPlayer playerIn, Entity target, EntityLivingBase shooter, ItemStack stack) {
        if (IC2Access.isSimulating()) {
            float damage = 0.0f;
            Object playerentity = null;
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
            if (j > 0) {
                damage = DAMAGE[1] * 0.25f * (float)(j + 1);
            }
            int l = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack);
            int f = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack);
            if (f > 0) {
                target.func_70015_d(100);
            }
            EntityLivingBase targetLiving = (EntityLivingBase)target;
            targetLiving.field_70172_ad = 0;
            targetLiving.field_70737_aN = 0;
            targetLiving.field_70738_aO = 0;
            if (target instanceof EntityEnderman || target instanceof EntityWither) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)shooter)), DAMAGE[1] + damage);
            } else {
                EntityTechArrow arrow = new EntityTechArrow(world, playerIn);
                target.func_70097_a(DamageSource.func_76353_a((EntityArrow)arrow, (Entity)playerIn), DAMAGE[1] + damage);
                if (!(target instanceof EntityPlayer)) {
                    target.func_70097_a(DamageSource.func_76354_b((Entity)arrow, (Entity)playerIn), (DAMAGE[1] + damage) * 1.0f);
                }
                arrow.func_70106_y();
            }
            PotionEffect potioneffect = new PotionEffect(MobEffects.field_76421_d, 200, 3, false, false);
            ((EntityLivingBase)target).func_70690_d(potioneffect);
            potioneffect = new PotionEffect(MobEffects.field_76440_q, 200, 3, false, false);
            ((EntityLivingBase)target).func_70690_d(potioneffect);
            int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack);
            double vx = -Math.sin(shooter.field_70177_z * ((float)Math.PI / 180)) * (double)0.6f;
            double vz = Math.cos(shooter.field_70177_z * ((float)Math.PI / 180)) * (double)0.6f;
            target.func_70024_g(vx * (double)(k * 5 + 10), 0.1, vz * (double)(k * 5 + 10));
            ParticleHelper.spawnParticles2(target, EnumParticleTypes.EXPLOSION_LARGE, 1.2f, 10 + (int)((float)Math.max(j, 0) / 3.0f) * 5, 0.25, new int[0]);
            world.func_184148_a((EntityPlayer)null, target.field_70165_t, target.field_70163_u, target.field_70161_v, SoundEvents.field_187539_bB, playerIn.func_184176_by(), 1.2f, 0.7f);
        }
    }

    private Entity getValidTarget(World world, EntityLivingBase source) {
        RayTraceResult result;
        if (IC2Access.isSimulating() && (result = IC2Access.rayTraceEntities(world, source, RANGE)) != null && result.field_72313_a == RayTraceResult.Type.ENTITY && (result.field_72308_g instanceof EntityLivingBase || result.field_72308_g instanceof MultiPartEntityPart || result.field_72308_g instanceof EntityEnderCrystal)) {
            RayTraceResult resultBlock;
            if (!TARGET_IGNORE_WALLS && (resultBlock = IC2Access.rayTrace(world, source, false, result.field_72308_g.func_70032_d((Entity)source))) != null && resultBlock.field_72313_a == RayTraceResult.Type.BLOCK) {
                return null;
            }
            return result.field_72308_g;
        }
        return null;
    }

    public double MathPosDistance(EntityPlayer player, Entity target) {
        double dx = target.field_70165_t - player.field_70165_t;
        double dy = target.field_70163_u - player.field_70163_u;
        double dz = target.field_70161_v - player.field_70161_v;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap hashMultimap = HashMultimap.create();
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        boolean canUse = ElectricItem.manager.canUse(stack, (double)ENERGY_USE[0]);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            hashMultimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 4.0, 0));
            if (mode == 1) {
                hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 1.0, 0));
            } else if (mode == 2) {
                hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", canUse ? (double)DAMAGE[2] : 3.0, 0));
            } else {
                hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", canUse ? (double)DAMAGE[0] : 4.0, 0));
            }
        }
        return hashMultimap;
    }

    private boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        float blockHardness = blockState.func_185887_b(worldIn, pos);
        if (blockHardness < 0.0f && (pos.func_177956_o() < 1 || blockState.func_185904_a() == Material.field_151567_E)) {
            return false;
        }
        return blockState.func_177230_c().canHarvestBlock((IBlockAccess)worldIn, pos, playerIn);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        super.onBlockStartBreak(itemstack, pos, player);
        if (!player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            int mode = ItemStackHelper.getOrCreateCompound(itemstack).func_74762_e("Mode");
            boolean vein = ItemStackHelper.getOrCreateCompound(itemstack).func_74767_n("Vein");
            if (mode == 2 && vein) {
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block == Blocks.field_150439_ay) {
                    block = Blocks.field_150450_ax;
                }
                RayTraceResult raytrace = this.doRayTrace(state, pos, player);
                ItemStack stack = block.getPickBlock(state, raytrace, player.field_70170_p, pos, player);
                List<String> names = OreDictCache.getOreDictName(stack);
                boolean isOre = false;
                for (String s : names) {
                    if (!s.startsWith("ore") && !s.equals("logWood") && !s.equals("treeLeaves")) continue;
                    isOre = true;
                    break;
                }
                if (isOre) {
                    Coord4D orig = new Coord4D(pos, player.field_70170_p);
                    Set<Coord4D> found = new Finder(player, stack, orig, raytrace, vein ? AETS_Config.itemParameters.AGITO_DisassemblerMiningRange : -1).calc();
                    for (Coord4D coord : found) {
                        if (coord.equals(orig)) continue;
                        int destroyEnergy = this.getDestroyEnergy(itemstack, coord.getBlockState((IBlockAccess)player.field_70170_p).func_185887_b(player.field_70170_p, coord.getPos()));
                        if (ElectricItem.manager.getCharge(itemstack) < (double)destroyEnergy) continue;
                        Block block2 = coord.getBlock((IBlockAccess)player.field_70170_p);
                        block2.func_180657_a(player.field_70170_p, player, coord.getPos(), coord.getBlockState((IBlockAccess)player.field_70170_p), coord.getTileEntity((IBlockAccess)player.field_70170_p), itemstack);
                        player.field_70170_p.func_175718_b(2001, coord.getPos(), Block.func_176210_f((IBlockState)state));
                        player.field_70170_p.func_175698_g(coord.getPos());
                        player.field_70170_p.func_175713_t(coord.getPos());
                        ElectricItem.manager.use(stack, (double)ENERGY_USE[2], (EntityLivingBase)player);
                    }
                }
            }
        }
        return false;
    }

    private int getDestroyEnergy(ItemStack itemStack, float hardness) {
        int destroyEnergy = ENERGY_USE[2];
        return hardness == 0.0f ? destroyEnergy / 2 : destroyEnergy;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        SoundType soundType = block.getSoundType(blockState, world, pos, (Entity)player);
        if (!IC2Access.instance.isKeyDown("ModeSwitch", player) && !IC2Access.instance.isKeyDown("Alt", player) && !IC2Access.instance.isKeyDown("Boost", player) && ElectricItem.manager.getCharge(stack) >= (double)ENERGY_USE[2] && this.shouldBreak(player, world, pos)) {
            if (mode == 2) {
                ElectricItem.manager.use(stack, (double)ENERGY_USE[2], (EntityLivingBase)player);
                if (block == Blocks.field_150357_h || block == Blocks.field_150378_br) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)block)));
                } else {
                    blockState.func_177230_c().func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), stack);
                }
                world.func_184133_a(null, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                world.func_175698_g(pos);
                world.func_175713_t(pos);
                return EnumActionResult.SUCCESS;
            }
            if (mode == 0) {
                Block pblock = world.func_180495_p(pos).func_177230_c();
                if (pblock instanceof BlockDoor) {
                    IBlockState iblockstate = world.func_180495_p(pos);
                    BlockPos blockpos = iblockstate.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
                    IBlockState iblockstate1 = pos == blockpos ? iblockstate : world.func_180495_p(blockpos);
                    boolean open = (Boolean)iblockstate1.func_177229_b((IProperty)BlockDoor.field_176519_b);
                    if (!world.field_72995_K) {
                        world.func_180501_a(blockpos, iblockstate1.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(!open)), 10);
                        world.func_175704_b(blockpos, pos);
                        world.func_180498_a((EntityPlayer)null, open ? 1011 : 1005, blockpos, 0);
                    }
                } else if (pblock instanceof BlockTrapDoor) {
                    IBlockState iblockstate = world.func_180495_p(pos);
                    boolean open = (Boolean)iblockstate.func_177229_b((IProperty)BlockTrapDoor.field_176283_b);
                    if (!world.field_72995_K) {
                        world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(!open)), 2);
                        world.func_175704_b(pos, pos);
                        world.func_180498_a((EntityPlayer)null, open ? 1011 : 1005, pos, 0);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public float getMiningSpeed(ItemStack stack, IBlockState state) {
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        boolean canUse = ElectricItem.manager.canUse(stack, (double)ENERGY_USE[mode]);
        if (!canUse) {
            return MINING_SPEED[0];
        }
        if (mode == 0) {
            Material material = state.func_185904_a();
            if (material == Material.field_151569_G || material == Material.field_151592_s || material != Material.field_151584_j) {
                return MINING_SPEED[3];
            }
            return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151572_C ? 1.0f : 1.5f;
        }
        return MINING_SPEED[mode];
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            ElectricItem.manager.use(stack, (double)ENERGY_USE[2], entityLiving);
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (!ElectricItem.manager.canUse(stack, (double)ENERGY_USE[mode])) {
            return 1.0f;
        }
        if (IC2Access.isToolEffective(state, stack)) {
            return this.getMiningSpeed(stack, state);
        }
        if (this.canHarvestBlock(state, stack)) {
            return this.getMiningSpeed(stack, state);
        }
        return this.getMiningSpeed(stack, state);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Items.field_151056_x.func_150897_b(state) || Items.field_151046_w.func_150897_b(state) || Items.field_151047_v.func_150897_b(state) || Items.field_151048_u.func_150897_b(state) || Items.field_151097_aZ.func_150897_b(state);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        return 3;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe", (Object)"sword", (Object)"shears");
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(stack, (IBlockAccess)entity.field_70170_p, pos) && mode == 2 && ElectricItem.manager.canUse(stack, 100.0)) {
                List drops = target.onSheared(stack, (IBlockAccess)entity.field_70170_p, pos, 4);
                for (ItemStack item : drops) {
                    EntityItem ent = entity.func_70099_a(item, 1.0f);
                    ent.field_70181_x += (double)(entity.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
                }
                ElectricItem.manager.use(stack, 100.0, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    private RayTraceResult doRayTrace(IBlockState state, BlockPos pos, EntityPlayer player) {
        double blockReachDistance;
        Vec3d maxReach;
        Vec3d positionEyes = player.func_174824_e(1.0f);
        Vec3d playerLook = player.func_70676_i(1.0f);
        RayTraceResult res = state.func_185910_a(player.field_70170_p, pos, playerLook, maxReach = positionEyes.func_72441_c(playerLook.field_72450_a * (blockReachDistance = player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE).func_111126_e()), playerLook.field_72448_b * blockReachDistance, playerLook.field_72449_c * blockReachDistance));
        return res != null ? res : new RayTraceResult(RayTraceResult.Type.MISS, Vec3d.field_186680_a, EnumFacing.UP, pos);
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.WEAPON;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 5000000.0;
    }

    public int getTier(ItemStack stack) {
        return 3;
    }

    public double getTransferLimit(ItemStack stack) {
        return 512.0;
    }

    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }

    public static class Finder {
        public static Map<Block, List<Block>> ignoreBlocks = new HashMap<Block, List<Block>>();
        private final EntityPlayer player;
        public final World world;
        public final ItemStack stack;
        public final Coord4D location;
        public final Set<Coord4D> found = new HashSet<Coord4D>();
        private final RayTraceResult rayTraceResult;
        private final Block startBlock;
        private final boolean isWood;
        private final int maxRange;
        private final int maxCount;

        public Finder(EntityPlayer p, ItemStack s, Coord4D loc, RayTraceResult traceResult, int range) {
            this.player = p;
            this.world = p.field_70170_p;
            this.stack = s;
            this.location = loc;
            this.startBlock = loc.getBlock((IBlockAccess)this.world);
            this.rayTraceResult = traceResult;
            this.isWood = OreDictCache.getOreDictName(this.stack).contains("logWood");
            this.maxRange = range;
            this.maxCount = AETS_Config.itemParameters.AGITO_DisassemblerMiningCount - 1;
        }

        public void loop(Coord4D pointer) {
            if (this.found.contains(pointer) || this.found.size() > this.maxCount) {
                return;
            }
            this.found.add(pointer);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                ItemStack blockStack;
                Block block;
                Coord4D coord = pointer.offset(side);
                if (this.maxRange > 0 && this.location.distanceTo(coord) > this.maxRange || !coord.exists(this.world) || !this.checkID(block = coord.getBlock((IBlockAccess)this.world)) || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)(blockStack = block.getPickBlock(coord.getBlockState((IBlockAccess)this.world), this.rayTraceResult, this.world, coord.getPos(), this.player))) && (block != this.startBlock || !this.isWood || coord.getBlockMeta((IBlockAccess)this.world) % 4 != this.stack.func_77952_i() % 4)) continue;
                this.loop(coord);
            }
        }

        public Set<Coord4D> calc() {
            this.loop(this.location);
            return this.found;
        }

        public boolean checkID(Block b) {
            Block origBlock = this.location.getBlock((IBlockAccess)this.world);
            List<Block> ignored = ignoreBlocks.get(origBlock);
            return ignored == null ? b == origBlock : ignored.contains(b);
        }

        static {
            ignoreBlocks.put(Blocks.field_150450_ax, Arrays.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
            ignoreBlocks.put(Blocks.field_150439_ay, Arrays.asList(Blocks.field_150450_ax, Blocks.field_150439_ay));
        }
    }
}

