/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAgito_Mk1
extends Item
implements IElectricItem {
    public static final String UNLOCALIZED_NAME = "itemAgitoMk1";
    public static final String NAME = "AgitoMk1";
    public static final int TIER = 2;
    public static final float DAMAGE = 60.0f;
    public static final int STORAGE = 40000;
    public static final int ENERGY_USE = 2000;
    public static final int ENERGY_TRFR_Lim = 128;
    private static int RANGE = 64;
    private static boolean TARGET_IGNORE_WALLS = true;

    public ItemAgito_Mk1() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        EntityPlayer entityLiving = playerIn;
        if (IC2Access.isSimulating()) {
            if (IC2Access.isSimulating()) {
                if (ElectricItem.manager.use(stack, 2000.0, (EntityLivingBase)playerIn)) {
                    worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187539_bB, playerIn.func_184176_by(), 0.8f, 1.0f);
                    Entity currTarget = this.getValidTarget(worldIn, (EntityLivingBase)entityLiving);
                    if (currTarget != null) {
                        this.shootEntity(worldIn, currTarget, (EntityLivingBase)entityLiving, stack);
                    } else {
                        RayTraceResult resultBlock = IC2Access.rayTrace(worldIn, (EntityLivingBase)playerIn, false, RANGE);
                        BlockPos pos = resultBlock.func_178782_a();
                        worldIn.func_72885_a(null, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 5.0f, false, false);
                    }
                } else {
                    worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.agito_RailGun_Low, SoundCategory.NEUTRAL, 0.8f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private void shootEntity(World world, Entity target, EntityLivingBase shooter, ItemStack stack) {
        if (IC2Access.isSimulating()) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)shooter)), 60.0f);
            world.func_72885_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, 3.0f, false, false);
        }
    }

    private Entity getValidTarget(World world, EntityLivingBase source) {
        RayTraceResult result;
        if (IC2Access.isSimulating() && (result = IC2Access.rayTraceEntities(world, source, RANGE)) != null && result.field_72313_a == RayTraceResult.Type.ENTITY && (result.field_72308_g instanceof EntityLivingBase || result.field_72308_g instanceof MultiPartEntityPart || result.field_72308_g instanceof EntityEnderCrystal)) {
            RayTraceResult resultBlock;
            if (!TARGET_IGNORE_WALLS && (resultBlock = IC2Access.rayTrace(world, source, false, result.field_72308_g.func_70032_d((Entity)source))) != null && resultBlock.field_72313_a == RayTraceResult.Type.BLOCK) {
                return null;
            }
            return result.field_72308_g;
        }
        return null;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return 40000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 128.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

