/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import jp.nechiru.advancedelectrictools.entities.EntityTechArrow;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class FireExtinguishingBow
extends ItemBow {
    public static final String UNLOCALIZED_NAME = "itemFireExtinguishingBow";
    public static final String NAME = "Fire Extinguishing Bow";
    public static final int TIER = 2;
    public static final int STORAGE = 40000;
    public static final int ENERGY_TRFR_Lim = 128;
    static final int NORMAL = 0;
    static final int RAPID = 1;
    static final int Extinguishing = 2;
    static final int Teleport = 3;
    static final int[] CHARGE = new int[]{100, 50, 200, 250, 500};
    static final String[] ModeName = new String[]{"Normal", "Rapid", "Extinguishing", "SpreadExtinguishing", "Teleport"};

    public FireExtinguishingBow() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77664_n();
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
                if (mode == 1 || (mode == 2 || mode == 3) && IC2Access.instance.isKeyDown("Boost", (EntityPlayer)entityIn)) {
                    return !(entityIn.func_184607_cu().func_77973_b() instanceof ItemBow) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 5.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof ItemBow) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        EntityPlayer playerIn = (EntityPlayer)entity;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        EntityPlayer player = (EntityPlayer)entity;
        int i = this.func_77626_a(stack) - timeLeft;
        if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)player, (int)i, (boolean)true)) < 0) {
            return;
        }
        if (mode == 1) {
            i *= 6;
        } else if ((mode == 2 || mode == 3) && IC2Access.instance.isKeyDown("Boost", playerIn)) {
            i *= 10;
        }
        float f = FireExtinguishingBow.getArrowVelocity(i);
        if ((double)f < 0.1) {
            return;
        }
        if (!world.field_72995_K) {
            EntityTechArrow arrow = new EntityTechArrow(world, player);
            arrow.setThrower((Entity)player);
            arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 0.5f);
            if (f == 1.5f) {
                arrow.func_70243_d(true);
            }
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            if (mode >= 2) {
                arrow.func_70239_b(4.0);
            } else {
                if (j > 0) {
                    arrow.func_70239_b(arrow.func_70242_d() + arrow.func_70242_d() * 0.25 * (double)(j + 1));
                }
                if (arrow.func_70241_g()) {
                    if (mode == 0) {
                        j += 2;
                    } else if (mode == 1) {
                        ++j;
                    }
                }
                if (j > 0) {
                    arrow.func_70239_b(arrow.func_70242_d() + arrow.func_70242_d() * 0.25 * (double)(j + 1));
                }
            }
            int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            if (k > 0) {
                arrow.func_70240_a(k);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                arrow.func_70015_d(200);
            }
            if (mode == 2 || mode == 3) {
                arrow.setExtinguishing(true);
                arrow.setExtinguishingRange(5 + (int)Math.min(15.0f, f * (5.0f + (float)j)));
            } else if (mode == 4) {
                arrow.setTeleport(true);
            }
            arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            switch (mode) {
                case 0: {
                    if (arrow.func_70241_g()) {
                        this.discharge(stack, CHARGE[mode], (EntityLivingBase)player);
                    } else {
                        this.discharge(stack, CHARGE[0], (EntityLivingBase)player);
                    }
                    world.func_72838_d((Entity)arrow);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    this.discharge(stack, CHARGE[mode], (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                    break;
                }
                case 3: {
                    if (arrow.func_70241_g()) {
                        this.discharge(stack, CHARGE[mode], (EntityLivingBase)player);
                    } else {
                        this.discharge(stack, CHARGE[0], (EntityLivingBase)player);
                    }
                    world.func_72838_d((Entity)arrow);
                    if (!arrow.func_70241_g()) break;
                    EntityTechArrow arrow2 = new EntityTechArrow(world, player);
                    arrow2.func_184547_a((Entity)player, player.field_70125_A + 8.0f, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    arrow2.func_70243_d(true);
                    arrow2.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow3 = new EntityTechArrow(world, player);
                    arrow3.func_184547_a((Entity)player, player.field_70125_A - 8.0f, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    arrow3.func_70243_d(true);
                    arrow3.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow4 = new EntityTechArrow(world, player);
                    arrow4.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z + 8.0f, 0.0f, f * 3.0f, 1.0f);
                    arrow4.func_70243_d(true);
                    arrow4.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow5 = new EntityTechArrow(world, player);
                    arrow5.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z - 8.0f, 0.0f, f * 3.0f, 1.0f);
                    arrow5.func_70243_d(true);
                    arrow5.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    if (j > 0) {
                        arrow2.func_70239_b(arrow2.func_70242_d() + arrow2.func_70242_d() * 0.25 * (double)(j + 1));
                        arrow3.func_70239_b(arrow3.func_70242_d() + arrow3.func_70242_d() * 0.25 * (double)(j + 1));
                        arrow4.func_70239_b(arrow4.func_70242_d() + arrow4.func_70242_d() * 0.25 * (double)(j + 1));
                        arrow5.func_70239_b(arrow5.func_70242_d() + arrow5.func_70242_d() * 0.25 * (double)(j + 1));
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                        arrow2.func_70015_d(200);
                        arrow3.func_70015_d(200);
                        arrow4.func_70015_d(200);
                        arrow5.func_70015_d(200);
                    }
                    arrow2.setExtinguishing(true);
                    arrow2.setExtinguishingRange(5 + (int)Math.min(5.0f, f * 5.0f));
                    arrow3.setExtinguishing(true);
                    arrow3.setExtinguishingRange(5 + (int)Math.min(5.0f, f * 5.0f));
                    arrow4.setExtinguishing(true);
                    arrow4.setExtinguishingRange(5 + (int)Math.min(5.0f, f * 5.0f));
                    arrow5.setExtinguishing(true);
                    arrow5.setExtinguishingRange(5 + (int)Math.min(5.0f, f * 5.0f));
                    world.func_72838_d((Entity)arrow2);
                    world.func_72838_d((Entity)arrow3);
                    world.func_72838_d((Entity)arrow4);
                    world.func_72838_d((Entity)arrow5);
                }
            }
        }
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        player.func_71029_a(StatList.func_188057_b((Item)this));
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        return (f = (f * f + f * 2.0f) / 3.0f) > 1.5f ? 1.5f : f;
    }

    public int func_77626_a(ItemStack stack) {
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        switch (mode) {
            case 2: 
            case 3: {
                return 36000;
            }
            case 1: {
                return 180;
            }
        }
        return 18000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if (!world.field_72995_K && IC2Access.isSimulating() && IC2Access.instance.isKeyDown("ModeSwitch", playerIn)) {
            ++mode;
            stack.func_77978_p().func_74768_a("Mode", mode %= 5);
            IC2Access.messagePlayer(playerIn, TextFormatting.GREEN, "Fire Extinguishing Bow : " + ModeName[mode] + "Mode Enable");
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        if (IC2Access.isSimulating() && IC2Access.instance.isKeyDown("Alt", playerIn)) {
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, "Fire Extinguishing Bow Mode : " + ModeName[mode]);
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        if (this.canUse(stack, CHARGE[mode]) && !IC2Access.instance.isKeyDown("Alt", playerIn) && !IC2Access.instance.isKeyDown("ModeSwitch", playerIn)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        int j;
        int mode = ItemStackHelper.getOrCreateCompound(stack).func_74762_e("Mode");
        if ((mode == 1 || (mode == 2 || mode == 3) && IC2Access.instance.isKeyDown("Boost", (EntityPlayer)player)) && (j = this.func_77626_a(stack) - count) >= 5 && this.canUse(stack, CHARGE[1])) {
            player.func_184597_cx();
        }
    }

    protected abstract void discharge(ItemStack var1, double var2, EntityLivingBase var4);

    protected abstract boolean canUse(ItemStack var1, double var2);

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public int getDefaultMaxCharge() {
        return 40000;
    }

    public int getDefaultTier() {
        return 2;
    }

    public int getDefaultTransferLimit() {
        return 128;
    }
}

