/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AdvancedMiningDrill
extends ItemTool {
    public AdvancedMiningDrill() {
        super(0.0f, -3.0f, Item.ToolMaterial.DIAMOND, new HashSet());
        this.field_77865_bY = 4.0f;
        this.func_77637_a(AdvancedElectricTools.creativeTab);
    }

    public Set<BlockPos> get3X3TargetBlocks(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        HashSet<BlockPos> targetBlocks;
        block9: {
            EnumFacing enumfacing;
            block10: {
                block8: {
                    targetBlocks = new HashSet<BlockPos>();
                    if (playerIn == null) {
                        return new HashSet<BlockPos>();
                    }
                    RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
                    if (raytrace == null || raytrace.field_178784_b == null) {
                        return Collections.emptySet();
                    }
                    enumfacing = raytrace.field_178784_b;
                    if (enumfacing != EnumFacing.SOUTH && enumfacing != EnumFacing.NORTH) break block8;
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            BlockPos newPos = pos.func_177982_a(i, j, 0);
                            if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                            targetBlocks.add(newPos);
                        }
                    }
                    break block9;
                }
                if (enumfacing != EnumFacing.EAST && enumfacing != EnumFacing.WEST) break block10;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.func_177982_a(0, j, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
                break block9;
            }
            if (enumfacing != EnumFacing.DOWN && enumfacing != EnumFacing.UP) break block9;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    BlockPos newPos = pos.func_177982_a(j, 0, i);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            }
        }
        return targetBlocks;
    }

    public Set<BlockPos> get1X3TargetBlocks(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        HashSet<BlockPos> targetBlocks;
        block17: {
            EnumFacing enumFacing2;
            EnumFacing enumfacing;
            block20: {
                block19: {
                    block18: {
                        block16: {
                            targetBlocks = new HashSet<BlockPos>();
                            if (playerIn == null) {
                                return new HashSet<BlockPos>();
                            }
                            RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
                            if (raytrace == null || raytrace.field_178784_b == null) {
                                return Collections.emptySet();
                            }
                            enumfacing = raytrace.field_178784_b;
                            enumFacing2 = playerIn.func_174811_aO();
                            if (enumfacing != EnumFacing.SOUTH) break block16;
                            for (int i = -1; i < 2; ++i) {
                                BlockPos newPos = pos.func_177982_a(i, 0, 0);
                                if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                                targetBlocks.add(newPos);
                            }
                            break block17;
                        }
                        if (enumfacing != EnumFacing.NORTH) break block18;
                        for (int i = -1; i < 2; ++i) {
                            BlockPos newPos = pos.func_177982_a(i, 0, 0);
                            if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                            targetBlocks.add(newPos);
                        }
                        break block17;
                    }
                    if (enumfacing != EnumFacing.EAST) break block19;
                    for (int i = -1; i < 2; ++i) {
                        BlockPos newPos = pos.func_177982_a(0, 0, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                    break block17;
                }
                if (enumfacing != EnumFacing.WEST) break block20;
                for (int i = -1; i < 2; ++i) {
                    BlockPos newPos = pos.func_177982_a(0, 0, i);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
                break block17;
            }
            if (enumfacing != EnumFacing.DOWN && enumfacing != EnumFacing.UP) break block17;
            if (enumFacing2 == EnumFacing.SOUTH) {
                for (int i = -1; i < 2; ++i) {
                    BlockPos newPos = pos.func_177982_a(i, 0, 0);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            } else if (enumFacing2 == EnumFacing.NORTH) {
                for (int i = -1; i < 2; ++i) {
                    BlockPos newPos = pos.func_177982_a(i, 0, 0);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            } else if (enumFacing2 == EnumFacing.EAST) {
                for (int i = -1; i < 2; ++i) {
                    BlockPos newPos = pos.func_177982_a(0, 0, i);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            } else {
                for (int i = -1; i < 2; ++i) {
                    BlockPos newPos = pos.func_177982_a(0, 0, i);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            }
        }
        return targetBlocks;
    }

    public BlockPos get1x2TargetBlock(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        if (playerIn == null) {
            return pos.func_177984_a();
        }
        RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
        if (raytrace == null || raytrace.field_178784_b == null) {
            return pos.func_177984_a();
        }
        EnumFacing enumfacing = raytrace.field_178784_b;
        EnumFacing enumFacing2 = playerIn.func_174811_aO();
        BlockPos newPos = pos.func_177984_a();
        if (enumfacing == EnumFacing.UP || enumfacing == EnumFacing.DOWN) {
            newPos = enumFacing2 == EnumFacing.EAST ? pos.func_177982_a(1, 0, 0) : (enumFacing2 == EnumFacing.WEST ? pos.func_177982_a(-1, 0, 0) : (enumFacing2 == EnumFacing.SOUTH ? pos.func_177982_a(0, 0, 1) : pos.func_177982_a(0, 0, -1)));
        }
        return newPos;
    }

    public boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos originalPos, BlockPos pos) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        float blockHardness = blockState.func_185903_a(playerIn, worldIn, pos);
        if (blockHardness == -1.0f) {
            return false;
        }
        float originalHardness = worldIn.func_180495_p(originalPos).func_185903_a(playerIn, worldIn, originalPos);
        return !(originalHardness / blockHardness > 10.0f);
    }

    protected ItemStack getSilkTouchDrop(IBlockState state) {
        Block blockIn = state.func_177230_c();
        Item item = Item.func_150898_a((Block)blockIn);
        Material material = state.func_185904_a();
        boolean tile = material == Material.field_151584_j;
        int i = 0;
        if (item.func_77614_k()) {
            i = blockIn.func_176201_c(state);
            if (tile) {
                i -= 4;
            }
        }
        return new ItemStack(item, 1, i);
    }

    public void AdvancedharvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        boolean advsilk;
        Block blockIn = state.func_177230_c();
        player.func_71029_a(StatList.func_188055_a((Block)blockIn));
        player.func_71020_j(0.005f);
        boolean bl = advsilk = blockIn == Blocks.field_185774_da || blockIn == Blocks.field_150458_ak || blockIn == Blocks.field_150329_H || blockIn == Blocks.field_150477_bB || blockIn == Blocks.field_150431_aC || state.func_185904_a() == Material.field_151592_s;
        if (blockIn.func_176223_P().func_185917_h() || advsilk) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.getSilkTouchDrop(state);
            if (!itemstack.func_190926_b()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)3, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        } else {
            blockIn.func_176226_b(worldIn, pos, state, 3);
        }
    }
}

