/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.tool.electric;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AdvancedChainsaw
extends ItemAxe {
    public AdvancedChainsaw() {
        super(Item.ToolMaterial.DIAMOND);
        this.field_77865_bY = 4.0f;
        this.func_77637_a(AdvancedElectricTools.creativeTab);
    }

    public Set<BlockPos> getTargetBlocks(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        BlockPos nextPos;
        IBlockState nextState;
        int i;
        HashSet<BlockPos> targetBlocks = new HashSet<BlockPos>();
        if (playerIn == null) {
            return new HashSet<BlockPos>();
        }
        RayTraceResult raytrace = this.func_77621_a(worldIn, playerIn, false);
        if (raytrace == null || raytrace.field_178784_b == null) {
            return Collections.emptySet();
        }
        EnumFacing enumfacing = raytrace.field_178784_b;
        if (enumfacing == EnumFacing.DOWN) {
            return Collections.emptySet();
        }
        BlockPos left = this.left(enumfacing, pos);
        BlockPos leftback = this.back(enumfacing, left);
        BlockPos back = this.back(enumfacing, pos);
        BlockPos right = this.right(enumfacing, pos);
        BlockPos rightback = this.back(enumfacing, right);
        if (enumfacing != EnumFacing.UP && worldIn.func_180495_p(back).func_177230_c().isWood((IBlockAccess)worldIn, back)) {
            targetBlocks.add(back);
            for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = back.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                targetBlocks.add(nextPos);
            }
            if (worldIn.func_180495_p(left).func_177230_c().isWood((IBlockAccess)worldIn, left) && worldIn.func_180495_p(leftback).func_177230_c().isWood((IBlockAccess)worldIn, leftback)) {
                targetBlocks.add(left);
                targetBlocks.add(leftback);
                for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = left.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                    targetBlocks.add(nextPos);
                }
                for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = leftback.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                    targetBlocks.add(nextPos);
                }
            } else if (worldIn.func_180495_p(right).func_177230_c().isWood((IBlockAccess)worldIn, right) && worldIn.func_180495_p(rightback).func_177230_c().isWood((IBlockAccess)worldIn, rightback)) {
                targetBlocks.add(right);
                targetBlocks.add(rightback);
                for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = right.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                    targetBlocks.add(nextPos);
                }
                for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = rightback.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                    targetBlocks.add(nextPos);
                }
            }
        }
        if (worldIn.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)worldIn, pos)) {
            for (i = 1; i < 60 && (nextState = worldIn.func_180495_p(nextPos = pos.func_177981_b(i))).func_177230_c().isWood((IBlockAccess)worldIn, nextPos); ++i) {
                targetBlocks.add(nextPos);
            }
        }
        return targetBlocks;
    }

    public BlockPos left(EnumFacing facing, BlockPos old) {
        if (facing == EnumFacing.NORTH) {
            return old.func_177982_a(1, 0, 0);
        }
        if (facing == EnumFacing.WEST) {
            return old.func_177982_a(0, 0, -1);
        }
        if (facing == EnumFacing.SOUTH) {
            return old.func_177982_a(-1, 0, 0);
        }
        if (facing == EnumFacing.EAST) {
            return old.func_177982_a(0, 0, 1);
        }
        return old;
    }

    public BlockPos right(EnumFacing facing, BlockPos old) {
        if (facing == EnumFacing.NORTH) {
            return old.func_177982_a(-1, 0, 0);
        }
        if (facing == EnumFacing.WEST) {
            return old.func_177982_a(0, 0, 1);
        }
        if (facing == EnumFacing.SOUTH) {
            return old.func_177982_a(1, 0, 0);
        }
        if (facing == EnumFacing.EAST) {
            return old.func_177982_a(0, 0, -1);
        }
        return old;
    }

    public BlockPos back(EnumFacing facing, BlockPos old) {
        if (facing == EnumFacing.NORTH) {
            return old.func_177982_a(0, 0, 1);
        }
        if (facing == EnumFacing.WEST) {
            return old.func_177982_a(1, 0, 0);
        }
        if (facing == EnumFacing.SOUTH) {
            return old.func_177982_a(0, 0, -1);
        }
        if (facing == EnumFacing.EAST) {
            return old.func_177982_a(-1, 0, 0);
        }
        return old;
    }

    private boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos originalPos, BlockPos pos) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        float blockHardness = blockState.func_185903_a(playerIn, worldIn, pos);
        if (blockHardness == -1.0f) {
            return false;
        }
        float originalHardness = worldIn.func_180495_p(originalPos).func_185903_a(playerIn, worldIn, originalPos);
        return !(originalHardness / blockHardness > 10.0f);
    }
}

