/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.armor.base;

import com.google.common.base.Strings;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemArmorBase
extends ItemArmor {
    public ItemArmorBase(ItemArmor.ArmorMaterial materialIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, -1, equipmentSlotIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        EnumMap<ToolTipType, List<String>> dataMap = new EnumMap<ToolTipType, List<String>>(ToolTipType.class);
        dataMap.put(ToolTipType.Ctrl, new LinkedList());
        dataMap.put(ToolTipType.Shift, new LinkedList());
        dataMap.put(ToolTipType.Alt, new LinkedList());
        this.onSortedItemToolTip(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, advanced.func_194127_a(), tooltip, dataMap);
        for (ToolTipType type : new ToolTipType[]{ToolTipType.Alt, ToolTipType.Shift, ToolTipType.Ctrl}) {
            List text = (List)dataMap.get(type);
            if (text.size() <= 0) continue;
            if (type.isKeyDown()) {
                text.add("");
                tooltip.addAll(1, text);
                continue;
            }
            tooltip.add(1, type.getTypeInfo());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
    }

    public abstract String getTexture();

    public abstract ItemStack getRepairItem();

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        boolean overlay;
        String name = this.getTexture() + "_";
        boolean bl = overlay = !Strings.isNullOrEmpty((String)type);
        if (slot == EntityEquipmentSlot.LEGS) {
            if (overlay) {
                return name + "2_" + type + ".png";
            }
            return name + "2.png";
        }
        if (overlay) {
            return name + "1_" + type + ".png";
        }
        return name + "1.png";
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack repairItem = this.getRepairItem();
        if (repairItem == null) {
            return false;
        }
        return StackUtil.isStackEqual((ItemStack)repairItem, (ItemStack)repair);
    }

    public boolean hasOverlay(ItemStack stack) {
        return false;
    }
}

