/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.armor;

import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.entity.IC2DamageSource;
import ic2.core.entity.IC2Potion;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.item.armor.electric.ItemArmorElectricJetpack;
import ic2.core.item.armor.electric.ItemArmorQuantumSuit;
import ic2.core.item.inv.logics.NuclearJetpackLogic;
import ic2.core.item.manager.ElectricItemManager;
import ic2.core.item.misc.ItemTinCan;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.obj.IColorEffectedTexture;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Item.ItemLoader;
import jp.nechiru.advancedelectrictools.Item.armor.ItemReinforcedQuantumSolorHelmet;
import jp.nechiru.advancedelectrictools.Item.armor.base.ItemElectricArmorBase;
import jp.nechiru.advancedelectrictools.Util.AETS_Config;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import jp.nechiru.advancedelectrictools.entities.EntityTechArrow;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReinforcedQuantumSuite
extends ItemElectricArmorBase
implements IMetalArmor,
IColorEffectedTexture,
ItemArmorJetpackBase.IIndirectJetpack {
    public QuantumJetpack jetpack = new QuantumJetpack((Item)this);
    public static final int TIER = 3;
    public static final int STORAGE = 50000000;
    public static final int ENERGY_TRFR_Lim = 81920;
    public static final int ENERGY_PER_DAMAGE = 80;
    public static final int FLYING_ENERGY_PER_TICK = 512;
    public static final int FORCEFIELD_USE_TICK = 5;
    public static final int FORCEFIELD_COST = 200;
    public static final int CYLINDER_COST = 250;
    public static final int[] RMPOTION_COST = new int[]{250, 500, 1000, 400, 500, 250, 150, 500, 250, 500};
    public static final int FOOD_COST = 500;
    public static final int SPLINT_COST = 1000;
    public static final int FALLING_ABSORBED = 1000;
    public static final int HELMET_INDEX = 0;
    public static final int CHESTPLATE_INDEX = 1;
    public static final int LEGGINGS_INDEX = 2;
    public static final int BOOTS_INDEX = 3;

    public ItemReinforcedQuantumSuite(EntityEquipmentSlot equipmentSlotIn) {
        super(equipmentSlotIn, 50000000, 81920, 3);
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(1000);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public double getDamageAbsorptionRatio() {
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            return 1.1;
        }
        return 1.0;
    }

    @Override
    public float getEnergyPerDamage(ItemStack stack) {
        float protection = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180310_c, (ItemStack)stack);
        return 80.0f * (1.0f - protection * 2.0f / 8.0f);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return this.field_77881_a == EntityEquipmentSlot.CHEST && this.canUseEnergy(stack, AETS_Config.itemParameters.RFSuite_disabledSupplyPower);
    }

    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound nbt = stack.func_179543_a("display");
        if (nbt != null) {
            return nbt.func_74764_b("color");
        }
        return false;
    }

    @Override
    public boolean hasOverlay(ItemStack stack) {
        return this.func_82816_b_(stack);
    }

    public void func_82813_b(ItemStack stack, int color) {
        stack.func_190925_c("display").func_74768_a("color", color);
    }

    public int func_82814_b(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74775_l("display").func_74762_e("color");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == EntityEquipmentSlot.FEET) {
            float energyPerDamage = this.getEnergyPerDamage(armor);
            int damageLimit = (int)(energyPerDamage > 0.0f ? ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true) / (double)energyPerDamage : 10000.0);
            return new ISpecialArmor.ArmorProperties(10, (double)(1.0f * IC2.config.getFloat("electricSuitAbsorbtionScale")), damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @Override
    public void damageAbsorbed(EntityPlayer player, int damage) {
        IC2.achievements.issueStat(player, "quantumArmorDamageTaken", damage);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> shiftTip = sortedTooltip.get(ToolTipType.Shift);
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        float thorns = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)stack);
        switch (this.field_77881_a) {
            case HEAD: {
                boolean nv_enabled = nbt.func_74767_n("Nightvision_Enabled");
                shiftTip.add(Ic2InfoLang.qArmorFeedsYou.getLocalized());
                shiftTip.add(Ic2InfoLang.qArmorRemovePotions.getLocalized());
                shiftTip.add(Ic2InfoLang.qArmorGivesAir.getLocalized());
                shiftTip.add(Ic2InfoLang.nightVisionSeeInTheDark.getLocalized());
                if (thorns > 0.0f) {
                    shiftTip.add("Damage reflection");
                }
                ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(4), Ic2InfoLang.nightVisionHudKey}));
                tooltip.add("Nightvision : " + (nv_enabled ? "Enabled" : "Disabled"));
                break;
            }
            case CHEST: {
                boolean forcefield = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("ForceField");
                shiftTip.add(Ic2InfoLang.qArmorRemovesFire.getLocalized());
                if (thorns > 0.0f) {
                    shiftTip.add("Damage reflection");
                }
                this.jetpack.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
                ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(9) + " & " + IC2.keyboard.getKeyName(0), "Enable/Disable the Force Field"}));
                tooltip.add("Force field : " + (forcefield ? "Enabled" : "Disabled"));
                break;
            }
            case LEGS: {
                ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(1), Ic2InfoLang.qArmorHighSpeed}));
                shiftTip.add("High speed running");
                if (!(thorns > 0.0f)) break;
                shiftTip.add("Damage reflection");
                break;
            }
            case FEET: {
                ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(1), Ic2InfoLang.qArmorHighJump}));
                shiftTip.add("Charges between 0-1024EU/t based on how fast you move");
                shiftTip.add("Walking assist");
                if (!(thorns > 0.0f)) break;
                shiftTip.add("Damage reflection");
            }
        }
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
    }

    @SubscribeEvent
    public void onEntityReflectionEvent(LivingHurtEvent event) {
        int thorns;
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        Entity sourceEntity = event.getSource().func_76346_g();
        if (!ItemReinforcedQuantumSuite.isFullRFQuantumSuit(player)) {
            return;
        }
        ItemStack armor = player.field_71071_by.func_70440_f(this.getArmorIndex());
        float energyPerDamage = this.getEnergyPerDamage(armor);
        int toBeUsed = (int)(event.getAmount() * energyPerDamage);
        int energyUsed = (int)((double)toBeUsed * this.getDamageAbsorptionRatio());
        if (armor != null) {
            if (event.getSource() == IC2DamageSource.radiation) {
                event.setCanceled(true);
                return;
            }
            if (event.getSource() == DamageSource.field_180137_b || event.getSource().func_76355_l().equals(IC2DamageSource.electricity.func_76355_l())) {
                double charge = ElectricItem.manager.charge(armor, (double)(event.getAmount() * 10000.0f), 3, true, true);
                event.setCanceled(true);
                return;
            }
        }
        if (armor != null && ElectricItem.manager.canUse(armor, (double)energyUsed) && (thorns = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)armor)) > 0 && !event.getEntityLiving().func_130014_f_().field_72995_K) {
            ElectricItem.manager.use(armor, (double)energyUsed, (EntityLivingBase)player);
            if (sourceEntity instanceof EntityLivingBase && player != sourceEntity && player.func_70068_e(sourceEntity) <= 250.0) {
                sourceEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)event.getEntityLiving()), event.getAmount() * (float)thorns);
                ((EntityLivingBase)sourceEntity).func_70653_a((Entity)player, 1.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)sourceEntity), (Entity)player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityFallEvent(LivingFallEvent evt) {
        EntityLivingBase base = evt.getEntityLiving();
        if (IC2.platform.isSimulating() && base instanceof EntityPlayer) {
            ItemElectricArmorBase base_armor;
            float armorDamage;
            EntityPlayer player = (EntityPlayer)base;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (stack.func_190926_b()) {
                return;
            }
            int fallDamage = (int)evt.getDistance() - 3;
            if (fallDamage >= 8 && stack.func_77973_b() != ItemLoader.rf_quantum_boots) {
                return;
            }
            Item item = stack.func_77973_b();
            if (item == ItemLoader.rf_quantum_boots && ElectricItem.manager.canUse(stack, (double)(armorDamage = (base_armor = (ItemElectricArmorBase)item).getEnergyPerDamage(stack) * (float)fallDamage)) && ElectricItem.manager.use(stack, (double)armorDamage, (EntityLivingBase)player)) {
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void updatePlayerAbilityStatus(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        boolean hasSet;
        if (event.getEntityLiving() instanceof EntityPlayer && !(hasSet = ItemReinforcedQuantumSuite.hasRFQuantumsuitBoots(player = (EntityPlayer)event.getEntityLiving()))) {
            player.field_70138_W = 0.6f;
        }
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return true;
    }

    public static boolean isFullRFQuantumSuit(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        int found = 0;
        for (ItemStack stack : inv.field_70460_b) {
            boolean rf_suite = stack.func_77973_b() instanceof ItemReinforcedQuantumSuite;
            boolean rf_solar_suite = stack.func_77973_b() instanceof ItemReinforcedQuantumSolorHelmet;
            if (stack == null || !rf_suite && !rf_solar_suite) continue;
            ++found;
        }
        return found == 4;
    }

    public int getArmorIndex() {
        switch (this.field_77881_a) {
            case HEAD: {
                return 0;
            }
            case CHEST: {
                return 1;
            }
            case LEGS: {
                return 2;
            }
            case FEET: {
                return 3;
            }
        }
        return 0;
    }

    public void onArmorTick_quantum(World world, EntityPlayer player, ItemStack stack) {
        boolean server = IC2.platform.isSimulating();
        switch (this.field_77881_a) {
            case HEAD: {
                PotionEffect weakness;
                PotionEffect hunger;
                PotionEffect mining;
                PotionEffect nauser;
                PotionEffect slowness;
                PotionEffect glowing;
                PotionEffect blindness;
                PotionEffect wither;
                PotionEffect radiation;
                if (!server) break;
                int air = player.func_70086_ai();
                if (air < 100 && this.canUseEnergy(stack, 250.0)) {
                    player.func_70050_g(air + 200);
                    this.useEnergy(stack, 250.0, (EntityLivingBase)player);
                } else if (air <= 0) {
                    IC2.achievements.issueStat(player, "drownWithQHelmet");
                }
                if (player.func_71024_bL().func_75121_c() && this.canUseEnergy(stack, 500.0)) {
                    ItemStack result;
                    IItemTransporter trans = TransporterManager.manager.getTransporter((Object)player, true);
                    if (trans != null && !(result = trans.removeItem(ItemTinCan.foodCanFilter, EnumFacing.DOWN, 1, true)).func_190926_b()) {
                        ItemTinCan can = (ItemTinCan)result.func_77973_b();
                        can.onFoodEaten(result, world, player);
                        this.useEnergy(stack, 500.0, (EntityLivingBase)player);
                    }
                } else if (player.func_71024_bL().func_75116_a() <= 0) {
                    IC2.achievements.issueStat(player, "starveWithQHelmet");
                }
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
                int ticker = nbt.func_74762_e("Ticker");
                if (ticker > 0) {
                    --ticker;
                }
                boolean enabled = nbt.func_74767_n("Nightvision_Enabled");
                if (ticker <= 0 && IC2.keyboard.isHudModeKeyDown(player) && !IC2.keyboard.isModeSwitchKeyDown(player)) {
                    ticker = 20;
                    enabled = !enabled;
                    nbt.func_74768_a("Ticker", ticker);
                    nbt.func_74757_a("Nightvision_Enabled", enabled);
                    IC2.platform.messagePlayer(player, enabled ? Ic2InfoLang.nightVisionEnabled : Ic2InfoLang.nightVisionDisabled);
                }
                if (enabled && ElectricItem.manager.use(stack, 1.0, (EntityLivingBase)player)) {
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 250, 0, true, false));
                }
                nbt.func_74768_a("Ticker", ticker);
                PotionEffect poison = player.func_70660_b(MobEffects.field_76436_u);
                if (poison != null && this.canUseEnergy(stack, RMPOTION_COST[0] * poison.func_76458_c())) {
                    this.useEnergy(stack, RMPOTION_COST[0] * poison.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76436_u);
                }
                if ((radiation = player.func_70660_b((Potion)IC2Potion.radiation)) != null) {
                    if (ItemReinforcedQuantumSuite.isFullRFQuantumSuit(player)) {
                        IC2.platform.removePotion((EntityLivingBase)player, (Potion)IC2Potion.radiation);
                    } else if (this.canUseEnergy(stack, RMPOTION_COST[1] * radiation.func_76458_c())) {
                        this.useEnergy(stack, RMPOTION_COST[1] * radiation.func_76458_c(), (EntityLivingBase)player);
                        IC2.platform.removePotion((EntityLivingBase)player, (Potion)IC2Potion.radiation);
                    }
                }
                if ((wither = player.func_70660_b(MobEffects.field_82731_v)) != null && this.canUseEnergy(stack, RMPOTION_COST[2] * wither.func_76458_c())) {
                    this.useEnergy(stack, RMPOTION_COST[2] * wither.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_82731_v);
                }
                if ((blindness = player.func_70660_b(MobEffects.field_76440_q)) != null && this.canUseEnergy(stack, RMPOTION_COST[3] * blindness.func_76458_c())) {
                    this.useEnergy(stack, RMPOTION_COST[3] * blindness.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
                }
                if ((glowing = player.func_70660_b(MobEffects.field_188423_x)) != null && this.canUseEnergy(stack, RMPOTION_COST[4] * glowing.func_76458_c())) {
                    this.useEnergy(stack, RMPOTION_COST[4] * glowing.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_188423_x);
                }
                if ((slowness = player.func_70660_b(MobEffects.field_76421_d)) != null && this.canUseEnergy(stack, RMPOTION_COST[5] * slowness.func_76458_c())) {
                    this.useEnergy(stack, RMPOTION_COST[5] * slowness.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76421_d);
                }
                if ((nauser = player.func_70660_b(MobEffects.field_76431_k)) != null && this.canUseEnergy(stack, RMPOTION_COST[6] * nauser.func_76458_c())) {
                    this.useEnergy(stack, RMPOTION_COST[6] * nauser.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76431_k);
                }
                if ((mining = player.func_70660_b(MobEffects.field_76419_f)) != null && this.canUseEnergy(stack, RMPOTION_COST[7] * mining.func_76458_c())) {
                    this.useEnergy(stack, RMPOTION_COST[7] * mining.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76419_f);
                }
                if ((hunger = player.func_70660_b(MobEffects.field_76438_s)) != null && this.canUseEnergy(stack, RMPOTION_COST[8] * hunger.func_76458_c())) {
                    this.useEnergy(stack, RMPOTION_COST[8] * hunger.func_76458_c(), (EntityLivingBase)player);
                    IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76438_s);
                }
                if ((weakness = player.func_70660_b(MobEffects.field_76437_t)) == null || !this.canUseEnergy(stack, RMPOTION_COST[9] * weakness.func_76458_c())) break;
                this.useEnergy(stack, RMPOTION_COST[9] * weakness.func_76458_c(), (EntityLivingBase)player);
                IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76437_t);
                break;
            }
            case CHEST: {
                if (!server) break;
                if (ItemReinforcedQuantumSuite.isFullRFQuantumSuit(player) && player.func_180799_ab() || world.func_72875_a(player.func_174813_aQ().func_72321_a((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151581_o)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 1200, 1, true, false));
                }
                player.func_70066_B();
                NBTTagCompound nbt_b = StackUtil.getOrCreateNbtData((ItemStack)stack);
                int ticker_b = nbt_b.func_74762_e("Ticker_B");
                if (ticker_b > 0) {
                    --ticker_b;
                }
                boolean forcefield = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("ForceField");
                if (ticker_b <= 0 && IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isSneakKeyDown(player)) {
                    ticker_b = 20;
                    forcefield = !forcefield;
                    nbt_b.func_74768_a("Ticker_B", ticker_b);
                    stack.func_77978_p().func_74757_a("ForceField", forcefield);
                    IC2.platform.messagePlayer(player, "RF QuantumiSuite : Force field " + (forcefield ? "enabled" : "disabled"));
                }
                if (forcefield) {
                    ItemReinforcedQuantumSuite.repelEntitiesInAABBFromPoint(stack, player, world, player.func_174813_aQ().func_72314_b(8.0, 8.5, 8.0), player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - 0.1, player.field_70161_v, true);
                }
                nbt_b.func_74768_a("Ticker_B", ticker_b);
                break;
            }
            case LEGS: {
                PlayerHandler handler = PlayerHandler.getHandlerForPlayer((EntityPlayer)player);
                if (!this.canUseEnergy(stack, 1000.0) || (!handler.quantumArmorBoostSprint || !player.func_70051_ag()) && (!handler.boostKeyDown || !player.field_70122_E || !(Math.abs(player.field_70159_w) + Math.abs(player.field_70179_y) > 0.2500000014901161))) break;
                if (++handler.quantumSpeedTicker >= 10) {
                    handler.quantumSpeedTicker = 0;
                    this.useEnergy(stack, 1000.0, (EntityLivingBase)player);
                }
                player.func_191958_b(0.0f, 0.0f, 1.0f, player.func_70090_H() ? 0.5f : 1.1f);
                break;
            }
            case FEET: {
                PlayerHandler handler = PlayerHandler.getHandlerForPlayer((EntityPlayer)player);
                if (handler.quantumJumpCharge < 5.0f && player.field_70122_E && this.canUseEnergy(stack, 1000.0)) {
                    handler.quantumJumpCharge = 5.0f;
                    this.useEnergy(stack, 1000.0, (EntityLivingBase)player);
                }
                if (player.field_70181_x >= 0.0 & handler.quantumJumpCharge > 0.0f && !player.func_70090_H()) {
                    if (handler.jumpKeyDown && handler.boostKeyDown) {
                        if (handler.quantumJumpCharge == 5.0f) {
                            player.field_70159_w *= 3.5;
                            player.field_70179_y *= 3.5;
                        }
                        player.field_70181_x += (double)(handler.quantumJumpCharge * 0.3f);
                        handler.quantumJumpCharge *= 0.75f;
                        break;
                    }
                    if (handler.quantumJumpCharge < 5.0f) {
                        handler.quantumJumpCharge = 0.0f;
                    }
                }
                player.field_70138_W = 1.5625f;
                double distance = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y);
                if (!player.field_70122_E || !(distance >= 0.05)) break;
                ElectricItemManager.chargeArmor((EntityPlayer)player, (int)Math.min(1024, (int)(distance * 800.0)));
            }
        }
    }

    public static void repelEntitiesInAABBFromPoint(ItemStack stack, EntityPlayer player, World world, AxisAlignedBB effectBounds, double x, double y, double z, boolean RFQuantumsuitBody) {
        List list = world.func_72872_a(Entity.class, effectBounds);
        for (Entity ent : list) {
            if (!RFQuantumsuitBody || !(ent instanceof EntityLiving) && !(ent instanceof IProjectile) || AETS_Config.itemParameters.interdictionMode && !(ent instanceof IMob) && !(ent instanceof IProjectile) || ent instanceof EntityArrow && ((EntityArrow)ent).field_70122_E || ent instanceof EntityTechArrow && ((EntityTechArrow)ent).getThrower() == player) continue;
            if ((double)(world.func_72820_D() % 5L) == 0.0) {
                ElectricItem.manager.use(stack, 200.0, (EntityLivingBase)player);
            }
            Vec3d p = new Vec3d(x, y, z);
            Vec3d t = new Vec3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            double distance = p.func_72438_d(t) + 0.1;
            Vec3d r = new Vec3d(t.field_72450_a - p.field_72450_a, t.field_72448_b - p.field_72448_b, t.field_72449_c - p.field_72449_c);
            ent.field_70159_w += r.field_72450_a / 1.5 / distance;
            ent.field_70181_x += r.field_72448_b / 1.5 / distance;
            ent.field_70179_y += r.field_72449_c / 1.5 / distance;
        }
    }

    @Override
    public String getTexture() {
        return "advancedelectrictools:textures/models/armor/rfquantumisuit";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.onArmorTick_quantum(world, player, stack);
        if (this.field_77881_a == EntityEquipmentSlot.CHEST) {
            this.jetpack.onArmorTick(world, player, stack);
        }
    }

    public static boolean hasRFQuantumsuitHelmet(EntityPlayer player) {
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return !head.func_190926_b() && head.func_77973_b() instanceof ItemReinforcedQuantumSuite;
    }

    public static boolean hasRFQuantumsuitBody(EntityPlayer player) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return !chest.func_190926_b() && chest.func_77973_b() instanceof ItemReinforcedQuantumSuite;
    }

    public static boolean hasRFQuantumsuitLegs(EntityPlayer player) {
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        return !legs.func_190926_b() && legs.func_77973_b() instanceof ItemReinforcedQuantumSuite;
    }

    public static boolean hasRFQuantumsuitBoots(EntityPlayer player) {
        ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
        return !boots.func_190926_b() && boots.func_77973_b() instanceof ItemReinforcedQuantumSuite;
    }

    public static boolean hasQuantumLegs(EntityPlayer player) {
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        return !legs.func_190926_b() && legs.func_77973_b() instanceof ItemArmorQuantumSuit;
    }

    public static boolean getArmorCanUse(EntityPlayer player, EntityEquipmentSlot armor) {
        boolean rf_armor;
        ItemStack armor_stack = player.func_184582_a(armor);
        boolean rf_suite = armor_stack.func_77973_b() instanceof ItemReinforcedQuantumSuite || armor_stack.func_77973_b() instanceof ItemReinforcedQuantumSolorHelmet;
        boolean bl = rf_armor = !armor_stack.func_190926_b() && rf_suite;
        return rf_armor ? ElectricItem.manager.getCharge(armor_stack) >= 1000.0 : false;
    }

    public ItemArmorJetpackBase getJetpack() {
        return this.jetpack;
    }

    public static class QuantumJetpack
    extends ItemArmorElectricJetpack {
        Item item;
        public static List<String> playersWithSet = new ArrayList<String>();

        public QuantumJetpack(Item owner) {
            this.item = owner;
        }

        @SideOnly(value=Side.CLIENT)
        public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
            List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
            List<String> shiftTip = sortedTooltip.get(ToolTipType.Shift);
            NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
            boolean age_use = nbt.func_74767_n("age_enabled");
            boolean j_pack = nbt.func_74767_n("disabled");
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(6), Ic2InfoLang.jetpackJumpToFly}));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), Ic2InfoLang.jetpackModeSwitch}));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(0), Ic2InfoLang.jetpackQuickToggle}));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(5), Ic2InfoLang.jetpackToggle}));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(1) + " & " + IC2.keyboard.getKeyName(5), "Enable/Disable the Anti Gravity Engine"}));
            tooltip.add("Jetpack : " + (!j_pack ? "Enabled" : "Disabled"));
            tooltip.add("Anti Gravity Engine : " + (age_use ? "Enabled" : "Disabled"));
        }

        public boolean isElectricJetpack(ItemStack itemStack) {
            return true;
        }

        public boolean canDoAdvHoverMode(ItemStack stack) {
            return true;
        }

        public int getMaxHeight(ItemStack itemStack, int worldheight) {
            return (int)((float)worldheight * 1.171875f);
        }

        public String getTexture() {
            return "";
        }

        public int getTier(ItemStack itemStack) {
            return 3;
        }

        public double getTransferLimit(ItemStack itemStack) {
            return 0.0;
        }

        public int getJetpackUse(ItemStack stack) {
            NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
            return nbt.func_74767_n("age_enabled") ? 2 : nbt.func_74762_e("LastUseMode");
        }

        public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            boolean age_enabled = nbt.func_74767_n("age_enabled");
            PlayerHandler handler = PlayerHandler.getHandlerForPlayer((EntityPlayer)player);
            byte jetpackTicker = nbt.func_74771_c("JetpackTicker");
            boolean server = IC2.platform.isSimulating();
            boolean rf_qsuite_boots = ItemReinforcedQuantumSuite.hasRFQuantumsuitBoots(player);
            if (age_enabled) {
                if (server) {
                    if (jetpackTicker > 0) {
                        jetpackTicker = (byte)(jetpackTicker - 1);
                        nbt.func_74774_a("JetpackTicker", jetpackTicker);
                    } else if (handler.toggleKeyDown && handler.boostKeyDown) {
                        nbt.func_74774_a("JetpackTicker", (byte)10);
                        nbt.func_74757_a("age_enabled", false);
                        IC2.platform.messagePlayer(player, "AntiGravityEngine disabled");
                    }
                }
            } else if (handler.toggleKeyDown && handler.boostKeyDown && jetpackTicker <= 0) {
                if (server) {
                    nbt.func_74757_a("age_enabled", true);
                    nbt.func_74774_a("JetpackTicker", (byte)10);
                    IC2.platform.messagePlayer(player, "AntiGravityEngine Enabled");
                    return;
                }
            } else if (jetpackTicker > 0) {
                jetpackTicker = (byte)(jetpackTicker - 1);
                nbt.func_74774_a("JetpackTicker", jetpackTicker);
            }
            if (age_enabled) {
                if (ElectricItem.manager.getCharge(stack) >= 1024.0) {
                    player.field_71075_bZ.field_75101_c = true;
                    player.field_70138_W = 1.5625f;
                    boolean flying = player.field_71075_bZ.field_75100_b;
                    if (flying) {
                        if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                            if (handler.quantumArmorBoostSprint && player.func_70051_ag() && (ItemReinforcedQuantumSuite.hasQuantumLegs(player) || ItemReinforcedQuantumSuite.hasRFQuantumsuitLegs(player))) {
                                this.useEnergy(player, stack, 1024);
                            } else {
                                this.useEnergy(player, stack, 512);
                            }
                        }
                        boolean sneaking = player.func_70093_af();
                        float speed = 0.08f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                        if (player.field_191988_bg > 0.0f) {
                            player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                        } else if (player.field_191988_bg < 0.0f) {
                            player.func_191958_b(0.0f, 0.0f, 1.0f, -speed * 0.3f);
                        }
                        if (player.field_70702_br != 0.0f) {
                            player.func_191958_b(1.0f, 0.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                        }
                    }
                } else if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                    player.field_70138_W = rf_qsuite_boots ? 1.5625f : 0.6f;
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                }
            } else {
                if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                    player.field_70138_W = rf_qsuite_boots ? 1.5625f : 0.6f;
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                }
                super.onArmorTick(world, player, stack);
            }
        }

        public void onReactorTick(World world, EntityPlayer player, ItemStack stack) {
            NuclearJetpackLogic logic = this.getLogic(player, stack);
            logic.onTick(stack);
            logic.save(stack);
        }

        public NuclearJetpackLogic getLogic(EntityPlayer player, ItemStack stack) {
            return new NuclearJetpackLogic(stack, player, this.field_77881_a);
        }

        public static String playerKey(EntityPlayer player) {
            return player.func_146103_bH().getName() + ":" + player.func_130014_f_().field_72995_K;
        }

        @SubscribeEvent
        public void updatePlayerAbilityStatus(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                String key = QuantumJetpack.playerKey(player);
                ItemStack stack = new ItemStack(ItemLoader.rf_quantum_bodyarmor);
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
                boolean disabled = nbt.func_74767_n("disabled");
                Boolean hasSet = ItemReinforcedQuantumSuite.hasRFQuantumsuitBody(player);
                boolean rf_qsuite_boots = ItemReinforcedQuantumSuite.hasRFQuantumsuitBoots(player);
                if (playersWithSet.contains(key)) {
                    if (!hasSet.booleanValue()) {
                        float f = player.field_70138_W = rf_qsuite_boots ? 1.5625f : 0.6f;
                        if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                            player.field_71075_bZ.field_75101_c = false;
                            player.field_71075_bZ.field_75100_b = false;
                        }
                        playersWithSet.remove(key);
                    }
                } else if (hasSet.booleanValue()) {
                    playersWithSet.add(key);
                }
            }
        }
    }
}

