/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.armor;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.entity.IC2DamageSource;
import ic2.core.entity.IC2Potion;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.manager.ElectricItemManager;
import ic2.core.item.misc.ItemTinCan;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.textures.obj.IColorEffectedTexture;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Item.armor.ItemReinforcedQuantumSuite;
import jp.nechiru.advancedelectrictools.Item.armor.base.ItemElectricArmorBase;
import jp.nechiru.advancedelectrictools.Util.AETS_Config;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReinforcedQuantumSolorHelmet
extends ItemElectricArmorBase
implements IMetalArmor,
IColorEffectedTexture {
    public static final int TIER = 3;
    public static final int STORAGE = 50000000;
    public static final int ENERGY_TRFR_Lim = 81920;
    public static final int ENERGY_PER_DAMAGE = 80;
    public static final int CYLINDER_COST = 250;
    public static final int[] RMPOTION_COST = new int[]{250, 500, 1000, 400, 500, 250, 150, 500, 250, 500};
    public static final int FOOD_COST = 500;
    public static final int SOLAR_CHARGE = 40960;
    public static final int HELMET_INDEX = 0;

    public ItemReinforcedQuantumSolorHelmet() {
        super(EntityEquipmentSlot.HEAD, 50000000, 81920, 3);
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.func_77656_e(1000);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public double getDamageAbsorptionRatio() {
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            return 1.1;
        }
        return 1.0;
    }

    @Override
    public float getEnergyPerDamage(ItemStack stack) {
        float protection = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180310_c, (ItemStack)stack);
        return 80.0f * (1.0f - protection * 2.0f / 8.0f);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return this.field_77881_a == EntityEquipmentSlot.CHEST && this.canUseEnergy(stack, AETS_Config.itemParameters.RFSuite_disabledSupplyPower);
    }

    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound nbt = stack.func_179543_a("display");
        if (nbt != null) {
            return nbt.func_74764_b("color");
        }
        return false;
    }

    @Override
    public boolean hasOverlay(ItemStack stack) {
        return this.func_82816_b_(stack);
    }

    public void func_82813_b(ItemStack stack, int color) {
        stack.func_190925_c("display").func_74768_a("color", color);
    }

    public int func_82814_b(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74775_l("display").func_74762_e("color");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return super.getProperties(player, armor, source, damage, slot);
    }

    @Override
    public void damageAbsorbed(EntityPlayer player, int damage) {
        IC2.achievements.issueStat(player, "quantumArmorDamageTaken", damage);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> shiftTip = sortedTooltip.get(ToolTipType.Shift);
        shiftTip.add(Ic2InfoLang.qArmorFeedsYou.getLocalized());
        shiftTip.add(Ic2InfoLang.qArmorRemovePotions.getLocalized());
        shiftTip.add(Ic2InfoLang.qArmorGivesAir.getLocalized());
        shiftTip.add(Ic2InfoLang.nightVisionSeeInTheDark.getLocalized());
        shiftTip.add("Produces 40960 EU/t while in the sky visible");
        shiftTip.add("Damage reflection");
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
    }

    @SubscribeEvent
    public void onEntityReflectionEvent(LivingHurtEvent event) {
        int thorns;
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        Entity sourceEntity = event.getSource().func_76346_g();
        if (!ItemReinforcedQuantumSuite.isFullRFQuantumSuit(player)) {
            return;
        }
        ItemStack armor = player.field_71071_by.func_70440_f(0);
        float energyPerDamage = this.getEnergyPerDamage(armor);
        int toBeUsed = (int)(event.getAmount() * energyPerDamage);
        int energyUsed = (int)((double)toBeUsed * this.getDamageAbsorptionRatio());
        if (armor != null) {
            if (event.getSource() == IC2DamageSource.radiation) {
                event.setCanceled(true);
                return;
            }
            if (event.getSource() == DamageSource.field_180137_b || event.getSource().func_76355_l().equals(IC2DamageSource.electricity.func_76355_l())) {
                double charge = ElectricItem.manager.charge(armor, (double)(event.getAmount() * 10000.0f), 3, true, true);
                event.setCanceled(true);
                return;
            }
        }
        if (armor != null && ElectricItem.manager.canUse(armor, (double)energyUsed) && (thorns = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)armor)) > 0 && !event.getEntityLiving().func_130014_f_().field_72995_K) {
            ElectricItem.manager.use(armor, (double)energyUsed, (EntityLivingBase)player);
            if (sourceEntity instanceof EntityLivingBase && player != sourceEntity && player.func_70068_e(sourceEntity) <= 250.0) {
                sourceEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)event.getEntityLiving()), event.getAmount() * (float)thorns);
                ((EntityLivingBase)sourceEntity).func_70653_a((Entity)player, 1.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)sourceEntity), (Entity)player);
            }
        }
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return true;
    }

    public void onArmorTick_quantum(World world, EntityPlayer player, ItemStack stack) {
        PotionEffect weakness;
        PotionEffect hunger;
        PotionEffect mining;
        PotionEffect nauser;
        PotionEffect slowness;
        PotionEffect glowing;
        PotionEffect blindness;
        PotionEffect wither;
        PotionEffect radiation;
        NBTTagCompound nbt;
        int ticker;
        boolean server = IC2.platform.isSimulating();
        if (!server) {
            return;
        }
        int air = player.func_70086_ai();
        if (air < 100 && this.canUseEnergy(stack, 250.0)) {
            player.func_70050_g(air + 200);
            this.useEnergy(stack, 250.0, (EntityLivingBase)player);
        } else if (air <= 0) {
            IC2.achievements.issueStat(player, "drownWithQHelmet");
        }
        if (player.func_71024_bL().func_75121_c() && this.canUseEnergy(stack, 500.0)) {
            Object result;
            IItemTransporter trans = TransporterManager.manager.getTransporter((Object)player, true);
            if (trans != null && !(result = trans.removeItem(ItemTinCan.foodCanFilter, EnumFacing.DOWN, 1, true)).func_190926_b()) {
                ItemTinCan can = (ItemTinCan)result.func_77973_b();
                can.onFoodEaten((ItemStack)result, world, player);
                this.useEnergy(stack, 500.0, (EntityLivingBase)player);
            }
        } else if (player.func_71024_bL().func_75116_a() <= 0) {
            IC2.achievements.issueStat(player, "starveWithQHelmet");
        }
        InventoryPlayer inv = player.field_71071_by;
        if (TileEntitySolarPanel.isSunVisible((World)world, (BlockPos)player.func_180425_c())) {
            ElectricItemManager.chargeArmor((EntityPlayer)player, (int)40960);
            for (ItemStack device : inv.field_70462_a) {
                if (player.func_184614_ca() == device || !this.chargeItem(device)) continue;
                break;
            }
        }
        if ((ticker = (nbt = StackUtil.getOrCreateNbtData((ItemStack)stack)).func_74762_e("Ticker")) > 0) {
            --ticker;
        }
        boolean enabled = nbt.func_74767_n("Nightvision_Enabled");
        if (ticker <= 0 && IC2.keyboard.isHudModeKeyDown(player)) {
            ticker = 20;
            enabled = !enabled;
            nbt.func_74757_a("Nightvision_Enabled", enabled);
            IC2.platform.messagePlayer(player, enabled ? Ic2InfoLang.nightVisionEnabled : Ic2InfoLang.nightVisionDisabled);
        }
        if (enabled && ElectricItem.manager.use(stack, 1.0, (EntityLivingBase)player)) {
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 250, 0, true, false));
        }
        nbt.func_74768_a("Ticker", ticker);
        PotionEffect poison = player.func_70660_b(MobEffects.field_76436_u);
        if (poison != null && this.canUseEnergy(stack, RMPOTION_COST[0] * poison.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[0] * poison.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76436_u);
        }
        if ((radiation = player.func_70660_b((Potion)IC2Potion.radiation)) != null) {
            if (ItemReinforcedQuantumSuite.isFullRFQuantumSuit(player)) {
                IC2.platform.removePotion((EntityLivingBase)player, (Potion)IC2Potion.radiation);
            } else if (this.canUseEnergy(stack, RMPOTION_COST[1] * radiation.func_76458_c())) {
                this.useEnergy(stack, RMPOTION_COST[1] * radiation.func_76458_c(), (EntityLivingBase)player);
                IC2.platform.removePotion((EntityLivingBase)player, (Potion)IC2Potion.radiation);
            }
        }
        if ((wither = player.func_70660_b(MobEffects.field_82731_v)) != null && this.canUseEnergy(stack, RMPOTION_COST[2] * wither.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[2] * wither.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_82731_v);
        }
        if ((blindness = player.func_70660_b(MobEffects.field_76440_q)) != null && this.canUseEnergy(stack, RMPOTION_COST[3] * blindness.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[3] * blindness.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
        }
        if ((glowing = player.func_70660_b(MobEffects.field_188423_x)) != null && this.canUseEnergy(stack, RMPOTION_COST[4] * glowing.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[4] * glowing.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_188423_x);
        }
        if ((slowness = player.func_70660_b(MobEffects.field_76421_d)) != null && this.canUseEnergy(stack, RMPOTION_COST[5] * slowness.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[5] * slowness.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76421_d);
        }
        if ((nauser = player.func_70660_b(MobEffects.field_76431_k)) != null && this.canUseEnergy(stack, RMPOTION_COST[6] * nauser.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[6] * nauser.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76431_k);
        }
        if ((mining = player.func_70660_b(MobEffects.field_76419_f)) != null && this.canUseEnergy(stack, RMPOTION_COST[7] * mining.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[7] * mining.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76419_f);
        }
        if ((hunger = player.func_70660_b(MobEffects.field_76438_s)) != null && this.canUseEnergy(stack, RMPOTION_COST[8] * hunger.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[8] * hunger.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76438_s);
        }
        if ((weakness = player.func_70660_b(MobEffects.field_76437_t)) != null && this.canUseEnergy(stack, RMPOTION_COST[9] * weakness.func_76458_c())) {
            this.useEnergy(stack, RMPOTION_COST[9] * weakness.func_76458_c(), (EntityLivingBase)player);
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76437_t);
        }
    }

    private boolean chargeItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof IElectricItem)) {
            return false;
        }
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        double chargeSt = ElectricItem.manager.charge(stack, 40960.0, 4, true, false);
        return chargeSt > 0.0;
    }

    @Override
    public String getTexture() {
        return "advancedelectrictools:textures/models/armor/rfquantumisuit_solar";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.onArmorTick_quantum(world, player, stack);
    }

    public static boolean hasRFQuantumsuitSolorHelmet(EntityPlayer player) {
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return !head.func_190926_b() && head.func_77973_b() instanceof ItemReinforcedQuantumSolorHelmet;
    }

    public static boolean getArmorCanUse(EntityPlayer player, EntityEquipmentSlot armor) {
        boolean rf_armor;
        ItemStack armor_stack = player.func_184582_a(armor);
        boolean bl = rf_armor = !armor_stack.func_190926_b() && armor_stack.func_77973_b() instanceof ItemReinforcedQuantumSolorHelmet;
        return rf_armor ? ElectricItem.manager.getCharge(armor_stack) >= 1000.0 : false;
    }
}

