/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.armor;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Item.armor.ArmorFunctions;
import jp.nechiru.advancedelectrictools.Item.armor.ItemReinforcedQuantumSolorHelmet;
import jp.nechiru.advancedelectrictools.Item.armor.ItemReinforcedQuantumSuite;
import jp.nechiru.advancedelectrictools.Sounds;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReinforcedQuantumRing
extends Item
implements IElectricItem {
    public static final int TIER = 3;
    public static final int STORAGE = 50000000;
    public static final int ENERGY_TRFR_Lim = 500000;
    public static final float ARMOR_ENERGY_USE = 80.0f;
    public static final int FOOD_COST = 100;
    public static final int FIRE_RESISTANCE_COST = 10;
    public static final int RAILGUN_COST = 2500;
    public static final int NIGHTVISION_COST = 100;
    public static final int NIGHTVISION_USE_TICK = 20;
    public static final int FLYING_ENERGY_PER_TICK = 256;
    private static boolean TARGET_IGNORE_WALLS = true;
    public static final int RAILGUN_DAMAGE = 500;
    private static int RAILGUN_RANGE = 1000;
    public static final int RESISTANCE_USE_TICK = 10;

    public ItemReinforcedQuantumRing() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.setNoRepair();
        this.func_77656_e(1000);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "qring_state"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71075_bZ.field_75100_b ? 1.0f : 0.0f;
                }
                return 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        boolean nv_mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("NVMode");
        boolean ic_mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("ICMode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(2) + ") to: Toggle Night Vision");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(1) + ") to: Toggle Item Auto Charge");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Selected Mode");
            tooltip.add("Channeling");
            tooltip.add("");
        } else if (GuiScreen.func_146272_n()) {
            tooltip.add("Removes fire from you");
            tooltip.add("Priority is given to the function of the suit");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
            tooltip.add("Press" + TextFormatting.AQUA + " Shift " + TextFormatting.GRAY + "for Information");
        }
        tooltip.add("Night Vision : " + (nv_mode ? "Enabled" : "Disabled"));
        tooltip.add("Auto Charge : " + (ic_mode ? "Enabled" : "Disabled"));
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        tooltip.add(TextFormatting.GOLD + "Blast protection");
        tooltip.add("");
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            Entity sourceEntity = event.getSource().func_76346_g();
            ItemStack ring = ItemReinforcedQuantumRing.getRing(player);
            if (ring != null) {
                int ubreak = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)ring);
                int energy = (int)(event.getAmount() * 80.0f / (float)(1 + ubreak));
                if (event.getSource() == DamageSource.field_180137_b) {
                    double charge = ElectricItem.manager.charge(ring, (double)(event.getAmount() * 10000.0f), 3, true, true);
                    event.setCanceled(true);
                }
                if (ElectricItem.manager.canUse(ring, (double)energy)) {
                    ElectricItem.manager.use(ring, (double)energy, (EntityLivingBase)player);
                    if (sourceEntity instanceof EntityLivingBase && player != sourceEntity && player.func_70068_e(sourceEntity) <= 250.0) {
                        sourceEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)event.getEntityLiving()), event.getAmount() * 3.0f);
                        ((EntityLivingBase)sourceEntity).func_70653_a((Entity)player, 1.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)sourceEntity), (Entity)player);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    public static ItemStack getRing(EntityPlayer ep) {
        InventoryPlayer inventory = ep.field_71071_by;
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemReinforcedQuantumRing)) continue;
            return stack;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        EntityPlayer entityLiving = playerIn;
        boolean nv_mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("NVMode");
        boolean ic_mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("ICMode");
        boolean mode_key = IC2Access.instance.isKeyDown("ModeSwitch", playerIn);
        boolean ctl_key = IC2Access.instance.isKeyDown("Boost", playerIn);
        boolean alt_key = IC2Access.instance.isKeyDown("Alt", playerIn);
        if (!worldIn.field_72995_K && !alt_key) {
            if (ctl_key) {
                ic_mode = !ic_mode;
                stack.func_77978_p().func_74757_a("ICMode", ic_mode);
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, ic_mode ? "QuantumRing : Auto charge enabled" : "QuantumRing : Auto charge disabled");
            } else if (!ItemReinforcedQuantumSuite.getArmorCanUse(playerIn, EntityEquipmentSlot.HEAD) && mode_key) {
                nv_mode = !nv_mode;
                stack.func_77978_p().func_74757_a("NVMode", nv_mode);
                IC2Access.messagePlayer(playerIn, TextFormatting.AQUA, nv_mode ? "QuantumRing : Night vision enabled" : "QuantumRing : Night vision disabled");
            }
        }
        if (!worldIn.field_72995_K && IC2Access.isSimulating() && alt_key) {
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, nv_mode ? "QuantumRing : Night vision enabled" : "QuantumRing : Night vision disabled");
            IC2Access.messagePlayer(playerIn, TextFormatting.GOLD, ic_mode ? "Auto charge enabled" : "Auto charge disabled");
        }
        if (!worldIn.field_72995_K && IC2Access.isSimulating() && !mode_key && !alt_key && !ctl_key && ElectricItem.manager.use(stack, 2500.0, (EntityLivingBase)playerIn)) {
            Entity currTarget = this.getValidTarget(worldIn, (EntityLivingBase)entityLiving);
            if (currTarget != null) {
                this.shootEntity(worldIn, playerIn, currTarget, (EntityLivingBase)entityLiving, stack);
            } else {
                RayTraceResult resultBlock = IC2Access.rayTrace(worldIn, (EntityLivingBase)playerIn, false, RAILGUN_RANGE);
                BlockPos pos = resultBlock.func_178782_a();
                int random = (int)Math.max(worldIn.field_73012_v.nextGaussian() * 3.0, 0.0);
                float exp_pow = worldIn.func_72896_J() ? (float)random : 0.0f;
                Vec2f pos1 = new Vec2f((float)playerIn.field_70165_t, (float)playerIn.field_70161_v);
                Vec2f pos2 = new Vec2f((float)pos.func_177958_n(), (float)pos.func_177952_p());
                if (this.MathPosDistance(pos1, pos2) > 8.0) {
                    this.Lightning(worldIn, (Entity)playerIn, 3, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                worldIn.func_72885_a((Entity)playerIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 7.0f + exp_pow, false, false);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private void shootEntity(World world, EntityPlayer playerIn, Entity target, EntityLivingBase shooter, ItemStack stack) {
        if (IC2Access.isSimulating()) {
            int random = (int)Math.max(world.field_73012_v.nextGaussian() * 3.0, 0.0);
            target.func_70015_d(200);
            EntityLivingBase targetLiving = (EntityLivingBase)target;
            targetLiving.field_70172_ad = 0;
            targetLiving.field_70737_aN = 0;
            targetLiving.field_70738_aO = 0;
            target.func_70097_a(DamageSource.field_180137_b, 500.0f);
            PotionEffect potioneffect = new PotionEffect(MobEffects.field_76421_d, 200, 3, false, false);
            ((EntityLivingBase)target).func_70690_d(potioneffect);
            potioneffect = new PotionEffect(MobEffects.field_76440_q, 200, 3, false, false);
            ((EntityLivingBase)target).func_70690_d(potioneffect);
            this.Lightning(playerIn.field_70170_p, (Entity)playerIn, 3, target.field_70165_t, target.field_70163_u, target.field_70161_v);
        }
    }

    private void Lightning(World world, Entity entityIn, int ThunderNum, double posX, double posY, double posZ) {
        int rain = world.func_72896_J() ? 4 : 0;
        int random = (int)Math.max(world.field_73012_v.nextGaussian() * 3.0, 0.0);
        for (int i = 0; i < ThunderNum + rain + random; ++i) {
            EntityLightningBolt entityLightningBolt = new EntityLightningBolt(world, posX + world.field_73012_v.nextGaussian(), posY + world.field_73012_v.nextGaussian(), posZ + world.field_73012_v.nextGaussian(), false);
            world.func_72942_c((Entity)entityLightningBolt);
        }
        SoundEvent channering = (double)field_77697_d.nextFloat() > 0.4 ? Sounds.Channeling1 : Sounds.Channeling0;
        world.func_184148_a((EntityPlayer)null, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, channering, SoundCategory.NEUTRAL, (float)(ThunderNum + rain + random - 2), 1.0f / (world.field_73012_v.nextFloat() * 0.2f + 0.8f));
    }

    private Entity getValidTarget(World world, EntityLivingBase source) {
        RayTraceResult result;
        if (IC2Access.isSimulating() && (result = IC2Access.rayTraceEntities(world, source, RAILGUN_RANGE)) != null && result.field_72313_a == RayTraceResult.Type.ENTITY && (result.field_72308_g instanceof EntityLivingBase || result.field_72308_g instanceof MultiPartEntityPart || result.field_72308_g instanceof EntityEnderCrystal)) {
            RayTraceResult resultBlock;
            if (!TARGET_IGNORE_WALLS && (resultBlock = IC2Access.rayTrace(world, source, false, result.field_72308_g.func_70032_d((Entity)source))) != null && resultBlock.field_72313_a == RayTraceResult.Type.BLOCK) {
                return null;
            }
            return result.field_72308_g;
        }
        return null;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        EntityPlayer player = (EntityPlayer)entity;
        boolean flying = player.field_71075_bZ.field_75100_b;
        boolean fly_old = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("FlyOld");
        boolean rf_qsuite_head = ItemReinforcedQuantumSuite.hasRFQuantumsuitHelmet(player);
        boolean rf_qsuite_solarhead = ItemReinforcedQuantumSolorHelmet.hasRFQuantumsuitSolorHelmet(player);
        boolean rf_qsuite_body = ItemReinforcedQuantumSuite.hasRFQuantumsuitBody(player);
        boolean rf_qsuite_legs = ItemReinforcedQuantumSuite.hasRFQuantumsuitLegs(player);
        boolean rf_qsuite_feet = ItemReinforcedQuantumSuite.hasRFQuantumsuitBoots(player);
        if (flying && !fly_old) {
            player.func_184185_a(Sounds.AGE_ON, 0.8f, 1.0f);
        }
        stack.func_77978_p().func_74757_a("FlyOld", flying);
        if (slot > 8 || !(entity instanceof EntityPlayer)) {
            if (!(rf_qsuite_body || player.field_71075_bZ.field_75098_d || player.func_175149_v())) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
            }
            if (!rf_qsuite_feet) {
                player.field_70138_W = 0.6f;
            }
            return;
        }
        boolean nv_mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("NVMode");
        boolean ic_mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("ICMode");
        InventoryPlayer inv = player.field_71071_by;
        boolean didSomething = false;
        if (ic_mode) {
            for (ItemStack device : inv.field_70460_b) {
                if (!this.chargeItem(device, stack)) continue;
                didSomething = true;
                break;
            }
            if (!didSomething) {
                for (ItemStack device : inv.field_70462_a) {
                    if (device != null && device.func_77973_b() instanceof ItemReinforcedQuantumRing || !this.chargeItem(device, stack)) continue;
                    didSomething = true;
                    break;
                }
            }
        }
        if (!ItemReinforcedQuantumSuite.getArmorCanUse(player, EntityEquipmentSlot.CHEST) && (player.func_70027_ad() || player.func_180799_ab() || world.func_72875_a(player.func_174813_aQ().func_72321_a((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151581_o)) && ElectricItem.manager.canUse(stack, 10.0)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 1200, 0, true, false));
            if (world.func_72820_D() % 10L == 0L) {
                ElectricItem.manager.use(stack, 10.0, (EntityLivingBase)player);
            }
        }
        if (!ItemReinforcedQuantumSuite.getArmorCanUse(player, EntityEquipmentSlot.CHEST)) {
            ArmorFunctions.extinguish(player, world);
            ArmorFunctions.fly(256, player, stack, world);
            if (!rf_qsuite_head && !rf_qsuite_solarhead && nv_mode) {
                if (ElectricItem.manager.canUse(stack, 100.0)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 250, 10, true, false));
                    if ((double)(world.func_72820_D() % 20L) == 0.0) {
                        ElectricItem.manager.use(stack, 100.0, (EntityLivingBase)player);
                    }
                } else {
                    stack.func_77978_p().func_74757_a("NVMode", false);
                    IC2Access.messagePlayer(player, TextFormatting.AQUA, "QuantumiRing : Night vision disable");
                }
            }
        }
        if (!ItemReinforcedQuantumSuite.getArmorCanUse(player, EntityEquipmentSlot.HEAD)) {
            ArmorFunctions.helmetFunctions(world, player, stack, 100);
        }
        if (!ItemReinforcedQuantumSuite.getArmorCanUse(player, EntityEquipmentSlot.FEET)) {
            ArmorFunctions.jumpBooster(world, player, stack, 2.5f, 5.0);
            player.field_70138_W = 1.5625f;
        }
        if (!ItemReinforcedQuantumSuite.getArmorCanUse(player, EntityEquipmentSlot.LEGS)) {
            ArmorFunctions.speedUp(player, stack, 1.0f);
        }
    }

    public double MathPosDistance(Vec2f pos1, Vec2f pos2) {
        double dx = pos1.field_189982_i - pos2.field_189982_i;
        double dy = pos1.field_189983_j - pos2.field_189983_j;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public boolean chargeItem(ItemStack stack, ItemStack ring) {
        if (stack == null) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof IElectricItem)) {
            return false;
        }
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        if (!ElectricItem.manager.canUse(ring, item.getTransferLimit(stack))) {
            return false;
        }
        double chargeSt = ElectricItem.manager.charge(stack, item.getTransferLimit(stack), 3, false, false);
        double dischSt = ElectricItem.manager.discharge(ring, chargeSt, 3, true, false, false);
        return chargeSt > 0.0 && dischSt > 0.0;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 5.0E7;
    }

    public int getTier(ItemStack itemStack) {
        return 3;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 500000.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

