/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.armor;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.item.armor.electric.ItemArmorQuantumSuit;
import java.util.List;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Item.ItemLoader;
import jp.nechiru.advancedelectrictools.Item.armor.ArmorFunctions;
import jp.nechiru.advancedelectrictools.Item.armor.base.ItemElectricArmorBase;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemQuantumRing
extends Item
implements IElectricItem {
    public static final int TIER = 3;
    public static final int STORAGE = 4000000;
    public static final int ENERGY_TRFR_Lim = 500000;
    public static final double ARMOR_ENERGY_USE = 50.0;
    public static final int FOOD_COST = 100;
    public static final int FIRE_RESISTANCE_COST = 10;
    public static final int RESISTANCE_USE_TICK = 10;

    public ItemQuantumRing() {
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.setNoRepair();
        this.func_77656_e(1000);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (GuiScreen.func_146272_n()) {
            tooltip.add("Removes fire from you");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.AQUA + " Shift " + TextFormatting.GRAY + "for Information");
        }
        tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        tooltip.add("");
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) return;
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        Entity sourceEntity = event.getSource().func_76346_g();
        ItemStack ring = ItemQuantumRing.getRing(player);
        if (ItemQuantumRing.hasQuantumsuitHelmet(player)) {
            if (ItemQuantumRing.hasQuantumsuitBody(player)) {
                if (ItemQuantumRing.hasQuantumsuitLegs(player)) {
                    if (ItemQuantumRing.hasQuantumsuitBoots(player)) {
                        return;
                    }
                }
            }
        }
        boolean bl = false;
        boolean quantum_armor = bl;
        if (quantum_armor) return;
        if (ring == null) return;
        int energy = (int)((double)event.getAmount() * 50.0);
        if (!ElectricItem.manager.canUse(ring, (double)energy)) return;
        ElectricItem.manager.use(ring, (double)energy, (EntityLivingBase)player);
        if (sourceEntity instanceof EntityLivingBase && player != sourceEntity && player.func_70068_e(sourceEntity) <= 250.0) {
            sourceEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)event.getEntityLiving()), event.getAmount());
            ((EntityLivingBase)sourceEntity).func_70653_a((Entity)player, 1.0f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
            EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)sourceEntity), (Entity)player);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onEntityFallEvent(LivingFallEvent evt) {
        EntityLivingBase base = evt.getEntityLiving();
        if (IC2.platform.isSimulating() && base instanceof EntityPlayer) {
            ItemElectricArmorBase base_armor;
            float armorDamage;
            EntityPlayer player = (EntityPlayer)base;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (stack.func_190926_b()) {
                return;
            }
            int fallDamage = (int)evt.getDistance() - 3;
            if (fallDamage >= 8 && stack.func_77973_b() != ItemLoader.quantum_ring) {
                return;
            }
            Item item = stack.func_77973_b();
            if (item == ItemLoader.quantum_ring && ElectricItem.manager.canUse(stack, (double)(armorDamage = (base_armor = (ItemElectricArmorBase)item).getEnergyPerDamage(stack) * (float)fallDamage)) && ElectricItem.manager.use(stack, (double)armorDamage, (EntityLivingBase)player)) {
                evt.setCanceled(true);
            }
        }
    }

    public static ItemStack getRing(EntityPlayer ep) {
        InventoryPlayer inventory = ep.field_71071_by;
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemQuantumRing)) continue;
            return stack;
        }
        return null;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        EntityPlayer player = (EntityPlayer)entity;
        boolean qsuite_head = ItemQuantumRing.hasQuantumsuitHelmet(player);
        boolean qsuite_body = ItemQuantumRing.hasQuantumsuitBody(player);
        boolean qsuite_legs = ItemQuantumRing.hasQuantumsuitLegs(player);
        boolean qsuite_feet = ItemQuantumRing.hasQuantumsuitBoots(player);
        if (slot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        if (!qsuite_body) {
            ArmorFunctions.extinguish(player, world);
            if ((player.func_70027_ad() || player.func_180799_ab()) && ElectricItem.manager.canUse(stack, 10.0)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 250, 0, true, false));
                if (world.func_72820_D() % 10L == 0L) {
                    ElectricItem.manager.use(stack, 10.0, (EntityLivingBase)player);
                }
            }
        }
        if (!qsuite_head) {
            ArmorFunctions.helmetFunctions(world, player, stack, 100);
        }
        if (!qsuite_feet) {
            ArmorFunctions.jumpBooster(world, player, stack, 1.0f, 3.5);
        }
        if (!qsuite_legs) {
            ArmorFunctions.speedUp(player, stack, 0.22f);
        }
    }

    public static boolean hasQuantumsuitHelmet(EntityPlayer player) {
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return !head.func_190926_b() && head.func_77973_b() instanceof ItemArmorQuantumSuit;
    }

    public static boolean hasQuantumsuitBody(EntityPlayer player) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return !chest.func_190926_b() && chest.func_77973_b() instanceof ItemArmorQuantumSuit;
    }

    public static boolean hasQuantumsuitLegs(EntityPlayer player) {
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        return !legs.func_190926_b() && legs.func_77973_b() instanceof ItemArmorQuantumSuit;
    }

    public static boolean hasQuantumsuitBoots(EntityPlayer player) {
        ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
        return !boots.func_190926_b() && boots.func_77973_b() instanceof ItemArmorQuantumSuit;
    }

    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 4000000.0;
    }

    public int getTier(ItemStack itemStack) {
        return 3;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 500000.0;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

